<object name="mp3_player">
  <window title="Freaky-Coo-MP3" name="mp3_player"
          ondelete="close_down"
          height="570" width="650">
    <halign>
      <frame visible="true" title="Play Queue" expand="true">
        <ctree name="playqueue" cols="3" onselect="play_song"
               expand="true" height="140" >
          <ctree-column name="filename" title="Filename" auto-resize="true"/>
              <ctree-column name="length" title="Length" auto-resize="true"/>
              <ctree-column name="bitrate" title="Bitrate" auto-resize="true"/>
        </ctree>
      </frame>
      <vslider name="vol" onchange="set_vol"/>
    </halign>

    <frame title="Database">
      <entry name="search_path" text="/home/john/music"/>
      <halign>
        <button onclick="rebuild_db" label="Rebuild the database"/>
        <button onclick="append_db" label="Append to database"/>
        <button onclick="stop" label="Stop mpg123"/>
      </halign>
    </frame>

    <frame title="Search">
      <entry name="search" text="" onenter="find_songs"/>
    </frame>

    <frame expand="true" title="Results">
      <scrollwindow expand="true">
        <ctree name="mp3s" cols="1" onselect="move_to_queue" 
               expand="true">
	  <ctree-column name="file" title="Filename"/>
        </ctree>
      </scrollwindow>
    </frame>
  </window>
  <data name="appenders" />
  <io name="rebuild" mode="line" onnewdata="append_to_db" />
  <perl><![CDATA[

use Symbol;
use POSIX ":sys_wait_h";
%ENV;
$HOME = $ENV{HOME};
$table_file = "$HOME/.mp3list";  # Where the list goes.
load_db();
load_mixer_settings();

sub load_mixer_settings
{
	my $output = `aumix -v q`;    # Returns "vol 46, 46"

	my @words = split(/\ /, $output);

	my $vol = $words[2];
	print "Starting volume is $vol\n";

	my $slider = enode("vslider.vol");
	$slider->attrib("value" => $vol);
}

sub set_vol
{
	my $spinner = shift;
	my $val = $spinner->attrib("value");
	`aumix -v $val`;
}

sub query_playing_song
{
	my $timer = shift;
	my $pid = $timer->attrib("pid");

	if (-1 == waitpid($pid, &WNOHANG) )
	{
		my $row = enode( $timer->attrib("row") );
		$row->destroy();
		$timer->destroy();
		play_queue_marshall_next();
	}
}

sub load_db
{
	open TABLE_FILE, "<$table_file";
	@mp3s = <TABLE_FILE>;
}

sub append_to_db
{
	my ($io, $data, $size) = @_;   # $data is a line (mp3)
	if (0 == $size)
	{
		print "closing time\n";
		close ( $io->attrib("fh") );
		$io->attrib("fd" => "-1");

		if ($io->attrib_is_true ("rebuild") )
		{
			enode ("button.rebuild")->attrib ("sensitive" => "true");
		}
		$io->destroy();
		my $object = enode("object.mp3_player");
		$object->new_child("io.rebuild",
		                   "mode" => "line",
		                   "onnewdata" => "append_to_db");
		return;
	}
	
	push @mp3s, $data;
	print TABLE_FILE $data;
}

sub rebuild_db
{
	my $rebuild_button = shift;

	my $io = enode("io.rebuild");
	my $fh = FH.$io;
	my $entry = enode("entry.search_path");
	my $search_path = $entry->attrib("text");

	# The SLOW_IS_A_GOOBER factor.
	# $rebuild_button->attrib ("sensitive" => "false");

	enode ("data.appenders")->destroy_children ();

	close TABLE_FILE;
	unlink($table_file);                 # Delete the file.
	open TABLE_FILE, ">$table_file";

	@mp3s = ();                          # DB gone too.

	open ($fh, "find $search_path -name '*.mp3*'|");
	$io->attrib("fd" => fileno($fh), "fh" => $fh, "rebuild" => "true");
}

sub append_db
{
	my $io_holder = enode("data.appenders");
	my $io = $io_holder->new_child ("io",
	                                "mode" => "line",
	                                "onnewdata" => "append_to_db");

	my $fh = FH.$io;
	my $entry = enode("entry.search_path");
	my $search_path = $entry->attrib("text");
	
	open ($fh, "find $search_path -name '*.mp3*'|");
	$io->attrib("fd" => fileno($fh), "fh" => $fh);
}

sub find_songs
{
	my $entry = shift;
	my $request = $entry->attrib("text");
	my $ctree = enode("ctree.mp3s");

	$ctree->attrib("frozen" => "true");
	#$ctree->destroy_children();

	foreach my $row ($ctree->children() )
	{
		$row->destroy();
	}

	$ctree->attrib("frozen" => "false");

	#print "starting search for --$request--\n";
	$ctree->attrib("frozen" => "true");
	foreach my $mp3 (@mp3s)
	{
		if($mp3 =~ /$request/)   ###    && $mp3 !~ /\&|\'/)
		{
			#print "$mp3 matches\n";

			my $ctree_row = $ctree->new_child("ctree-row");
			my $cell = $ctree_row->new_child("ctree-cell.mp3",
			                                 "text" => "$mp3");
		}
	}
	$ctree->attrib("frozen" => "false");
}
my $mpg123_PID;
sub play_song
{
	my $ctree_row = shift;
	my $filename_cell = $ctree_row->child("ctree-cell.filename");
	my $filename = $filename_cell->attrib("text");

	if ($mpg123_PID)
	{
		kill (9, $mpg123_PID);
	}
	close (MP3);
	chop $filename;
	$filename = qq!"!.$filename.qq!"\n!;  #put ""s and newline
	print "mpg123 $filename";
	$mpg123_PID = open (MP3, "|mpg123 -b 512 $filename");

	#$ctree_row->destroy();     # Remove the entry from the ctree.
	my $cell = $ctree_row->child("ctree-cell");
	$cell->attrib("image" => "playing.xpm");

	my $object = enode("object");
	my $timer_xml = qq!
	<timer name="cursong" pid="$mpg123_PID"
	       interval="300" action="query_playing_song" row="$ctree_row">!;

	$object->append_xml($timer_xml);
}
sub move_to_queue
{
	my $ctree_row = shift;
	my $cell = $ctree_row->child("ctree-cell.mp3");
	my $filename = $cell->attrib("text");

	my $ctree = enode("ctree.playqueue");

	my $new_row = $ctree->new_child("ctree-row");
	$new_row->new_child("ctree-cell.filename", "text" => "$filename");
	$new_row->new_child("ctree-cell.length", "text" => "unknown");
	$new_row->new_child("ctree-cell.bitrate", "text" => "unknown");
}
sub play_queue_marshall_next
{
	my $ctree = enode("ctree.playqueue");
	my $row = $ctree->child("ctree-row");
	if ($row)
	{
		$row->attrib("selected" => "true");
	}
}
sub stop
{
	if($mpg123_PID)
	{
		kill (9, $mpg123_PID);
	}
	close (MP3);
}

sub close_down
{
	if($mpg123_PID)
	{
		kill (9, $mpg123_PID);
	}
	close (MP3);
	exit();
}
  ]]></perl>
</object>
