#include <glib.h>
#include <gmodule.h>

#include "mainloop.h"
#include "entity.h"

/* This will be the current running main loop. */
EntityMainLoop *entity_mainloop = NULL;

/* Created at startup of each entity server. */
extern GMainLoop *baby_main_loop;


/* After calling initialization function, if it has a controlling loop, it *
 * will register it here.  Called by gtk renderers and by other toolkits.  */
void
mainloop_register (gchar * loopname,
		   MainLoopFunc mainloop,
		   EIOAddFunc addfunc, EIORemoveFunc removefunc)
{

    /* Its ok to overwrite the baby entity mainloop. */
    if (entity_mainloop && g_str_equal (entity_mainloop->loopname, "baby_main")) {
	g_free (entity_mainloop->loopname);
	g_free (entity_mainloop);
	entity_mainloop = NULL;
    } else if (entity_mainloop) {
	g_warning ("Can't register second mainloop '%s'", loopname);
	g_warning ("Current mainloop is '%s'\n", entity_mainloop->loopname);
	return;
    }

    entity_mainloop = g_new0 (EntityMainLoop, 1);
    entity_mainloop->loopname = g_strdup (loopname);
    entity_mainloop->mainloop = mainloop;

    entity_mainloop->io_add = addfunc;
    entity_mainloop->io_remove = removefunc;
}

void
entity_mainloop_run (void)
{
    if (!entity_mainloop) {
	g_warning
	    ("No Mainloop was registered for Entity.  This usually indicates a bad installation");
    } else {
	entity_mainloop->mainloop ();	/* Loop waiting on the tree. */
    }
}


gint entity_mainloop_is_registered (void)
{
    if (entity_mainloop) {
	return (TRUE);
    } else {
	return (FALSE);
    }
}

void *
entity_mainloop_io_add (int fd, EIOCond cond, EIOFunc func, void *data)
{
    return (entity_mainloop->io_add (fd, cond, func, data));
}

void
entity_mainloop_io_remove (void *tag)
{
    entity_mainloop->io_remove (tag);
}

/* FIXME: This is borked.. */
void
entity_mainloop_exit (void)
{
    exit (0);
}




