#include "csink.h"

#ifdef CSINK_ENTITY

CBuf *
cbuf_new_with_data (char *str, int len)
{
    return ebuf_new_with_data (str, len);
}

CBuf *
cbuf_new_with_cbuf (CBuf * e)
{
    return ebuf_new_with_ebuf (e);
}


CBuf *
cbuf_new_with_str (char *str)
{
    return ebuf_new_with_str (str);
}

void
cbuf_free (CBuf * e)
{
    ebuf_free (e);
}

CBuf *
cbuf_append_cbuf (CBuf * a, CBuf * b)
{
    return ebuf_append_ebuf (a, b);
}

/* THIS IS A KLUDGE */
/* REMOVE ME REMOVE ME REMOVE ME */

void
cdebug (char *domain, char *format, ...)
{
    va_list args;
    char *string;

    va_start (args, format);
    string = g_strdup_vprintf (format, args);
    va_end (args);

    g_print ("%s: %s\n", domain, string);
}


#else

CBuf *
cbuf_new_with_data (char *str, int len)
{
    char *copy;
    CBuf *cbuf;

    cbuf = (CBuf *) malloc (sizeof (CBuf));
    copy = (char *) malloc (len);
    memcpy (copy, str, len);

    cbuf->str = copy;
    cbuf->len = len;

    return cbuf;
}

CBuf *
cbuf_new_with_cbuf (CBuf * e)
{
    return cbuf_new_with_data (e->str, e->len);
}

CBuf *
cbuf_new_with_str (char *str)
{
    return cbuf_new_with_data (str, strlen (str));
}


void
cbuf_free (CBuf * e)
{
    if (e) {
	if (e->str) {
	    free (e->str);
	    e->str = NULL;
	} else {
	    printf ("BARF!\n");
	}
	free (e);
    }
}

CBuf *
cbuf_append_cbuf (CBuf * a, CBuf * b)
{
    char *newstr = (char *) malloc (a->len + b->len);

    memcpy (newstr, a, a->len);
    memcpy (newstr + a->len, b, b->len);
    free (a->str);

    a->str = newstr;
    a->len += b->len;

    return a;
}



#endif
