#ifndef __CSINKINET_H__
#define __CSINKINET_H__

/* csinkinet.h * * Author(s): Mike Harrison, Cory Stone */

#include <unistd.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/poll.h>
#include <sys/time.h>
#include <netdb.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>


#include "csink.h"


/* Casting macros */
#define CSINK_INET(sink)		( (CSinkInet*)sink )


typedef struct _CSinkInet CSinkInet;

#define ISS_CONNECTED               (1 << 1)
#define ISS_CONNECT_INPROGRESS      (1 << 2)
#define ISS_DNS_INPROGRESS_REMOTE   (1 << 3)
#define ISS_DNS_INPROGRESS_LOCAL    (1 << 4)

#define ISS_DNS_INPROGRESS  (ISS_DNS_INPROGRESS_LOCAL | ISS_DNS_INPROGRESS_REMOTE)

typedef int CSinkInetStatus;
typedef struct {
  int active;
  void *fd_watch_tag;
  FILE *fp;
  uint32_t *in_addr_target;
  CSinkCallbackFunc on_lookup;
  CSinkCallbackFunc chain_callback;
  CSinkInet *sink;
} CSinkInetDNSLookup;

struct _CSinkInet {
  CSink s;			/* The sink. */

  /* these must all be kept in synch! */
  gchar *hostname;		/* Name of remote host. */
  uint32_t ip;		/* IP of remote host. */
  gint port;			/* Port of remote host. */
  struct sockaddr_in address;	/* The address of the other machine. */
  CSinkInetDNSLookup *remote_lookup; /* control structure for hostname 
				       resolution */


  gchar *localinterface;	/* which local interface are we using?. */
  uint32_t localip;		/* My IP. */
  int localport;		/* Our port number. */
  struct sockaddr_in localaddress; /* My address. */
  CSinkInetDNSLookup *local_lookup; /* control structure for hostname 
				       resolution */


  int fd;			/* Socket fd. */
  void *watch_tag;		/* ticket stub to get the drycleaning back */

  CSinkInetStatus status;
  CSinkCallbackFunc on_accept;
  CSinkCallbackFunc on_dns_lookup_success;
};



CSinkInet *csink_inet_new (void);


/* Allocate space for a new inet sink. */
/* CSinkInet * */
/* csink_inet_new ();  */


/* Connect */
void
 csink_inet_connect (CSinkInet * sink);


/* Set/get remote host/ip. */
void
 csink_inet_set_remote_host (CSinkInet * sink, const gchar * hostname);

const gchar *csink_inet_get_remote_host (CSinkInet * sink);

/* Set/get remote port */
void
 csink_inet_set_remote_port (CSinkInet * sink, const gint port);

gint csink_inet_get_remote_port (CSinkInet * sink);

/* Set local port - for listening or specifically setting local port for *
 * connection */
void
 csink_inet_set_local_port (CSinkInet * sink, const gint port);

gint csink_inet_get_local_port (CSinkInet * sink);

/* Set fd. */
/* 
 * these seem ugly to me. but it's 3am. -fatjim
 
 void
 csink_set_fd (CSinkInet *sink, const gint fd);
 
 gint
 csink_get_fd (CSinkInet *sink);
 */

/* To bind to a specific local interface */
void
 csink_inet_set_local_interface (CSinkInet * sink, const gchar * hostname);

const gchar *csink_inet_get_local_interface (CSinkInet * sink);

void csink_inet_listen (CSinkInet * sink);

#endif
