#include <gtk/gtk.h>
#include <stdlib.h>
#include "entity.h"
#include "gtk-common.h"
#include "gtk-widget-attr.h"

/* THIS RENDERER IS BROKEN.  WE PLAN ON GETTING A NEW ONE. */



static void
rendgtk_filesel_onselect_callback (GtkWidget * widget, gpointer user_data)
{
    ENode *node = user_data;
    gchar *function = NULL;
    GtkWidget *filesel;
    gchar *file;


    function = enode_attrib_str (node, "onselect", NULL);

    if (function) {
	filesel = enode_get_kv (node, "top-widget");
	if (!filesel)
	    return;

	gtk_widget_hide (GTK_WIDGET (filesel));
	enode_attrib_quiet (node, "visible", ebuf_new_with_false ());

	/* g_print ("calling function %s\n", function); */
	file = gtk_file_selection_get_filename (GTK_FILE_SELECTION (filesel));
	enode_call_ignore_return (node, function, "s", file);
    }
}

static void
rendgtk_filesel_cancel_callback (GtkWidget * widget, gpointer user_data)
{
    ENode *node = user_data;
    GtkWidget *filesel;

    filesel = enode_get_kv (node, "top-widget");
    if (!filesel)
	return;

    gtk_widget_hide (GTK_WIDGET (filesel));
    enode_attrib_quiet (node, "visible", ebuf_new_with_false ());
}


static gint
rendgtk_filesel_title_attr_set (ENode * node, EBuf * attr, EBuf * value)
{
    GtkWidget *filesel;

    filesel = enode_get_kv (node, "top-widget");
    if (!filesel)
	return FALSE;

    gtk_window_set_title (GTK_WINDOW (filesel), value->str);
    return (TRUE);
}

/* 
 * static gint rendgtk_filesel_selection_attr_set (ENode * node, gchar *
 * attr, gchar * value) { GtkWidget *filesel;
 * 
 * filesel = enode_get_kv (node, "top-widget"); if (!filesel) return FALSE;
 * 
 * if (!g_strcasecmp (value, "multiple")) { gtk_clist_set_selection_mode
 * (GTK_CLIST (GTK_FILE_SELECTION (filesel)->file_list),
 * GTK_SELECTION_EXTENDED); } return (TRUE); } */


static void
rendgtk_filesel_render (ENode * node)
{
    GtkWidget *filesel;

    filesel = gtk_file_selection_new ("Select");

    gtk_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION (filesel)->ok_button),
			"clicked",
			GTK_SIGNAL_FUNC (rendgtk_filesel_onselect_callback),
			node);

    gtk_signal_connect (GTK_OBJECT
			(GTK_FILE_SELECTION (filesel)->cancel_button),
			"clicked",
			GTK_SIGNAL_FUNC (rendgtk_filesel_cancel_callback),
			node);

    enode_set_kv (node, "top-widget", filesel);
    enode_set_kv (node, "bottom-widget", filesel);

    enode_attribs_sync (node);
    rendgtk_show_cond (node, filesel);
}


void
filesel_renderer_register (void)
{
    Element *element;
    ElementAttr *e_attr;

    /* filesel */
    element = g_new0 (Element, 1);

    element->render_func = rendgtk_filesel_render;
    element->destroy_func = rendgtk_element_destroy;
    element->parent_func = NULL;
    element->tag = "filesel";
    element->description =
	"Creates a new file selection dialog (this renderer needs replacement!).";
    element_register (element);

    e_attr = g_new0 (ElementAttr, 1);
    e_attr->attribute = "title";
    e_attr->description = "Set title and wmclass of window.";
    e_attr->value_desc = "string";
    e_attr->set_attr_func = rendgtk_filesel_title_attr_set;
    element_register_attrib (element, e_attr);

    e_attr = g_new0 (ElementAttr, 1);
    e_attr->attribute = "onselect";
    e_attr->description = "Function to call when a filename is selected.";
    e_attr->value_desc = "function";
    e_attr->possible_values = "(filesel_node, selected_file)";
    e_attr->set_attr_func = NULL;

    element_register_attrib (element, e_attr);
    rendgtk_widget_attr_register (element, GTK_TYPE_FILE_SELECTION);
}
