#ifndef __GTK_COMMON_H__
#define __GTK_COMMON_H__

#include <gtk/gtk.h>
#include "elements.h"

#define BOX_PACK_FILL_DEFAULT TRUE
#define BOX_PACK_EXPAND_DEFAULT FALSE
#define BOX_PACK_PADDING_DEFAULT 1


void rendgtk_init (void);


/* only show if visible attribute is not "false" */
void rendgtk_show_cond (ENode * node, GtkWidget * widget);

/* most common packing technique */
void rendgtk_box_pack (ENode * parent_node, ENode * child_node);

/* Default gtk element destructor */
void rendgtk_element_destroy (ENode * node);

void rendgtk_containerbox_attr_register (Element * element);

void rendgtk_type_widget_style_attr_register (Element * element);
GtkStyle *rendgtk_style_parser (EBuf * value, GtkStyle * orig);


/* This one is for <drag> tags */
void rendgtk_dnd_dragtag_source_create (ENode * node, GtkWidget * widget);

/* This one is to make it a viable destination for a dragged <drag> node */
void rendgtk_dnd_dragtag_target_create (ENode * node, GtkWidget * widget);

/* Set a widget as dragable */
void rendgtk_dnd_dragable_set (ENode * node, GtkWidget * widget);

/* Set as a viable target for dnd ops */
void rendgtk_dnd_target_create (ENode * node, GtkWidget * widget);

void rendgtk_adj_print (GtkAdjustment * adj);

GtkStyle *rendgtk_rc_get_style (GtkWidget * widget);


#endif				/* __GTK_COMMON_H__ */
