/*************************************************************************
 * GDK PIXBUF IMAGE RENDERER
 * Kirk Ismay <kirk_ismay@users.sourceforge.net>
 *************************************************************************/
#include "entity.h"

/* SORT OF WORKING !! * Known bugs: * - Transparent images have a
 * checkerboard background. * - Resizing the parent container only scales
 * image horizontally. * - Setting width / height attribs clips pixmap rather 
 * than scales it. */

#ifdef USE_GDK_PIXBUF

#define RENDIMAGE_VER "0.1"
#define RENDIMAGE_NAME "GDK_PIXBUF"
#define OVERALL_ALPHA 255
#include <gtk/gtk.h>
#include <gdk-pixbuf.h>
#include <gdk-pixbuf-loader.h>
#include "gtk-common.h"
#include "gtk-widget-attr.h"

/* I just jacked these up a bit more.. */
#define MAX_IMAGE_WIDTH 2048
#define MAX_IMAGE_HEIGHT 1536

gboolean
rendgtk_image_expose (GtkWidget * widget, GdkEventExpose * event, gpointer data)
{
    GdkPixbuf *dest;

//    gdk_window_set_back_pixmap (widget->window, NULL, FALSE);

    dest =
	gdk_pixbuf_new (GDK_COLORSPACE_RGB, FALSE, 8, event->area.width,
			event->area.height);

/* void        gdk_pixbuf_composite            (const GdkPixbuf *src,
                                              GdkPixbuf *dest,
                                              int dest_x,
                                              int dest_y,
                                              int dest_width,
                                              int dest_height,
                                              double offset_x,
                                              double offset_y,
                                              double scale_x,
                                              double scale_y,
                                              GdkInterpType interp_type,
                                              int overall_alpha);
*/
   gdk_pixbuf_composite_color (data, dest,
			       0, 0, 
			       event->area.width, 
			       event->area.height,
			       -event->area.x, -event->area.y,
			       (double) widget->allocation.width / gdk_pixbuf_get_width (data),
			       (double) widget->allocation.height / gdk_pixbuf_get_height (data),
			       GDK_INTERP_BILINEAR, OVERALL_ALPHA,
			       event->area.x, event->area.y, 16,
			       0xcccccc, 0xcccccc);

    gdk_pixbuf_render_to_drawable (dest, widget->window,
				   widget->style->fg_gc[GTK_STATE_NORMAL], 0, 0,
				   event->area.x, event->area.y,
				   event->area.width, event->area.height,
				   GDK_RGB_DITHER_NORMAL, event->area.x,
				   event->area.y);

    gdk_pixbuf_unref (dest);
    return TRUE;
}

static GdkPixbuf *
rendgtk_load_pixbuf (ENode * node, gchar * filename)
{
    GdkPixbuf *pixbuf;
    gchar *realfile;

    realfile = eutils_file_search (node, filename);

    if (!realfile) {
	/* FIXME: Should use onerror handler */
	g_warning ("Unable to locate file '%s'", filename);
	return (NULL);
    }

    pixbuf = gdk_pixbuf_new_from_file (realfile);

    if (!pixbuf)
	return (NULL);

    /* 
     * This could be useful later.. ? enode_set_kv (node, "pixbuf-width",
     * GUINT_TO_POINTER (width)); enode_set_kv (node, "pixbuf-height",
     * GUINT_TO_POINTER (height)); */
    g_free (realfile);
    return (pixbuf);

}

static gint
rendgtk_image_src_attr_set (ENode * node, EBuf * attr, EBuf * value)
{
    GdkPixbuf *pixbuf;
    GtkWidget *darea;
    GtkWidget *ebox;
    GtkWidget *vbox;
    GdkPixbuf *image;
    gchar *realfile;
    gint width;
    gint height;
    EBuf *val;

    ebox = enode_get_kv (node, "top-widget");
    if (!ebox)
	return FALSE;

    /* to make life easier, this is the only place that the image is actually
     * loaded */

    EDEBUG (("image-renderer", "attempting to load image '%s'", value->str));
    image = rendgtk_load_pixbuf (node, value->str);

    /* FIXME: This is gonna break from enode_attrib_str_str change */
    val = enode_attrib (node, "width", NULL);
    if (ebuf_not_empty (val))
	width = erend_get_integer (val);
    else
	width = gdk_pixbuf_get_width (image);

    val = enode_attrib (node, "height", NULL);
    if (ebuf_not_empty (val))
	height = erend_get_integer (val);
    else
	height = gdk_pixbuf_get_height (image);

    if (image) {
	darea = enode_get_kv (node, "image-drawing-area");

	gtk_signal_connect (GTK_OBJECT (darea), "expose_event",
			    GTK_SIGNAL_FUNC (rendgtk_image_expose), image);

	gtk_drawing_area_size (GTK_DRAWING_AREA (darea), width, height);

	enode_set_kv (node, "rendgtk-image-pixbuf", image);

	EDEBUG (("image-renderer", "image '%s' loaded", value->str));
    } else {
	EDEBUG (("image-renderer", "failed to load '%s'", value->str));
    }
    return (TRUE);
}

static gint
rendgtk_image_width_attr_set (ENode * node, EBuf * attr, EBuf * value)
{
    GtkWidget *ebox;

    ebox = enode_get_kv (node, "top-widget");

    return (TRUE);
}

static gint
rendgtk_image_height_attr_set (ENode * node, EBuf * attr, EBuf * value)
{
    GtkWidget *ebox;

    ebox = enode_get_kv (node, "top-widget");
    if (!ebox)
	return (TRUE);

    return (TRUE);
}

void
rendgtk_image_render (ENode * node)
{
    GtkWidget *ebox;
    GtkWidget *darea;
    GtkWidget *vbox;
    static gint initialized = FALSE;

    enode_attrib_str (node, "renderer-version", RENDIMAGE_VER);
    enode_attrib_str (node, "renderer-name", RENDIMAGE_NAME);

    if (!initialized) {
	gdk_rgb_init ();
	initialized = TRUE;
    }

    /* We use the eventbox so we can attach a few signals if needed */
    ebox = gtk_event_box_new ();
    vbox = gtk_vbox_new (FALSE, 0);

    darea = gtk_drawing_area_new ();
    gtk_box_pack_start (GTK_BOX (vbox), darea, TRUE, TRUE, 0);
    gtk_container_add (GTK_CONTAINER (ebox), vbox);

    enode_set_kv (node, "image-drawing-area", darea);

    gtk_widget_show_all (vbox);

    /* experiment gtk_container_set_resize_mode (GTK_CONTAINER (ebox),
     * GTK_RESIZE_PARENT); */
    enode_set_kv (node, "top-widget", ebox);
    enode_set_kv (node, "bottom-widget", ebox);

    enode_attribs_sync (node);
    rendgtk_show_cond (node, ebox);
}

void
image_renderer_register (void)
{
    Element *element;
    ElementAttr *e_attr;

    EDEBUG (("image-renderer", "GDK_PIXBUF Image renderer registering "));

    /* image */
    element = g_new0 (Element, 1);
    element->render_func = rendgtk_image_render;
    element->destroy_func = rendgtk_element_destroy;
    element->parent_func = NULL;
    element->tag = "image";
    element->description = "Display an image from a file.";
    element_register (element);
    rendgtk_widget_attr_register (element, GTK_TYPE_EVENT_BOX);

    e_attr = g_new0 (ElementAttr, 1);
    e_attr->attribute = "src";
    e_attr->description = "Set the location of the image file on disk.";
    e_attr->value_desc = "filename";
    e_attr->set_attr_func = rendgtk_image_src_attr_set;
    element_register_attrib (element, e_attr);

    e_attr = g_new0 (ElementAttr, 1);
    e_attr->attribute = "renderer-version";
    e_attr->description = "Version number of the image renderer.";
    e_attr->value_desc = "string";
    element_register_attrib (element, e_attr);

    e_attr = g_new0 (ElementAttr, 1);
    e_attr->attribute = "renderer-name";
    e_attr->description = "Name of the image renderer.";
    e_attr->value_desc = "string";
    element_register_attrib (element, e_attr);

    e_attr = g_new0 (ElementAttr, 1);
    e_attr->attribute = "width";
    e_attr->description = "Set the width of the image.";
    e_attr->value_desc = "integer";
    e_attr->set_attr_func = rendgtk_image_width_attr_set;
    element_register_attrib (element, e_attr);

    e_attr = g_new0 (ElementAttr, 1);
    e_attr->attribute = "height";
    e_attr->description = "Set the height of the image.";
    e_attr->value_desc = "integer";
    e_attr->set_attr_func = rendgtk_image_height_attr_set;
    element_register_attrib (element, e_attr);
}

#endif				/* USE_PIXBUF */
