#include <gtk/gtk.h>
#include "entity.h"
#include "gtk-common.h"
#include "gtk-widget-attr.h"
#include "toggle-renderer.h"


static void
rendgtk_radio_group_destroy (ENode * node)
{
    GSList *freelist;

    EDEBUG (("radio-renderer", "in rendgtk_radio_group_destroy"));

    freelist = enode_get_kv (node, "rendgtk-radio-group-freelist");

    for (; freelist; freelist = freelist->next) {
	EDEBUG (("radio-renderer", "freeing %p", freelist->data));
	gtk_widget_destroy (GTK_WIDGET (freelist->data));
    }
}

static void
rendgtk_radio_destroy (ENode * node)
{
    ENode *parent;
    GtkWidget *radio;
    GSList *freelist;
    int ttag,
     stag;

    radio = enode_get_kv (node, "top-widget");
    if (!radio)
	return;

    parent = enode_parent (node, "radio-group");
    if (!parent)
	return;

    /* Add the radio to the radio-group's freelist. */
    freelist = enode_get_kv (parent, "rendgtk-radio-group-freelist");
    freelist = g_slist_prepend (freelist, radio);
    enode_set_kv (parent, "rendgtk-radio-group-freelist", freelist);

    ttag = (int) enode_get_kv (node, "rendgtk-radio-ttag");
    stag = (int) enode_get_kv (node, "rendgtk-radio-stag");

    /* Disconnect the signals to this radio. */
    gtk_signal_disconnect (GTK_OBJECT (radio), ttag);
    gtk_signal_disconnect (GTK_OBJECT (radio), stag);

    /* Now make sure this one isn't toggled. */
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (radio), FALSE);
    gtk_widget_hide (radio);

    /* Wish we could call one of theses... MW */
    /* rendgtk_element_destroy(node); */
    /* gtk_widget_destroy(radio); */
}

static void
rendgtk_radio_render (ENode * node)
{
    GtkWidget *radio;
    GtkWidget *vbox;
    GSList *group = NULL;
    ENode *parent;
    int ttag = 0,
     stag = 0;			/* Toggle, select tags. */

    EDEBUG (("radio-renderer", "rendgtk_radio_render"));

    parent = enode_parent (node, "radio-group");

    if (!parent) {
	EBuf *name = enode_attrib (node, "name", NULL);
	g_warning ("radio %s.%s not in a <radio-group> tag.",
		   node->element->str, name->str);
	return;
    }

    group = enode_get_kv (parent, "rendgtk-radio-group");

    EDEBUG (("radio-renderer", "group = %i", group));

    radio = gtk_radio_button_new (group);

    group = gtk_radio_button_group (GTK_RADIO_BUTTON (radio));
    enode_set_kv (parent, "rendgtk-radio-group", group);

    vbox = gtk_vbox_new (TRUE, 0);
    gtk_container_add (GTK_CONTAINER (radio), vbox);
    gtk_widget_show (vbox);

    enode_set_kv (node, "top-widget", radio);
    enode_set_kv (node, "bottom-widget", vbox);

    ttag = gtk_signal_connect (GTK_OBJECT (radio), "toggled",
			       GTK_SIGNAL_FUNC
			       (rendgtk_toggle_ontoggle_callback), node);
    stag =
	gtk_signal_connect (GTK_OBJECT (radio), "toggled",
			    GTK_SIGNAL_FUNC (rendgtk_toggle_onselect_callback),
			    node);

    enode_set_kv (node, "rendgtk-radio-ttag", (void *) ttag);
    enode_set_kv (node, "rendgtk-radio-stag", (void *) stag);

    enode_attribs_sync (node);

    rendgtk_show_cond (node, radio);
}

static void
radio_group_renderer_register (void)
{
    Element *element;
    ElementAttr *e_attr;

    element = g_new0 (Element, 1);

    element->destroy_func = rendgtk_radio_group_destroy;
    element->tag = "radio-group";
    element->description = "Create a new group to hold other radio buttons.";
    element_register (element);

    e_attr = g_new0 (ElementAttr, 1);
    e_attr->attribute = "onselect";
    e_attr->description = "Sets up a handler for all radio onselect events.";
    e_attr->value_desc = "function";
    e_attr->possible_values = "function";
    e_attr->possible_values = "(selected_node)";

    element_register_attrib (element, e_attr);
}

void
radio_renderer_register (void)
{
    Element *element;

    radio_group_renderer_register ();

    element = g_new0 (Element, 1);

    element->render_func = rendgtk_radio_render;
    element->destroy_func = rendgtk_radio_destroy;
    element->parent_func = rendgtk_box_pack;
    element->tag = "radio";
    element->description = "Create a new radio button";
    element_register (element);

    rendgtk_widget_attr_register (element, GTK_TYPE_RADIO_BUTTON);
    rendgtk_toggle_attr_register (element);
    rendgtk_containerbox_attr_register (element);
}
