#include <gtk/gtk.h>
#include <stdlib.h>
#include "entity.h"
#include "gtk-common.h"
#include "gtk-widget-attr.h"


static GdkFont *font = NULL;

static int
rendgtk_text_onchange_callback (GtkWidget * text, ENode * node)
{
     /*FIXME*/ return TRUE;
}

static void
rendgtk_text_set_data (ENode * node, EBuf * data)
{
    GtkWidget *text;
    gint len;
    gint point;

    text = enode_get_kv (node, "top-widget");
    if (!text)
	return;

    gtk_text_freeze (GTK_TEXT (text));
    len = gtk_text_get_length (GTK_TEXT (text));
    point = gtk_text_get_point (GTK_TEXT (text));

    EDEBUG (("text-renderer", "len = %i, point = %i", len, point));
    EDEBUG (("text-renderer", "setting to %s", data->str));

    gtk_text_set_point (GTK_TEXT (text), 0);
    gtk_text_forward_delete (GTK_TEXT (text), len);

    if (data)
	gtk_text_insert (GTK_TEXT (text), font, NULL, NULL, data->str,
			 data->len);

    /* try to reset the point in the text widget, but if we can just set as
     * the end. */
    len = gtk_text_get_length (GTK_TEXT (text));
    if (len < point)
	point = len;

    gtk_text_set_point (GTK_TEXT (text), point);

    gtk_text_thaw (GTK_TEXT (text));
}

static void
rendgtk_text_append_data (ENode * node, EBuf * data)
{
    GtkWidget *text;

    text = enode_get_kv (node, "top-widget");
    if (!text)
	return;

    if (!data)
	return;

    gtk_text_freeze (GTK_TEXT (text));
    gtk_text_insert (GTK_TEXT (text), font, NULL, NULL, data->str, data->len);
    gtk_text_thaw (GTK_TEXT (text));
}

static void
rendgtk_text_get_data (ENode * node)
{
    GtkWidget *text;
    gchar *chars;
    gint len;

    EDEBUG (("text-renderer", "in get_data"));

    text = enode_get_kv (node, "top-widget");
    if (!text)
	return;

    len = gtk_text_get_length (GTK_TEXT (text));
    chars = gtk_editable_get_chars (GTK_EDITABLE (text), 0, len);

    if (node->data)
	ebuf_set_to_data (node->data, chars, len);
    else
	node->data = ebuf_new_with_data (chars, len);
}



static void
rendgtk_text_render (ENode * node)
{
    GtkWidget *text;

    text = gtk_text_new (NULL, NULL);

    enode_set_kv (node, "top-widget", text);
    enode_set_kv (node, "bottom-widget", text);

    gtk_signal_connect (GTK_OBJECT (text), "changed",
			GTK_SIGNAL_FUNC (rendgtk_text_onchange_callback), node);
    if (!font)
	font =
	    gdk_font_load ("-adobe-courier-medium-r-normal--*-120-*-*-*-*-*-*");

    /* TODO add font tags etc. */
     

   
    /* Note that this must be done here because the parser will append data
     * directly to the node data */
    if (node->data)
	gtk_text_insert (GTK_TEXT (text), font, NULL, NULL,
			 node->data->str, node->data->len);
    else
	gtk_text_insert (GTK_TEXT (text), font, NULL, NULL, "", 0);

    EDEBUG (("text-renderer", "rendered text!"));

    enode_attribs_sync (node);
    rendgtk_show_cond (node, text);
}

static void
rendgtk_text_parent (ENode * parent_node, ENode * child_node)
{
    return;
}

static gint
rendgtk_text_set_wordwrap (ENode * node, EBuf * attr, EBuf * value)
{
    GtkWidget *text;
   
    text = enode_get_kv (node, "top-widget");
    if (!text)
        return (TRUE);
    
    gtk_text_set_word_wrap (GTK_TEXT (text), erend_value_is_true (value));
    EDEBUG (("text-renderer", "Word wrap is %s", value->str));
    return (TRUE);
   
}

static gint
rendgtk_text_set_linewrap (ENode * node, EBuf * attr, EBuf * value)
{
    GtkWidget *text;
    text = enode_get_kv (node, "top-widget");
    if (!text)
        return (TRUE);

    gtk_text_set_line_wrap (GTK_TEXT (text), !erend_value_is_true (value));
    EDEBUG (("text-renderer", "Line wrap is -> %s", value->str));
    return (TRUE);
}

void
text_renderer_register (void)
{
    Element *element;
    ElementAttr *e_attr; 
   
    /* text */
    element = g_new0 (Element, 1);
    element->render_func = rendgtk_text_render;
    element->destroy_func = rendgtk_element_destroy;
    element->parent_func = rendgtk_text_parent;
    element->set_data_func = rendgtk_text_set_data;
    element->append_data_func = rendgtk_text_append_data;
    element->get_data_func = rendgtk_text_get_data;
    element->tag = "text";
    element->description = "A full sized, optionally editable text widget.";
    element_register (element);
      
    e_attr = g_new0 (ElementAttr, 1);
    e_attr->attribute = "wordwrap";
    e_attr->description = 
        "Sets the word wrapping method for the text widget";
    e_attr->value_desc = "boolean";
    e_attr->possible_values = "false,true";
    e_attr->set_attr_func = rendgtk_text_set_wordwrap;
    element_register_attrib (element, e_attr);
    
    e_attr = g_new0 (ElementAttr, 1);
    e_attr->attribute = "linewrap";
    e_attr->description = 
        "Sets the line wrapping method for the text widget";
    e_attr->value_desc = "boolean";
    e_attr->possible_values = "false,true";
    e_attr->set_attr_func = rendgtk_text_set_linewrap;
    element_register_attrib (element, e_attr);
    
    rendgtk_widget_attr_register (element, GTK_TYPE_TEXT);
}
