/* This file is autogenerated by jig 0.3.0 from file ENode.jsi
 *
 * DO NOT EDIT THIS FILE */

#include <njs/jig.h>
#include "js-ENode.h"

/* This interface complies with the following standard:
 * ENode IDL (docs/ENode.idl) */

#line 11 "ENode.jsi"


/*
 * Javascript binding for Entity
 * Copyright (c) 2000 Brian Bassett and Ian Main
 *
 * Authors: Brian Bassett <bbassett@bbassett.net>
 *	    Ian Main <imain@gtk.org>
 */

/*
 * This renderer is free software; please see the LICENSE file for
 * specific information as to licensing conditions.
 */

/*
 * $Source: /home/cvs/entity/renderers/javascript/js-ENode.c,v $
 * $Id: js-ENode.c,v 1.37 2000/11/03 06:30:17 imain Exp $
 */

#line 32 "js-ENode.c"

#line 32 "ENode.jsi"



void
js_return_enode (JSVirtualMachine *js_vm, JSBuiltinInfo *js_info, 
		 JSNode *retval, ENode *node)
{
    ENodeInstanceCtx *ni;

    ni = js_calloc(js_vm, 1, sizeof(*ni));
    ni->enode = node;
    enode_ref (node);

    js_vm_builtin_create(js_vm, retval, js_info, ni);

    /* If all we ever do is call enode(), the vm will never
     * do gc otherwise.. */

    /*
    if (js_vm->gc.bytes_allocated >= js_vm->gc.trigger) {
	js_vm_garbage_collect (js_vm, retval, retval);
    }
    */
}

static void
js_return_enode_array (JSVirtualMachine *js_vm, JSNode *js_retval,
		       JSBuiltinInfo *js_info, GSList *list)
{
    ENodeInstanceCtx *ni;
    gint i = 0;
    GSList *tmp = list;
    gint len = g_slist_length (tmp);
    
    js_vm_make_array (js_vm, js_retval, len);
    
    while (tmp) {
	ENode *enode = tmp->data;
    	ni = js_calloc(js_vm, 1, sizeof(*ni));
	ni->enode = enode;
	enode_ref (enode);

	js_vm_builtin_create(js_vm, &js_retval->u.varray->data[i], 
			     js_info, ni);
	i++;
	tmp = tmp->next;
    }
}

static void
js_return_ebuf_array (JSVirtualMachine *js_vm, JSNode *js_retval,
		      GSList *list)
{
    gint i = 0;
    GSList *tmp = list;
    gint len = g_slist_length (tmp);
   
    EDEBUG (("javascript", "Creating ebuf array of length %d\n", len));
    js_vm_make_array (js_vm, js_retval, len);
    
    while (tmp) {
	EBufConst *buf = tmp->data;

	js_retval->u.varray->data[i].type = JS_STRING;
	js_vm_make_string (js_vm, &js_retval->u.varray->data[i], 
	    buf->str, buf->len);
	i++;
	tmp = tmp->next;
    }
}

static void
js_return_string_array (JSVirtualMachine *js_vm, JSNode *js_retval,
	  	        GSList *list)
{
    gint i = 0;
    GSList *tmp = list;
    gint len = g_slist_length (tmp);
    
    EDEBUG (("javascript", "Creating string array of length %d\n", len));
    js_vm_make_array (js_vm, js_retval, len);
    
    while (tmp) {
	gchar *str = tmp->data;

	js_retval->u.varray->data[i].type = JS_STRING;
	js_vm_make_string (js_vm, &js_retval->u.varray->data[i], 
			   str, strlen (str));
	i++;
	tmp = tmp->next;
    }
}




#line 131 "js-ENode.c"

static int ENode_method(JSVirtualMachine *js_vm, JSBuiltinInfo *js_info, void *js_ictx, JSSymbol js_method, JSNode *js_retval, JSNode *js_args) {
  ENodeCtx *js_context = js_info->obj_context;
  ENodeInstanceCtx *js_instance = (ENodeInstanceCtx *)js_ictx;

  if(js_ictx == NULL) {
  
    return JS_PROPERTY_UNKNOWN;

  return JS_PROPERTY_FOUND;
  }

  if(js_method == js_context->s_new_child) {
#undef js_return
#define js_return js_return_object

  char *basename = NULL;
  JSNode js_tempnode;
  if (js_args->u.vinteger != 1) {
    js_vm_set_err(js_vm, "new_child(): illegal number of arguments");
    js_vm_error(js_vm);
  }
  js_vm_to_string(js_vm, &js_args[1], &js_tempnode);
  basename = js_string_to_c_string(js_vm, &js_tempnode);
    do {
#line 145 "ENode.jsi"

	
	    ENode *node = js_instance->enode;
	    ENode *new_child;

	    new_child = enode_new_child (node, basename, NULL);
	    
	    js_return_enode (js_vm, js_info, js_retval, new_child);
    
#line 167 "js-ENode.c"
    } while(0);
  js_free(basename);
  } else if(js_method == js_context->s_parent) {
#undef js_return
#define js_return js_return_object

  char *search = NULL;
  unsigned int search_valid = (js_args->u.vinteger >= 1);
  JSNode js_tempnode;
  if (js_args->u.vinteger > 1 || js_args->u.vinteger < 0) {
    js_vm_set_err(js_vm, "parent(): illegal number of arguments");    js_vm_error(js_vm);
  }
  if (search_valid) {
  js_vm_to_string(js_vm, &js_args[1], &js_tempnode);
  search = js_string_to_c_string(js_vm, &js_tempnode);
  }
    do {
#line 269 "ENode.jsi"

	
	ENode *node;
	ENode *parent;

	node = js_instance->enode; 
	parent = enode_parent (node, search);	

	if (parent) {
	    js_return_enode (js_vm, js_info, js_retval, parent);
	} else {
	    js_retval->type = JS_NULL;
	}
    
#line 201 "js-ENode.c"
    } while(0);
  js_free(search);
  } else if(js_method == js_context->s_child) {
#undef js_return
#define js_return js_return_object

  char *search = NULL;
  JSNode js_tempnode;
  if (js_args->u.vinteger != 1) {
    js_vm_set_err(js_vm, "child(): illegal number of arguments");
    js_vm_error(js_vm);
  }
  js_vm_to_string(js_vm, &js_args[1], &js_tempnode);
  search = js_string_to_c_string(js_vm, &js_tempnode);
    do {
#line 285 "ENode.jsi"


	ENode *node;
	ENode *child;

	node = js_instance->enode; 
	child = enode_child (node, search);	

	if (child) {
	    js_return_enode (js_vm, js_info, js_retval, child);
	} else {
	    js_retval->type = JS_NULL;
	}
    
#line 232 "js-ENode.c"
    } while(0);
  js_free(search);
  } else if(js_method == js_context->s_child_rx) {
#undef js_return
#define js_return js_return_object

  char *regex = NULL;
  JSNode js_tempnode;
  if (js_args->u.vinteger != 1) {
    js_vm_set_err(js_vm, "child_rx(): illegal number of arguments");
    js_vm_error(js_vm);
  }
  js_vm_to_string(js_vm, &js_args[1], &js_tempnode);
  regex = js_string_to_c_string(js_vm, &js_tempnode);
    do {
#line 300 "ENode.jsi"


	ENode *node;
	ENode *child;

	node = js_instance->enode; 
	child = enode_child_rx (node, regex);	

	if (child) {
	    js_return_enode (js_vm, js_info, js_retval, child);
	} else {
	    js_retval->type = JS_NULL;
	}
    
#line 263 "js-ENode.c"
    } while(0);
  js_free(regex);
  } else if(js_method == js_context->s_children) {
#undef js_return
#define js_return js_return_array

  char *search = NULL;
  unsigned int search_valid = (js_args->u.vinteger >= 1);
  JSNode js_tempnode;
  if (js_args->u.vinteger > 1 || js_args->u.vinteger < 0) {
    js_vm_set_err(js_vm, "children(): illegal number of arguments");    js_vm_error(js_vm);
  }
  if (search_valid) {
  js_vm_to_string(js_vm, &js_args[1], &js_tempnode);
  search = js_string_to_c_string(js_vm, &js_tempnode);
  }
    do {
#line 315 "ENode.jsi"


	ENode *node;
	GSList *children;

	node = js_instance->enode; 
	children = enode_children (node, search);	

	if (children) {
	    js_return_enode_array (js_vm, js_retval,
				   js_info, children);
	    g_slist_free (children);
	} else {
	    js_retval->type = JS_NULL;
	}
    
#line 299 "js-ENode.c"
    } while(0);
  js_free(search);
  } else if(js_method == js_context->s_children_rx) {
#undef js_return
#define js_return js_return_array

  char *regex = NULL;
  JSNode js_tempnode;
  if (js_args->u.vinteger != 1) {
    js_vm_set_err(js_vm, "children_rx(): illegal number of arguments");
    js_vm_error(js_vm);
  }
  js_vm_to_string(js_vm, &js_args[1], &js_tempnode);
  regex = js_string_to_c_string(js_vm, &js_tempnode);
    do {
#line 332 "ENode.jsi"

	ENode *node;
	GSList *children;

	node = js_instance->enode; 
	children = enode_children_rx (node, regex);	

	if (children) {
	    js_return_enode_array (js_vm, js_retval,
				   js_info, children);
	    g_slist_free (children);
	} else {
	    js_retval->type = JS_NULL;
	}
    
#line 331 "js-ENode.c"
    } while(0);
  js_free(regex);
  } else if(js_method == js_context->s_children_attrib) {
#undef js_return
#define js_return js_return_array

  char *attrib = NULL;
  char *attrval = NULL;
  JSNode js_tempnode;
  if (js_args->u.vinteger != 2) {
    js_vm_set_err(js_vm, "children_attrib(): illegal number of arguments");
    js_vm_error(js_vm);
  }
  js_vm_to_string(js_vm, &js_args[1], &js_tempnode);
  attrib = js_string_to_c_string(js_vm, &js_tempnode);
  js_vm_to_string(js_vm, &js_args[2], &js_tempnode);
  attrval = js_string_to_c_string(js_vm, &js_tempnode);
    do {
#line 348 "ENode.jsi"

	ENode *node;
	GSList *children;
	EBufFreeMe *eval;

	node = js_instance->enode; 
	eval = ebuf_new_with_str (attrval);
	children = enode_children_attrib (node, attrib, eval);	
	ebuf_free (eval);

	if (children) {
	    js_return_enode_array (js_vm, js_retval,
				   js_info, children);
	    g_slist_free (children);
	} else {
	    js_retval->type = JS_NULL;
	}
    
#line 369 "js-ENode.c"
    } while(0);
  js_free(attrib);
  js_free(attrval);
  } else if(js_method == js_context->s_children_attrib_rx) {
#undef js_return
#define js_return js_return_array

  char *attrib = NULL;
  char *regex = NULL;
  JSNode js_tempnode;
  if (js_args->u.vinteger != 2) {
    js_vm_set_err(js_vm, "children_attrib_rx(): illegal number of arguments");
    js_vm_error(js_vm);
  }
  js_vm_to_string(js_vm, &js_args[1], &js_tempnode);
  attrib = js_string_to_c_string(js_vm, &js_tempnode);
  js_vm_to_string(js_vm, &js_args[2], &js_tempnode);
  regex = js_string_to_c_string(js_vm, &js_tempnode);
    do {
#line 367 "ENode.jsi"

	ENode *node;
	GSList *children;

	node = js_instance->enode; 
	children = enode_children_attrib_rx (node, attrib, regex);	

	if (children) {
	    js_return_enode_array (js_vm, js_retval,
				   js_info, children);
	    g_slist_free (children);
	} else {
	    js_retval->type = JS_NULL;
	}
    
#line 405 "js-ENode.c"
    } while(0);
  js_free(attrib);
  js_free(regex);
  } else if(js_method == js_context->s_call) {
#undef js_return
#define js_return js_return_cstring

  char *function = NULL;
  long js_varargc = (js_args->u.vinteger - 1);
  JSNode *js_varargv = &js_args[2];
  JSNode js_tempnode;
  if (js_args->u.vinteger < 1) {
    js_vm_set_err(js_vm, "call(): illegal number of arguments");
    js_vm_error(js_vm);
  }
  js_vm_to_string(js_vm, &js_args[1], &js_tempnode);
  function = js_string_to_c_string(js_vm, &js_tempnode);
    do {
#line 384 "ENode.jsi"

      
	EBufFreeMe *valret;
	GSList *call_args = NULL;
	char *fmt = NULL;

	if (js_varargc > 1) {
	    js_vm_to_string (js_vm, &js_varargv[0], &js_tempnode);
	    fmt = js_string_to_c_string (js_vm, &js_tempnode);
	    /* Advance start of varargs to next entry */
	    js_varargv = &js_varargv[1];
	    js_varargc--;
	}
	
	if (fmt) {
	    int i;
	    int n_args = strlen (fmt);

	    EDEBUG(("js-embed", "node.call: got the function name %s, argstring '%s'", 
	    	    function, fmt));

	    if (n_args != js_varargc) {
		js_vm_set_err (js_vm, "call(): argument list does not match argument count");
		js_vm_error (js_vm);
	    }
	    
	    /* We start at 1 because the fmt argument is the first real vararg */
	    for (i = 0; i < js_varargc; i++) {
		JSNode js_tempnode;
		char *str;
		int vint;

		switch(fmt[i]) {
		   
		    case 'n': 
    			EDEBUG(("js-embed", "call(): processing got an enode"));
			
			if (js_varargv[i].type == JS_BUILTIN) {
			    ENodeInstanceCtx *ni;
			    ni = js_varargv[i].u.vbuiltin->instance_context;
			    if (ni)
				call_args = enode_call_push_node(call_args, ni->enode);
			} else {
			    js_vm_set_err (js_vm, 
				"call(): argument does not match format (node not an Object)");
			    js_vm_error (js_vm);
			}
			break;

  		    /* We're just gonna make strings for all of these for now */
		    case 'e':
		    case 'b':
			js_vm_to_string (js_vm, &js_varargv[i], &js_tempnode);
			call_args = enode_call_push_data (call_args, 
							  js_tempnode.u.vstring->data, 
							  js_tempnode.u.vstring->len);
			break;	

		    case 's':
			
			js_vm_to_string (js_vm, &js_varargv[i], &js_tempnode);
			str = js_string_to_c_string (js_vm, &js_tempnode);
			call_args = enode_call_push_str (call_args, str);
			EDEBUG(("js-embed", "call(): vararg %d: string '%s'",
				i, str));
			break;	
			
		    case 'i':
			
			js_vm_to_number (js_vm, &js_varargv[i], &js_tempnode);
			vint = js_tempnode.u.vinteger;	
			call_args = enode_call_push_int (call_args, vint);
			EDEBUG(("js-embed", "call(): vararg %d: int '%d'",
				i, vint));
			break;
			
		    default:
			/* bad args string */
			enode_call_free_arg_list_items (call_args);
			js_vm_set_err (js_vm, "call(): Bad argument character '%s'", fmt[i]);
			js_vm_error (js_vm);
		}
	    }
	}
	
	valret = enode_call_with_list (js_instance->enode, function, call_args);
	
	if (!valret) {
	    EDEBUG(("js-embed", "call(): retval was NULL. returning none"));
	    js_retval->type = JS_NULL;
	} else {
    	    js_retval->type = JS_STRING;
    	    js_vm_make_string (js_vm, js_retval, valret->str, valret->len);
    	    ebuf_free(valret);
	}

    
#line 522 "js-ENode.c"
    } while(0);
  js_free(function);
  } else if(js_method == js_context->s_attrib_quiet) {
#undef js_return
#define js_return js_return_cstring

  char *attrib = NULL;
  char *value = NULL;
  unsigned int value_valid = (js_args->u.vinteger >= 2);
  JSNode js_tempnode;
  if (js_args->u.vinteger > 2 || js_args->u.vinteger < 1) {
    js_vm_set_err(js_vm, "attrib_quiet(): illegal number of arguments");    js_vm_error(js_vm);
  }
  js_vm_to_string(js_vm, &js_args[1], &js_tempnode);
  attrib = js_string_to_c_string(js_vm, &js_tempnode);
  if (value_valid) {
  js_vm_to_string(js_vm, &js_args[2], &js_tempnode);
  value = js_string_to_c_string(js_vm, &js_tempnode);
  }
    do {
#line 482 "ENode.jsi"


	ENode *node;
	EBufConst *valret;
	EBuf *val = NULL;
	
	node = js_instance->enode;
	if (value)
	    val = ebuf_new_with_str (value);

	valret = enode_attrib_quiet (node, attrib, val);	
	
	if (valret) {
    	    js_retval->type = JS_STRING;
	    js_vm_make_string (js_vm, js_retval, valret->str, valret->len);
	} else {
	    js_retval->type = JS_NULL;
	}
    
#line 564 "js-ENode.c"
    } while(0);
  js_free(attrib);
  js_free(value);
  } else if(js_method == js_context->s_attrib_is_true) {
#undef js_return
#define js_return js_return_boolean

  char *attrib = NULL;
  JSNode js_tempnode;
  if (js_args->u.vinteger != 1) {
    js_vm_set_err(js_vm, "attrib_is_true(): illegal number of arguments");
    js_vm_error(js_vm);
  }
  js_vm_to_string(js_vm, &js_args[1], &js_tempnode);
  attrib = js_string_to_c_string(js_vm, &js_tempnode);
    do {
#line 502 "ENode.jsi"

	js_retval->type= JS_BOOLEAN;
	js_retval->u.vboolean = enode_attrib_is_true (js_instance->enode, attrib);	
    
#line 586 "js-ENode.c"
    } while(0);
  js_free(attrib);
  } else if(js_method == js_context->s_list_set_attribs) {
#undef js_return
#define js_return js_return_array

  JSNode js_tempnode;
  if (js_args->u.vinteger != 0) {
    js_vm_set_err(js_vm, "list_set_attribs(): illegal number of arguments");
    js_vm_error(js_vm);
  }
    do {
#line 507 "ENode.jsi"

	GSList *lst;
   
	lst = enode_list_set_attribs (js_instance->enode); 

	if (lst) {
	    js_return_ebuf_array (js_vm, js_retval, lst);
	    g_slist_free (lst);
	} else {
	    js_retval->type = JS_NULL;
	}
    
#line 612 "js-ENode.c"
    } while(0);
  } else if(js_method == js_context->s_supported_attribs) {
#undef js_return
#define js_return js_return_array

  JSNode js_tempnode;
  if (js_args->u.vinteger != 0) {
    js_vm_set_err(js_vm, "supported_attribs(): illegal number of arguments");
    js_vm_error(js_vm);
  }
    do {
#line 520 "ENode.jsi"

	
	GSList *lst;
   
	lst = enode_supported_attribs (js_instance->enode); 
	
	if (lst) {
	    js_return_string_array (js_vm, js_retval, lst);
	    g_slist_free (lst);
	} else {
	    js_retval->type = JS_NULL;
	}
    
#line 638 "js-ENode.c"
    } while(0);
  } else if(js_method == js_context->s_attrib_description) {
#undef js_return
#define js_return js_return_cstring

  char *attrib = NULL;
  JSNode js_tempnode;
  if (js_args->u.vinteger != 1) {
    js_vm_set_err(js_vm, "attrib_description(): illegal number of arguments");
    js_vm_error(js_vm);
  }
  js_vm_to_string(js_vm, &js_args[1], &js_tempnode);
  attrib = js_string_to_c_string(js_vm, &js_tempnode);
    do {
#line 534 "ENode.jsi"

	gchar *ret;
	ret = enode_attrib_description (js_instance->enode, attrib);
	if (ret) {
    	    js_retval->type = JS_STRING;
	    js_vm_make_string (js_vm, js_retval, ret, strlen (ret));
	} else {
	    js_retval->type = JS_NULL;
	}
    
#line 664 "js-ENode.c"
    } while(0);
  js_free(attrib);
  } else if(js_method == js_context->s_attrib_value_type) {
#undef js_return
#define js_return js_return_cstring

  char *attrib = NULL;
  JSNode js_tempnode;
  if (js_args->u.vinteger != 1) {
    js_vm_set_err(js_vm, "attrib_value_type(): illegal number of arguments");
    js_vm_error(js_vm);
  }
  js_vm_to_string(js_vm, &js_args[1], &js_tempnode);
  attrib = js_string_to_c_string(js_vm, &js_tempnode);
    do {
#line 545 "ENode.jsi"

	gchar *ret;
	ret = enode_attrib_value_type (js_instance->enode, attrib);
	if (ret) {
    	    js_retval->type = JS_STRING;
	    js_vm_make_string (js_vm, js_retval, ret, strlen (ret));
	} else {
	    js_retval->type = JS_NULL;
	}
    
#line 691 "js-ENode.c"
    } while(0);
  js_free(attrib);
  } else if(js_method == js_context->s_attrib_possible_values) {
#undef js_return
#define js_return js_return_cstring

  char *attrib = NULL;
  JSNode js_tempnode;
  if (js_args->u.vinteger != 1) {
    js_vm_set_err(js_vm, "attrib_possible_values(): illegal number of arguments");
    js_vm_error(js_vm);
  }
  js_vm_to_string(js_vm, &js_args[1], &js_tempnode);
  attrib = js_string_to_c_string(js_vm, &js_tempnode);
    do {
#line 556 "ENode.jsi"

	gchar *ret;
	ret = enode_attrib_possible_values (js_instance->enode, attrib);
	if (ret) {
    	    js_retval->type = JS_STRING;
	    js_vm_make_string (js_vm, js_retval, ret, strlen (ret));
	} else {
	    js_retval->type = JS_NULL;
	}
    
#line 718 "js-ENode.c"
    } while(0);
  js_free(attrib);
  } else if(js_method == js_context->s_attribs_sync) {
#undef js_return
#define js_return js_return_undef

  JSNode js_tempnode;
  if (js_args->u.vinteger != 0) {
    js_vm_set_err(js_vm, "attribs_sync(): illegal number of arguments");
    js_vm_error(js_vm);
  }
    do {
#line 567 "ENode.jsi"

	enode_attribs_sync (js_instance->enode);
    
#line 735 "js-ENode.c"
    } while(0);
  } else if(js_method == js_context->s_destroy) {
#undef js_return
#define js_return js_return_undef

  JSNode js_tempnode;
  if (js_args->u.vinteger != 0) {
    js_vm_set_err(js_vm, "destroy(): illegal number of arguments");
    js_vm_error(js_vm);
  }
    do {
#line 571 "ENode.jsi"

	enode_destroy (js_instance->enode);
    
#line 751 "js-ENode.c"
    } while(0);
  } else if(js_method == js_context->s_destroy_children) {
#undef js_return
#define js_return js_return_undef

  JSNode js_tempnode;
  if (js_args->u.vinteger != 0) {
    js_vm_set_err(js_vm, "destroy_children(): illegal number of arguments");
    js_vm_error(js_vm);
  }
    do {
#line 582 "ENode.jsi"


	ENode *node;

	node = js_instance->enode; 
	enode_destroy_children (node);	
    
#line 771 "js-ENode.c"
    } while(0);
  } else if(js_method == js_context->s_get_xml) {
#undef js_return
#define js_return js_return_cstring

  JSNode js_tempnode;
  if (js_args->u.vinteger != 0) {
    js_vm_set_err(js_vm, "get_xml(): illegal number of arguments");
    js_vm_error(js_vm);
  }
    do {
#line 592 "ENode.jsi"

	ENode *node;
	EBufFreeMe *xml;

	node = js_instance->enode; 
	xml = enode_get_xml (node);	
	if (xml) {
	    js_retval->type = JS_STRING;
	    js_vm_make_string (js_vm, js_retval, xml->str, xml->len);
	}
    
#line 795 "js-ENode.c"
    } while(0);
  } else if(js_method == js_context->s_get_child_xml) {
#undef js_return
#define js_return js_return_cstring

  JSNode js_tempnode;
  if (js_args->u.vinteger != 0) {
    js_vm_set_err(js_vm, "get_child_xml(): illegal number of arguments");
    js_vm_error(js_vm);
  }
    do {
#line 604 "ENode.jsi"

	ENode *node;
	EBufFreeMe *xml;

	node = js_instance->enode; 
	xml = enode_get_child_xml (node);	
	if (xml) {
	    js_retval->type = JS_STRING;
	    js_vm_make_string (js_vm, js_retval, xml->str, xml->len);
	    ebuf_free (xml);
	} else {
	    js_retval->type = JS_NULL;
	}
    
#line 822 "js-ENode.c"
    } while(0);
  } else if(js_method == js_context->s_append_xml) {
#undef js_return
#define js_return js_return_undef

  char *xml = NULL;
  JSNode js_tempnode;
  if (js_args->u.vinteger != 1) {
    js_vm_set_err(js_vm, "append_xml(): illegal number of arguments");
    js_vm_error(js_vm);
  }
  js_vm_to_string(js_vm, &js_args[1], &js_tempnode);
  xml = js_string_to_c_string(js_vm, &js_tempnode);
    do {
#line 619 "ENode.jsi"

	ENode *node;
	EBuf *xmlbuf;
	node = js_instance->enode; 

	xmlbuf = ebuf_new_with_str (xml);
	enode_append_xml (node, xmlbuf);
	ebuf_free (xmlbuf);
    
#line 847 "js-ENode.c"
    } while(0);
  js_free(xml);
  } else if(js_method == js_context->s_set_data) {
#undef js_return
#define js_return js_return_undef

  char *data = NULL;
  JSNode js_tempnode;
  if (js_args->u.vinteger != 1) {
    js_vm_set_err(js_vm, "set_data(): illegal number of arguments");
    js_vm_error(js_vm);
  }
  js_vm_to_string(js_vm, &js_args[1], &js_tempnode);
  data = js_string_to_c_string(js_vm, &js_tempnode);
    do {
#line 629 "ENode.jsi"

	EBufFreeMe *databuf;
	databuf = ebuf_new_with_data (js_tempnode.u.vstring->data,
				      js_tempnode.u.vstring->len);
	enode_set_data (js_instance->enode, databuf);
	ebuf_free (databuf);
    
#line 871 "js-ENode.c"
    } while(0);
  js_free(data);
  } else if(js_method == js_context->s_get_data) {
#undef js_return
#define js_return js_return_cstring

  JSNode js_tempnode;
  if (js_args->u.vinteger != 0) {
    js_vm_set_err(js_vm, "get_data(): illegal number of arguments");
    js_vm_error(js_vm);
  }
    do {
#line 637 "ENode.jsi"

	EBufConst *data;

	data = enode_get_data (js_instance->enode);	
	if (data) {
	    js_retval->type = JS_STRING;
	    js_vm_make_string (js_vm, js_retval, data->str, data->len);
	} else {
	    js_retval->type = JS_NULL;
	}
    
#line 896 "js-ENode.c"
    } while(0);
  } else if(js_method == js_context->s_append_data) {
#undef js_return
#define js_return js_return_undef

  char *data = NULL;
  JSNode js_tempnode;
  if (js_args->u.vinteger != 1) {
    js_vm_set_err(js_vm, "append_data(): illegal number of arguments");
    js_vm_error(js_vm);
  }
  js_vm_to_string(js_vm, &js_args[1], &js_tempnode);
  data = js_string_to_c_string(js_vm, &js_tempnode);
    do {
#line 649 "ENode.jsi"

	EBufFreeMe *databuf;

	databuf = ebuf_new_with_data (js_tempnode.u.vstring->data,
				      js_tempnode.u.vstring->len);
	enode_append_data (js_instance->enode, databuf);
	ebuf_free (databuf);
    
#line 920 "js-ENode.c"
    } while(0);
  js_free(data);
  } else if(js_method == js_context->s_insert_data) {
#undef js_return
#define js_return js_return_undef

  long offset = 0;
  char *data = NULL;
  JSNode js_tempnode;
  if (js_args->u.vinteger != 2) {
    js_vm_set_err(js_vm, "insert_data(): illegal number of arguments");
    js_vm_error(js_vm);
  }
  js_vm_to_number(js_vm, &js_args[1], &js_tempnode);
  if(js_tempnode.type == JS_INTEGER) {
    offset = js_tempnode.u.vinteger;
  } else {
    js_vm_set_err(js_vm, "insert_data(): illegal argument (offset not an integer)");
    js_vm_error(js_vm);
  }
  js_vm_to_string(js_vm, &js_args[2], &js_tempnode);
  data = js_string_to_c_string(js_vm, &js_tempnode);
    do {
#line 658 "ENode.jsi"

	EBufFreeMe *databuf;

	databuf = ebuf_new_with_data (js_tempnode.u.vstring->data,
				      js_tempnode.u.vstring->len);
	enode_insert_data (js_instance->enode, offset, databuf);
	ebuf_free (databuf);
    
#line 953 "js-ENode.c"
    } while(0);
  js_free(data);
  } else if(js_method == js_context->s_delete_data) {
#undef js_return
#define js_return js_return_undef

  long offset = 0;
  long count = 0;
  JSNode js_tempnode;
  if (js_args->u.vinteger != 2) {
    js_vm_set_err(js_vm, "delete_data(): illegal number of arguments");
    js_vm_error(js_vm);
  }
  js_vm_to_number(js_vm, &js_args[1], &js_tempnode);
  if(js_tempnode.type == JS_INTEGER) {
    offset = js_tempnode.u.vinteger;
  } else {
    js_vm_set_err(js_vm, "delete_data(): illegal argument (offset not an integer)");
    js_vm_error(js_vm);
  }
  js_vm_to_number(js_vm, &js_args[2], &js_tempnode);
  if(js_tempnode.type == JS_INTEGER) {
    count = js_tempnode.u.vinteger;
  } else {
    js_vm_set_err(js_vm, "delete_data(): illegal argument (count not an integer)");
    js_vm_error(js_vm);
  }
    do {
#line 667 "ENode.jsi"

	enode_delete_data (js_instance->enode, offset, count);
    
#line 986 "js-ENode.c"
    } while(0);
  } else 
    return JS_PROPERTY_UNKNOWN;

js_done:
  return JS_PROPERTY_FOUND;
}

static int ENode_property(JSVirtualMachine *js_vm, JSBuiltinInfo *js_info, void *js_ictx, JSSymbol js_property, int js_op, JSNode *js_retval) {
  ENodeCtx *js_context = js_info->obj_context;
  ENodeInstanceCtx *js_instance = (ENodeInstanceCtx *)js_ictx;

  if(js_ictx == NULL) {
  
    return JS_PROPERTY_UNKNOWN;

  return JS_PROPERTY_FOUND;
  }

  if(js_property == js_context->s_type) {
    if(js_op == JS_BUILTIN_PROP_SET) {
      js_vm_set_err(js_vm, "type: read-only property");
      js_vm_error(js_vm);
    }
    else if(js_op == JS_BUILTIN_PROP_DELETE) {
      js_vm_set_err(js_vm, "type: undeletable property");
      js_vm_error(js_vm);
    }
    else {
#line 156 "ENode.jsi"

    	    
    	    ENode *node = js_instance->enode;
    	    EBufConst *type;
    	    
    	    type = enode_type (node);
    	    
    	    js_retval->type = JS_STRING;
    	    js_vm_make_string (js_vm, js_retval, type->str, type->len);
	    
	
#line 1028 "js-ENode.c"
    }
  } else if(js_property == js_context->s_attrib) {
    if(js_op == JS_BUILTIN_PROP_SET) {
      js_vm_set_err(js_vm, "attrib: read-only property");
      js_vm_error(js_vm);
    }
    else if(js_op == JS_BUILTIN_PROP_DELETE) {
      js_vm_set_err(js_vm, "attrib: undeletable property");
      js_vm_error(js_vm);
    }
    else {
#line 173 "ENode.jsi"

	    ENodeAttribInstanceCtx *ni;
	    JSBuiltinInfo *enode_info;
	    JSNode *enode_node;

	    enode_node = &js_vm->globals[js_vm_intern(js_vm, "ENodeAttrib")];
	    enode_info = enode_node->u.vbuiltin->info;

	    ni = js_calloc(js_vm, 1, sizeof(*ni));
	    ni->enode = js_instance->enode;
	    enode_ref (ni->enode);

	    js_vm_builtin_create(js_vm, js_retval, enode_info, ni);
	
#line 1056 "js-ENode.c"
    }
  } else if(js_property == js_context->s_attribval) {
    if(js_op == JS_BUILTIN_PROP_SET) {
      js_vm_set_err(js_vm, "attribval: read-only property");
      js_vm_error(js_vm);
    }
    else if(js_op == JS_BUILTIN_PROP_DELETE) {
      js_vm_set_err(js_vm, "attribval: undeletable property");
      js_vm_error(js_vm);
    }
    else {
#line 193 "ENode.jsi"

	    ENodeAttribInstanceCtx *ni;
	    JSBuiltinInfo *enode_info;
	    JSNode *enode_node;

	    enode_node = &js_vm->globals[js_vm_intern(js_vm, "ENodeAttribVal")];
	    enode_info = enode_node->u.vbuiltin->info;

	    ni = js_calloc(js_vm, 1, sizeof(*ni));
	    ni->enode = js_instance->enode;
	    enode_ref (ni->enode);

	    js_vm_builtin_create(js_vm, js_retval, enode_info, ni);
	
#line 1084 "js-ENode.c"
    }
  } else if(js_property == js_context->s_path) {
    if(js_op == JS_BUILTIN_PROP_SET) {
      js_vm_set_err(js_vm, "path: read-only property");
      js_vm_error(js_vm);
    }
    else if(js_op == JS_BUILTIN_PROP_DELETE) {
      js_vm_set_err(js_vm, "path: undeletable property");
      js_vm_error(js_vm);
    }
    else {
#line 213 "ENode.jsi"

    
	    ENode *node = js_instance->enode;
	    EBufFreeMe *path;
	    
	    path = enode_path (node);
	    
	    js_retval->type = JS_STRING;
	    js_vm_make_string (js_vm, js_retval, path->str, path->len);
	    ebuf_free (path);

	
#line 1110 "js-ENode.c"
    }
  } else if(js_property == js_context->s_basename) {
    if(js_op == JS_BUILTIN_PROP_SET) {
      js_vm_set_err(js_vm, "basename: read-only property");
      js_vm_error(js_vm);
    }
    else if(js_op == JS_BUILTIN_PROP_DELETE) {
      js_vm_set_err(js_vm, "basename: undeletable property");
      js_vm_error(js_vm);
    }
    else {
#line 231 "ENode.jsi"

	
	    EBufFreeMe *basename;
	    ENode *node = js_instance->enode;
	    
	    basename = enode_basename (node);
	    
	    js_retval->type = JS_STRING;
	    js_vm_make_string (js_vm, js_retval, basename->str, basename->len);
	    ebuf_free (basename);

	
#line 1136 "js-ENode.c"
    }
  } else if(js_property == js_context->s_description) {
    if(js_op == JS_BUILTIN_PROP_SET) {
      js_vm_set_err(js_vm, "description: read-only property");
      js_vm_error(js_vm);
    }
    else if(js_op == JS_BUILTIN_PROP_DELETE) {
      js_vm_set_err(js_vm, "description: undeletable property");
      js_vm_error(js_vm);
    }
    else {
#line 249 "ENode.jsi"

	
	    ENode *node = js_instance->enode;
	    gchar *description;
	    
	    description = enode_description (node);
	    
	    if (description) {
		js_retval->type = JS_STRING;
		js_vm_make_string (js_vm, js_retval, description, strlen (description));
	    } else {
		js_retval->type = JS_NULL;
	    }
	
#line 1164 "js-ENode.c"
    }
  } else 
    return JS_PROPERTY_UNKNOWN;

js_done:
  return JS_PROPERTY_FOUND;
}

static void ENode_constructor(JSVirtualMachine *js_vm, JSBuiltinInfo *js_info, JSNode *js_args, JSNode *js_retval) {
  ENodeInstanceCtx *js_instance = js_calloc(js_vm, 1, sizeof(*js_instance));
  char *basename = NULL;
  JSNode js_tempnode;
  if (js_args->u.vinteger != 1) {
    js_free(js_instance);
    js_vm_set_err(js_vm, "ENode(): illegal number of arguments");
    js_vm_error(js_vm);
  }
  js_vm_to_string(js_vm, &js_args[1], &js_tempnode);
  basename = js_string_to_c_string(js_vm, &js_tempnode);
  do {
#line 139 "ENode.jsi"

	js_instance->enode = enode (enode_call_reference(), basename);
	enode_ref (js_instance->enode);
    
#line 1190 "js-ENode.c"
  } while(0);
js_done:
  js_free(basename);
  js_vm_builtin_create(js_vm, js_retval, js_info, js_instance);
}

static void ENode_destructor(JSBuiltinInfo *js_info, void *js_ictx) {
  ENodeInstanceCtx *js_instance = js_ictx;
  if(js_instance) {
    do {
#line 577 "ENode.jsi"

	/* g_print ("deleting node %s\n", js_instance->enode->element->str); */
	enode_unref (js_instance->enode);
    
#line 1206 "js-ENode.c"
    } while(0);
    js_free(js_instance);
  }
}

static int ENode_query(JSVirtualMachine *js_vm, JSBuiltinInfo *js_info, void *js_ictx, JSSymbol js_symbol) {
  ENodeCtx *js_context = js_info->obj_context;

  if(js_ictx == NULL) {
    return JS_PROPERTY_UNKNOWN;
  }

  if(js_symbol == js_context->s_new_child) return JS_PROPERTY_FOUND;
  else if(js_symbol == js_context->s_type) return JS_PROPERTY_FOUND;
  else if(js_symbol == js_context->s_attrib) return JS_PROPERTY_FOUND;
  else if(js_symbol == js_context->s_attribval) return JS_PROPERTY_FOUND;
  else if(js_symbol == js_context->s_path) return JS_PROPERTY_FOUND;
  else if(js_symbol == js_context->s_basename) return JS_PROPERTY_FOUND;
  else if(js_symbol == js_context->s_description) return JS_PROPERTY_FOUND;
  else if(js_symbol == js_context->s_parent) return JS_PROPERTY_FOUND;
  else if(js_symbol == js_context->s_child) return JS_PROPERTY_FOUND;
  else if(js_symbol == js_context->s_child_rx) return JS_PROPERTY_FOUND;
  else if(js_symbol == js_context->s_children) return JS_PROPERTY_FOUND;
  else if(js_symbol == js_context->s_children_rx) return JS_PROPERTY_FOUND;
  else if(js_symbol == js_context->s_children_attrib) return JS_PROPERTY_FOUND;
  else if(js_symbol == js_context->s_children_attrib_rx) return JS_PROPERTY_FOUND;
  else if(js_symbol == js_context->s_call) return JS_PROPERTY_FOUND;
  else if(js_symbol == js_context->s_attrib_quiet) return JS_PROPERTY_FOUND;
  else if(js_symbol == js_context->s_attrib_is_true) return JS_PROPERTY_FOUND;
  else if(js_symbol == js_context->s_list_set_attribs) return JS_PROPERTY_FOUND;
  else if(js_symbol == js_context->s_supported_attribs) return JS_PROPERTY_FOUND;
  else if(js_symbol == js_context->s_attrib_description) return JS_PROPERTY_FOUND;
  else if(js_symbol == js_context->s_attrib_value_type) return JS_PROPERTY_FOUND;
  else if(js_symbol == js_context->s_attrib_possible_values) return JS_PROPERTY_FOUND;
  else if(js_symbol == js_context->s_attribs_sync) return JS_PROPERTY_FOUND;
  else if(js_symbol == js_context->s_destroy) return JS_PROPERTY_FOUND;
  else if(js_symbol == js_context->s_destroy_children) return JS_PROPERTY_FOUND;
  else if(js_symbol == js_context->s_get_xml) return JS_PROPERTY_FOUND;
  else if(js_symbol == js_context->s_get_child_xml) return JS_PROPERTY_FOUND;
  else if(js_symbol == js_context->s_append_xml) return JS_PROPERTY_FOUND;
  else if(js_symbol == js_context->s_set_data) return JS_PROPERTY_FOUND;
  else if(js_symbol == js_context->s_get_data) return JS_PROPERTY_FOUND;
  else if(js_symbol == js_context->s_append_data) return JS_PROPERTY_FOUND;
  else if(js_symbol == js_context->s_insert_data) return JS_PROPERTY_FOUND;
  else if(js_symbol == js_context->s_delete_data) return JS_PROPERTY_FOUND;
  else return JS_PROPERTY_UNKNOWN;
}

static int ENode_enumerate(JSVirtualMachine *js_vm, JSBuiltinInfo *js_info, void *js_ictx, int js_nth, JSNode *js_retval) {
  if(js_ictx == NULL) {
    switch(js_nth) {
      default:
        return js_vm_object_nth (js_vm, js_info->prototype, js_nth - 0, js_retval);
    }
  }

  switch(js_nth) {
    case 0:
      js_vm_make_static_string(js_vm, js_retval, "type", 4);
      return 1;
    case 1:
      js_vm_make_static_string(js_vm, js_retval, "attrib", 6);
      return 1;
    case 2:
      js_vm_make_static_string(js_vm, js_retval, "attribval", 9);
      return 1;
    case 3:
      js_vm_make_static_string(js_vm, js_retval, "path", 4);
      return 1;
    case 4:
      js_vm_make_static_string(js_vm, js_retval, "basename", 8);
      return 1;
    case 5:
      js_vm_make_static_string(js_vm, js_retval, "description", 11);
      return 1;
    default:
      return js_vm_object_nth (js_vm, js_retval->u.vbuiltin->prototype, js_nth - 6, js_retval);
  }
}

#undef js_return
#define js_return js_return_object

static void enode_global(JSVirtualMachine *js_vm, JSBuiltinInfo *js_info, void *js_instance, JSNode *js_retval, JSNode *js_args) {
  char *basename = NULL;
  JSNode js_tempnode;
  if (js_args->u.vinteger != 1) {
    js_vm_set_err(js_vm, "enode(): illegal number of arguments");
    js_vm_error(js_vm);
  }
  js_vm_to_string(js_vm, &js_args[1], &js_tempnode);
  basename = js_string_to_c_string(js_vm, &js_tempnode);
  do {
#line 674 "ENode.jsi"


    ENode *node;
    JSBuiltinInfo *enode_info;

    node = enode (enode_call_reference(), basename);

    if (node) {
	JSNode *enode_node;
	enode_node = &js_vm->globals[js_vm_intern(js_vm, "ENode")];
	enode_info = enode_node->u.vbuiltin->info;
	js_return_enode (js_vm, enode_info, js_retval, node);
    } else {
	js_retval->type = JS_NULL;
    }

#line 1317 "js-ENode.c"
  } while(0);
js_done:
  js_free(basename);
  return;
}

#undef js_return
#define js_return js_return_object

static void enode_rx_global(JSVirtualMachine *js_vm, JSBuiltinInfo *js_info, void *js_instance, JSNode *js_retval, JSNode *js_args) {
  char *regex = NULL;
  JSNode js_tempnode;
  if (js_args->u.vinteger != 1) {
    js_vm_set_err(js_vm, "enode_rx(): illegal number of arguments");
    js_vm_error(js_vm);
  }
  js_vm_to_string(js_vm, &js_args[1], &js_tempnode);
  regex = js_string_to_c_string(js_vm, &js_tempnode);
  do {
#line 691 "ENode.jsi"


    ENode *node;
    JSBuiltinInfo *enode_info;

    node = enode_rx (enode_call_reference(), regex);

    if (node) {
	JSNode *enode_node;
	enode_node = &js_vm->globals[js_vm_intern(js_vm, "ENode")];
	enode_info = enode_node->u.vbuiltin->info;
	js_return_enode (js_vm, enode_info, js_retval, node);
    } else {
	js_retval->type = JS_NULL;
    }

#line 1354 "js-ENode.c"
  } while(0);
js_done:
  js_free(regex);
  return;
}

void njs_extension_entry(JSVirtualMachine *js_vm) {
  JSNode *js_node;
  JSBuiltinInfo *js_info;
  ENodeCtx *ENodectx;

  ENodectx = js_calloc(js_vm, 1, sizeof(*ENodectx));
  ENodectx->s_new_child = js_vm_intern(js_vm, "new_child");
  ENodectx->s_type = js_vm_intern(js_vm, "type");
  ENodectx->s_attrib = js_vm_intern(js_vm, "attrib");
  ENodectx->s_attribval = js_vm_intern(js_vm, "attribval");
  ENodectx->s_path = js_vm_intern(js_vm, "path");
  ENodectx->s_basename = js_vm_intern(js_vm, "basename");
  ENodectx->s_description = js_vm_intern(js_vm, "description");
  ENodectx->s_parent = js_vm_intern(js_vm, "parent");
  ENodectx->s_child = js_vm_intern(js_vm, "child");
  ENodectx->s_child_rx = js_vm_intern(js_vm, "child_rx");
  ENodectx->s_children = js_vm_intern(js_vm, "children");
  ENodectx->s_children_rx = js_vm_intern(js_vm, "children_rx");
  ENodectx->s_children_attrib = js_vm_intern(js_vm, "children_attrib");
  ENodectx->s_children_attrib_rx = js_vm_intern(js_vm, "children_attrib_rx");
  ENodectx->s_call = js_vm_intern(js_vm, "call");
  ENodectx->s_attrib_quiet = js_vm_intern(js_vm, "attrib_quiet");
  ENodectx->s_attrib_is_true = js_vm_intern(js_vm, "attrib_is_true");
  ENodectx->s_list_set_attribs = js_vm_intern(js_vm, "list_set_attribs");
  ENodectx->s_supported_attribs = js_vm_intern(js_vm, "supported_attribs");
  ENodectx->s_attrib_description = js_vm_intern(js_vm, "attrib_description");
  ENodectx->s_attrib_value_type = js_vm_intern(js_vm, "attrib_value_type");
  ENodectx->s_attrib_possible_values = js_vm_intern(js_vm, "attrib_possible_values");
  ENodectx->s_attribs_sync = js_vm_intern(js_vm, "attribs_sync");
  ENodectx->s_destroy = js_vm_intern(js_vm, "destroy");
  ENodectx->s_destroy_children = js_vm_intern(js_vm, "destroy_children");
  ENodectx->s_get_xml = js_vm_intern(js_vm, "get_xml");
  ENodectx->s_get_child_xml = js_vm_intern(js_vm, "get_child_xml");
  ENodectx->s_append_xml = js_vm_intern(js_vm, "append_xml");
  ENodectx->s_set_data = js_vm_intern(js_vm, "set_data");
  ENodectx->s_get_data = js_vm_intern(js_vm, "get_data");
  ENodectx->s_append_data = js_vm_intern(js_vm, "append_data");
  ENodectx->s_insert_data = js_vm_intern(js_vm, "insert_data");
  ENodectx->s_delete_data = js_vm_intern(js_vm, "delete_data");
  js_info = js_vm_builtin_info_create(js_vm);
  js_info->method_proc = ENode_method;
  js_info->property_proc = ENode_property;
  js_info->new_proc = ENode_constructor;
  js_info->delete_proc = ENode_destructor;
  js_info->query_proc = ENode_query;
  js_info->enumerate_proc = ENode_enumerate;
  js_info->obj_context = ENodectx;
  js_info->obj_context_delete = js_free;
  js_node = &js_vm->globals[js_vm_intern(js_vm, "ENode")];
  js_vm_builtin_create(js_vm, js_node, js_info, NULL);
  js_info = js_vm_builtin_info_create(js_vm);
  js_info->global_method_proc = enode_global;
  js_node = &js_vm->globals[js_vm_intern(js_vm, "enode")];
  js_vm_builtin_create(js_vm, js_node, js_info, NULL);

  js_info = js_vm_builtin_info_create(js_vm);
  js_info->global_method_proc = enode_rx_global;
  js_node = &js_vm->globals[js_vm_intern(js_vm, "enode_rx")];
  js_vm_builtin_create(js_vm, js_node, js_info, NULL);

  return;
}
