/* This file was autogenerated by jig 0.3.0 from file ENodeAttrib.jsi * * I
 * have since been modifying it directly to acheive what I need * from it.
 * -Ian */

#include <njs/jig.h>
#include "js-ENodeAttrib.h"


/* 
 * Javascript binding for Entity
 * Copyright (c) 2000 Ian Main
 *
 * Author: Ian Main <imain@gtk.org> 
 *          
 */

/* 
 * This renderer is free software; please see the LICENSE file for
 * specific information as to licensing conditions.
 */

/* 
 * $Source: /home/cvs/entity/renderers/javascript/js-ENodeAttrib.c,v $
 * $Id: js-ENodeAttrib.c,v 1.10 2000/10/04 01:23:01 imain Exp $
 */


static int
ENodeAttrib_method (JSVirtualMachine * js_vm, JSBuiltinInfo * js_info,
		    void *js_ictx, JSSymbol js_method,
		    JSNode * js_retval, JSNode * js_args)
{
    return JS_PROPERTY_UNKNOWN;
}


/********************************************************************
 * The important ones
 ********************************************************************/

static int
ENodeAttrib_property (JSVirtualMachine * js_vm, JSBuiltinInfo * js_info,
		      void *js_ictx, JSSymbol js_property,
		      int js_op, JSNode * js_value)
{
    ENodeAttribInstanceCtx *js_instance = (ENodeAttribInstanceCtx *) js_ictx;

    if (js_ictx == NULL) {
	return JS_PROPERTY_UNKNOWN;
    }

    if (js_op == JS_BUILTIN_PROP_SET) {

	JSNode js_tempnode;
	EBuf *value;
	const char *attrib = js_vm_symname (js_vm, js_property);

	js_vm_to_string (js_vm, js_value, &js_tempnode);
	value =
	    ebuf_new_with_data (js_tempnode.u.vstring->data,
				js_tempnode.u.vstring->len);

	enode_attrib (js_instance->enode, (char *) attrib, value);

    } else if (js_op == JS_BUILTIN_PROP_GET) {

	EBufConst *value;
	const char *attrib = js_vm_symname (js_vm, js_property);

	EDEBUG (
		("javascript", "Getting attrib '%s' (%d) from node %p - '%s'",
		 attrib, js_property, js_instance->enode,
		 js_instance->enode->element->str));

	value = enode_attrib (js_instance->enode, (char *) attrib, NULL);

	EDEBUG (
		("javascript",
		 "Attribute value for '%s' is '%s' from node '%s'", attrib,
		 value->str, js_instance->enode->element->str));

	js_value->type = JS_STRING;
	js_vm_make_string (js_vm, js_value, value->str, value->len);
    }

    return JS_PROPERTY_FOUND;
}

static int
ENodeAttribVal_property (JSVirtualMachine * js_vm, JSBuiltinInfo * js_info,
			 void *js_ictx, JSSymbol js_property,
			 int js_op, JSNode * js_value)
{
    ENodeAttribInstanceCtx *js_instance = (ENodeAttribInstanceCtx *) js_ictx;

    if (js_ictx == NULL) {
	return JS_PROPERTY_UNKNOWN;
    }

    if (js_op == JS_BUILTIN_PROP_SET) {

	JSNode js_tempnode;
	EBuf *value;
	const char *attrib = js_vm_symname (js_vm, js_property);

	js_vm_to_string (js_vm, js_value, &js_tempnode);
	value =
	    ebuf_new_with_data (js_tempnode.u.vstring->data,
				js_tempnode.u.vstring->len);

	enode_attrib (js_instance->enode, (char *) attrib, value);

    } else if (js_op == JS_BUILTIN_PROP_GET) {

	EBufConst *value;
	float fval;
	char *end;

	const char *attrib = js_vm_symname (js_vm, js_property);

	if (attrib) {

	    EDEBUG (("js-embed", "Getting attrib %s as value", attrib));
	    value = enode_attrib (js_instance->enode, (char *) attrib, NULL);

	    EDEBUG (("js-embed", "calculating float value of %s", value->str));
	    fval = strtod (value->str, &end);

	    if (end && (value->str == end))
		fval = 0.0;

	    EDEBUG (("js-embed", "float value of %s is %f", value->str, fval));
	    js_value->type = JS_FLOAT;
	    js_value->u.vfloat = fval;
	}
    }

    return JS_PROPERTY_FOUND;
}




static void
ENodeAttrib_constructor (JSVirtualMachine * js_vm, JSBuiltinInfo * js_info,
			 JSNode * js_args, JSNode * js_retval)
{
    ENodeAttribInstanceCtx *js_instance =
	js_calloc (js_vm, 1, sizeof (*js_instance));
    char *basename = NULL;
    JSNode js_tempnode;

    if (js_args->u.vinteger != 1) {
	js_free (js_instance);
	js_vm_set_err (js_vm, "ENodeAttrib(): illegal number of arguments");
	js_vm_error (js_vm);
    }

    js_vm_to_string (js_vm, &js_args[1], &js_tempnode);
    basename = js_string_to_c_string (js_vm, &js_tempnode);

    do {

	js_instance->enode = enode (enode_call_reference (), basename);
	enode_ref (js_instance->enode);

    } while (0);

    js_free (basename);
    js_vm_builtin_create (js_vm, js_retval, js_info, js_instance);
}



static void
ENodeAttrib_destructor (JSBuiltinInfo * js_info, void *js_ictx)
{
    ENodeAttribInstanceCtx *js_instance = js_ictx;

    if (js_instance) {
	/* g_print ("deleting node attrib %s\n",
	 * js_instance->enode->element->str); */
	enode_unref (js_instance->enode);
	js_free (js_instance);
    }
}



static int
ENodeAttrib_query (JSVirtualMachine * js_vm, JSBuiltinInfo * js_info,
		   void *js_ictx, JSSymbol js_symbol)
{
    return JS_PROPERTY_UNKNOWN;
}

static int
ENodeAttrib_enumerate (JSVirtualMachine * js_vm, JSBuiltinInfo * js_info,
		       void *js_ictx, int js_nth, JSNode * js_retval)
{
    if (js_ictx == NULL) {
	switch (js_nth) {
	default:
	    return js_vm_object_nth (js_vm, js_info->prototype, js_nth - 0,
				     js_retval);
	}
    }

    switch (js_nth) {
    default:
	return js_vm_object_nth (js_vm, js_retval->u.vbuiltin->prototype,
				 js_nth - 0, js_retval);
    }
}

void
js_Entity_ENodeAttrib (JSVirtualMachine * js_vm)
{
    JSNode *js_node;
    JSBuiltinInfo *js_info;
    ENodeAttribCtx *ctx;

    ctx = js_calloc (js_vm, 1, sizeof (*ctx));
    js_info = js_vm_builtin_info_create (js_vm);
    js_info->method_proc = ENodeAttrib_method;
    js_info->property_proc = ENodeAttrib_property;
    js_info->new_proc = ENodeAttrib_constructor;
    js_info->delete_proc = ENodeAttrib_destructor;
    js_info->query_proc = ENodeAttrib_query;
    js_info->enumerate_proc = ENodeAttrib_enumerate;
    js_info->obj_context = ctx;
    js_info->obj_context_delete = js_free;
    js_node = &js_vm->globals[js_vm_intern (js_vm, "ENodeAttrib")];
    js_vm_builtin_create (js_vm, js_node, js_info, NULL);

    ctx = js_calloc (js_vm, 1, sizeof (*ctx));
    js_info = js_vm_builtin_info_create (js_vm);
    js_info->method_proc = ENodeAttrib_method;
    js_info->property_proc = ENodeAttribVal_property;
    js_info->new_proc = ENodeAttrib_constructor;
    js_info->delete_proc = ENodeAttrib_destructor;
    js_info->query_proc = ENodeAttrib_query;
    js_info->enumerate_proc = ENodeAttrib_enumerate;
    js_info->obj_context = ctx;
    js_info->obj_context_delete = js_free;
    js_node = &js_vm->globals[js_vm_intern (js_vm, "ENodeAttribVal")];
    js_vm_builtin_create (js_vm, js_node, js_info, NULL);
}
