class Enode:
	"""
	Enode interface class:
	
	based on docs/ENode.idl, any docs about the ENode interface should apply to
	this manifestation as well.
	"""

	#===============================================
	# Base Interface
	#===============================================

	def __init__(path):
		pass	

	def new_child (basename, attribs):
		pass

	def type():
		pass

	def path():
		pass

	def basename():
		pass

	def description():
		pass

	
	#===============================================
	# Node Search Functions
	#==============================================

	def parent(search=None):
		pass

	def child(search=None):
		pass

	def child_rx(regex):
		pass

	def children(search=None):
		pass

	def children_rx(regex):
		pass

	def children_filter (func, user_data):
		pass



	#===============================================
	# Object Based Utils
	#===============================================


	def call (obj, func_name, args):
		pass

	
	#=====================================================
	# Attribute Properties and Attribute Support Queries
	#=====================================================


	def attrib (attribute, value = None):
		pass

	def attrib_quiet (attribute, value = None):
		pass

	def attrib_is_true (attrib):
		pass

	def get_set_attribs ():
		pass

	def supported_attribs ():
		pass

	def attrib_description (attribute):
		pass

	def attrib_value_type (attribute):
		pass

	def attrib_possible_values (attribute):
		pass

	def attribs_sync ():
		pass



	#=====================================================
	# Arbitrary key/value Attachment
	#=====================================================

	def set_kv (key, value):
		pass

	def get_kv (key):
		pass


	#=====================================================
	# Node destruction
	#=====================================================

	def destroy ():
		pass

	def destroy_children ():
		pass

	#=====================================================
	# Raw XML Interfaces
	#=====================================================

	def get_xml ():
		pass

	def get_child_xml ():
		pass

	def append_xml (xml):
		pass


	#=====================================================
	# Node Data interface
	#=====================================================


	def set_data (data):
		pass

	def get_data ():
		pass

	def append_data (data):
		pass

	def insert_data (offset, data):
		pass

	def delete_data (offset, count):
		pass
	
