#!/usr/bin/env entity
<object>
  <window title="hi" width="400" height="500" ondelete="entity:exit">
   <button label="Set width 0" onclick="dowidth" />
   <button label="Set width 30" onclick="dowidth30" />
   <button label="Set width 60" onclick="dowidth60" />
   <button label="Add 5 rows" onclick="add5rows" />
   <button label="Delete 5 rows" onclick="del5rows" />
   <halign> 
     <spinner name="rownum" min="1" max="10000" value="3"/>
     <button label="Delete Row" onclick="delrow" />
   </halign>
   <clist expand="true" name="list" cols="3" maxcols="5" width="150" 
   	  selection-sytle="browse" onselect="change_me">
       <cl-title>
	  <string text="Col 1" width="160"/>
	  <string text="Col 2" width="160"/>
	  <string text="Col 3" width="160"/>
       </cl-title>
       <cl-row><string text="9r1c1"/></cl-row>
       <cl-row><string text="8r2c1"/><string text="r2c2"/></cl-row>
       <cl-row>
         <string text="r2c1"/><string text="r2c2"/><string text="r2c3"/>
       </cl-row>
   </clist>

   <clist name="test2" cols="2" onselect="find_selected" ondeselect="who_that">
     <cl-title>
       <string text="col 1"/>
       <string text="col 2"/>
     </cl-title>
     <cl-row name="second">
       <string text="Top" name="top1"/>
       <string text="element 2" name="top2"/>
     </cl-row>
     <cl-row>
       <string text="second" name="second1"/>
       <string text="element 2" name="second2"/>
     </cl-row>
   </clist>
   <button label="Toggle Top's selection" onclick="toggle_top"/>

   <perl>
   <![CDATA[

sub toggle_top
{
  my $cl_row = enode("cl-row.second");

  my $selected = $cl_row->attrib("selected");
  print "selected state is $selected\n";
  if ($cl_row->attrib_is_true("selected") )
  {
    $cl_row->attrib("selected" => "false");
  }
  else
  {
    $cl_row->attrib("selected" => "true");
  }
}
sub find_selected
{
  my $cl_row = shift;    # In order to show that the selection works we just ignore this.
  my $clist = enode("clist.test2");
  my @selected_children = $clist->children_attrib("selected", "true");
  foreach my $child (@selected_children)
  {
    print "selected cl-row is:  $child\n";
  }
}
sub who_that
{
  my $cl_row = shift;
  print "deselected cl-row is:  $cl_row\n";
}
   
   my $clist = enode("clist.list");
   my $xml;

   $clist->attrib("frozen" => "true");
   for($i = 0; $i< 15; $i++)
	{

	   $xml = qq!<cl-row>
   			<string text="r2c1"/><string text="r2c2"/><string text="r2c3"/>
			</cl-row>
		!;

	   $clist->append_xml($xml);
        }
   $clist->attrib("frozen" => "false");

   sub dowidth   { enode("cl-header.deleteme")->attrib("width" =>  "0"); }

   sub dowidth30 { enode("cl-header.deleteme")->attrib("width" => "30"); }

   sub dowidth60 { enode("cl-header.deleteme")->attrib("width" => "60"); }
   
   sub add5rows 
   { 
     my $clist = enode("clist.list");
     
     for (my $i = 0; $i < 5; $i++) {
        $node = $clist->new_child ("cl-row");
	$node->new_child ("string", "text" => "new row $i");
	$node->new_child ("string", "text" => "col2 new row $i");
	$node->new_child ("string", "text" => "col3 new row $i");
     }
   }
   
   sub delrow
   {
     my $node = enode("clist.list");
     my $row = enode("spinner.rownum")->attrib("value");
     my @nodes = $node->children();
     $nodes[$row]->destroy ();
   }
   
   sub del5rows
   {
     my $node = enode("clist.list");
     my @nodes = $node->children ();
     
     # Go to 6 cause we're always skipping cl-title
     for (my $i = 0; $i < 6; $i++)
     {
        if ($nodes[$i] && ($nodes[$i]->type() eq "cl-row"))
	  {
	     	print ("deleting $nodes[$i]\n");
		$nodes[$i]->destroy();
	  }
     }
   }
   
   sub change_me
   {
     print "in change_me\n";

     my $cl_row = shift;
     my @strings = $cl_row->children();
     #$strings[0]->destroy();  #delete first element
     #$strings[1]->destroy();  #delete first element
     $strings[0]->attrib("text" => "Yo");
     $strings[1]->attrib("text" => "changed attrib");
     #$strings[2]->destroy();

     #my $xml = qq!<string text="delete and replace"/>! x 3;
     #$cl_row->append_xml($xml);

   }

   ]]></perl>
  </window>
</object>

<!-- 
   <cl-row visible="false"> 
     Hides this row. If it is the row with the <cl-header> 
           tags, the buttons a hidden. 
   <cl-title>  
      title - sets the title for this column.
      onclick - function to call when button clicked.
              - or if not set then titles cannot be selected.
      sort -  (de|a)ccend[:(no)case]
      sortattrib - attrib to sort on, text attrib by default.
      align - left|center|right|justify
-->
