/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.css.engine;

import org.apache.batik.css.engine.CSSEngine;
import org.apache.batik.css.engine.value.Value;

public class StyleDeclaration {
    protected static final int INITIAL_LENGTH = 8;
    protected Value[] values = new Value[8];
    protected int[] indexes = new int[8];
    protected boolean[] priorities = new boolean[8];
    protected int count;

    public int size() {
        return this.count;
    }

    public Value getValue(int n) {
        return this.values[n];
    }

    public int getIndex(int n) {
        return this.indexes[n];
    }

    public boolean getPriority(int n) {
        return this.priorities[n];
    }

    public void remove(int n) {
        --this.count;
        int n2 = n;
        while (n2 < this.count) {
            this.values[n2] = this.values[n2 + 1];
            this.indexes[n2] = this.indexes[n2 + 1];
            this.priorities[n2] = this.priorities[n2 + 1];
            ++n2;
        }
    }

    public void put(int n, Value value, int n2, boolean bl) {
        this.values[n] = value;
        this.indexes[n] = n2;
        this.priorities[n] = bl;
    }

    public void append(Value value, int n, boolean bl) {
        if (this.values.length == this.count) {
            Value[] valueArray = new Value[this.count * 2];
            int[] nArray = new int[this.count * 2];
            boolean[] blArray = new boolean[this.count * 2];
            int n2 = 0;
            while (n2 < this.count) {
                valueArray[n2] = this.values[n2];
                nArray[n2] = this.indexes[n2];
                blArray[n2] = this.priorities[n2];
                ++n2;
            }
            this.values = valueArray;
            this.indexes = nArray;
            this.priorities = blArray;
        }
        this.values[this.count] = value;
        this.indexes[this.count] = n;
        this.priorities[this.count] = bl;
        ++this.count;
    }

    public String toString(CSSEngine cSSEngine) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.count) {
            stringBuffer.append(cSSEngine.getPropertyName(this.indexes[n]));
            stringBuffer.append(": ");
            stringBuffer.append(this.values[n]);
            stringBuffer.append(";\n");
            ++n;
        }
        return stringBuffer.toString();
    }
}

