/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.spi;

import java.io.IOException;
import java.io.InputStream;
import org.apache.batik.ext.awt.image.codec.PNGDecodeParam;
import org.apache.batik.ext.awt.image.codec.PNGRed;
import org.apache.batik.ext.awt.image.renderable.DeferRable;
import org.apache.batik.ext.awt.image.renderable.Filter;
import org.apache.batik.ext.awt.image.renderable.RedRable;
import org.apache.batik.ext.awt.image.rendered.AbstractRed;
import org.apache.batik.ext.awt.image.rendered.Any2sRGBRed;
import org.apache.batik.ext.awt.image.spi.ImageTagRegistry;
import org.apache.batik.ext.awt.image.spi.MagicNumberRegistryEntry;
import org.apache.batik.util.ParsedURL;

public class PNGRegistryEntry
extends MagicNumberRegistryEntry {
    static final byte[] signature = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};

    public PNGRegistryEntry() {
        super("PNG", "png", "image/png", 0, signature);
    }

    public Filter handleStream(InputStream inputStream, ParsedURL parsedURL, boolean bl) {
        Object[] objectArray;
        String string;
        final DeferRable deferRable = new DeferRable();
        final InputStream inputStream2 = inputStream;
        final boolean bl2 = bl;
        if (parsedURL != null) {
            string = "url.format.unreadable";
            objectArray = new Object[]{"PNG", parsedURL};
        } else {
            string = "stream.format.unreadable";
            objectArray = new Object[]{"PNG"};
        }
        Thread thread = new Thread(){

            public void run() {
                Filter filter;
                try {
                    PNGDecodeParam pNGDecodeParam = new PNGDecodeParam();
                    pNGDecodeParam.setExpandPalette(true);
                    if (bl2) {
                        pNGDecodeParam.setPerformGammaCorrection(false);
                    } else {
                        pNGDecodeParam.setPerformGammaCorrection(true);
                        pNGDecodeParam.setDisplayExponent(2.2f);
                    }
                    AbstractRed abstractRed = new PNGRed(inputStream2, pNGDecodeParam);
                    abstractRed = new Any2sRGBRed(abstractRed);
                    filter = new RedRable(abstractRed);
                }
                catch (IOException iOException) {
                    filter = ImageTagRegistry.getBrokenLinkImage(this, string, objectArray);
                }
                catch (Throwable throwable) {
                    filter = ImageTagRegistry.getBrokenLinkImage(this, string, objectArray);
                }
                deferRable.setSource(filter);
            }
        };
        thread.start();
        return deferRable;
    }
}

