/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.extension.svg;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.batik.bridge.Bridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.SVGTextElementBridge;
import org.apache.batik.bridge.SVGUtilities;
import org.apache.batik.bridge.TextUtilities;
import org.apache.batik.bridge.UnitProcessor;
import org.apache.batik.dom.util.XLinkSupport;
import org.apache.batik.dom.util.XMLSupport;
import org.apache.batik.extension.svg.BatikExtConstants;
import org.apache.batik.gvt.TextNode;
import org.apache.batik.gvt.text.GVTAttributedCharacterIterator;
import org.apache.batik.gvt.text.MarginInfo;
import org.apache.batik.util.UnitProcessor;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SVGFlowTextElementBridge
extends SVGTextElementBridge
implements BatikExtConstants {
    public static final AttributedCharacterIterator.Attribute FLOW_PARAGRAPH = GVTAttributedCharacterIterator.TextAttribute.FLOW_PARAGRAPH;
    public static final AttributedCharacterIterator.Attribute FLOW_EMPTY_PARAGRAPH = GVTAttributedCharacterIterator.TextAttribute.FLOW_EMPTY_PARAGRAPH;
    public static final AttributedCharacterIterator.Attribute FLOW_LINE_BREAK = GVTAttributedCharacterIterator.TextAttribute.FLOW_LINE_BREAK;
    public static final AttributedCharacterIterator.Attribute FLOW_REGIONS = GVTAttributedCharacterIterator.TextAttribute.FLOW_REGIONS;
    protected static final GVTAttributedCharacterIterator.TextAttribute TEXTPATH = GVTAttributedCharacterIterator.TextAttribute.TEXTPATH;
    protected static final GVTAttributedCharacterIterator.TextAttribute ANCHOR_TYPE = GVTAttributedCharacterIterator.TextAttribute.ANCHOR_TYPE;
    protected static final GVTAttributedCharacterIterator.TextAttribute LETTER_SPACING = GVTAttributedCharacterIterator.TextAttribute.LETTER_SPACING;
    protected static final GVTAttributedCharacterIterator.TextAttribute WORD_SPACING = GVTAttributedCharacterIterator.TextAttribute.WORD_SPACING;
    protected static final GVTAttributedCharacterIterator.TextAttribute KERNING = GVTAttributedCharacterIterator.TextAttribute.KERNING;

    public String getNamespaceURI() {
        return "http://xml.apache.org/batik/ext";
    }

    public String getLocalName() {
        return "flowText";
    }

    public Bridge getInstance() {
        return new SVGFlowTextElementBridge();
    }

    public boolean isComposite() {
        return false;
    }

    protected Point2D getLocation(BridgeContext bridgeContext, Element element) {
        return new Point2D.Float(0.0f, 0.0f);
    }

    protected AttributedString buildAttributedString(BridgeContext bridgeContext, Element element) {
        List list = this.getRegions(bridgeContext, element);
        AttributedString attributedString = this.getFlowDiv(bridgeContext, element);
        attributedString.addAttribute(FLOW_REGIONS, list, 0, 1);
        return attributedString;
    }

    protected void addGlyphPositionAttributes(AttributedString attributedString, Element element, BridgeContext bridgeContext) {
        if (element.getNodeType() != 1) {
            return;
        }
        String string = element.getNamespaceURI();
        if (!string.equals(this.getNamespaceURI()) && !string.equals("http://www.w3.org/2000/svg")) {
            return;
        }
        if (element.getLocalName() != "flowText") {
            super.addGlyphPositionAttributes(attributedString, element, bridgeContext);
            return;
        }
        Node node = element.getFirstChild();
        while (node != null) {
            if (node.getNodeType() == 1) {
                Element element2;
                String string2;
                String string3 = node.getNamespaceURI();
                if ((this.getNamespaceURI().equals(string3) || "http://www.w3.org/2000/svg".equals(string3)) && (string2 = (element2 = (Element)node).getLocalName()).equals("flowDiv")) {
                    super.addGlyphPositionAttributes(attributedString, element2, bridgeContext);
                    return;
                }
            }
            node = node.getNextSibling();
        }
    }

    protected void addChildGlyphPositionAttributes(AttributedString attributedString, Element element, BridgeContext bridgeContext) {
        Node node = element.getFirstChild();
        while (node != null) {
            if (node.getNodeType() == 1) {
                String string;
                String string2 = node.getNamespaceURI();
                if ((this.getNamespaceURI().equals(string2) || "http://www.w3.org/2000/svg".equals(string2)) && ((string = node.getLocalName()).equals("flowPara") || string.equals("flowRegionBreak") || string.equals("flowLine") || string.equals("flowSpan") || string.equals("a") || string.equals("tref"))) {
                    this.addGlyphPositionAttributes(attributedString, (Element)node, bridgeContext);
                }
            }
            node = node.getNextSibling();
        }
    }

    protected void addPaintAttributes(AttributedString attributedString, Element element, TextNode textNode, SVGTextElementBridge.TextDecoration textDecoration, BridgeContext bridgeContext) {
        if (element.getNodeType() != 1) {
            return;
        }
        String string = element.getNamespaceURI();
        if (!string.equals(this.getNamespaceURI()) && !string.equals("http://www.w3.org/2000/svg")) {
            return;
        }
        if (element.getLocalName() != "flowText") {
            super.addPaintAttributes(attributedString, element, textNode, textDecoration, bridgeContext);
            return;
        }
        Node node = element.getFirstChild();
        while (node != null) {
            Element element2;
            String string2;
            if (node.getNodeType() == 1 && this.getNamespaceURI().equals(node.getNamespaceURI()) && (string2 = (element2 = (Element)node).getLocalName()).equals("flowDiv")) {
                super.addPaintAttributes(attributedString, element2, textNode, textDecoration, bridgeContext);
                return;
            }
            node = node.getNextSibling();
        }
    }

    protected void addChildPaintAttributes(AttributedString attributedString, Element element, TextNode textNode, SVGTextElementBridge.TextDecoration textDecoration, BridgeContext bridgeContext) {
        Node node = element.getFirstChild();
        while (node != null) {
            if (node.getNodeType() == 1) {
                String string;
                String string2 = node.getNamespaceURI();
                if ((this.getNamespaceURI().equals(string2) || "http://www.w3.org/2000/svg".equals(string2)) && ((string = node.getLocalName()).equals("flowPara") || string.equals("flowRegionBreak") || string.equals("flowLine") || string.equals("flowSpan") || string.equals("a") || string.equals("tref"))) {
                    Element element2 = (Element)node;
                    SVGTextElementBridge.TextDecoration textDecoration2 = this.getTextDecoration(element2, textNode, textDecoration, bridgeContext);
                    this.addPaintAttributes(attributedString, element2, textNode, textDecoration2, bridgeContext);
                }
            }
            node = node.getNextSibling();
        }
    }

    protected AttributedString getFlowDiv(BridgeContext bridgeContext, Element element) {
        Node node = element.getFirstChild();
        while (node != null) {
            if (node.getNodeType() == 1 && node.getNamespaceURI() == this.getNamespaceURI()) {
                Element element2 = (Element)node;
                String string = node.getLocalName();
                if (string.equals("flowDiv")) {
                    return this.gatherFlowPara(bridgeContext, element2);
                }
            }
            node = node.getNextSibling();
        }
        return null;
    }

    protected AttributedString gatherFlowPara(BridgeContext bridgeContext, Element element) {
        int n;
        Object object;
        SVGTextElementBridge.AttributedStringBuffer attributedStringBuffer = new SVGTextElementBridge.AttributedStringBuffer();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        ArrayList arrayList3 = new ArrayList();
        Node node = element.getFirstChild();
        while (node != null) {
            if (node.getNodeType() == 1 && node.getNamespaceURI() == this.getNamespaceURI()) {
                object = (Element)node;
                String string = object.getLocalName();
                if (string.equals("flowPara")) {
                    this.fillAttributedStringBuffer(bridgeContext, (Element)object, true, attributedStringBuffer, arrayList3);
                    arrayList2.add(object);
                    arrayList.add(new Integer(attributedStringBuffer.length()));
                } else if (string.equals("flowRegionBreak")) {
                    this.fillAttributedStringBuffer(bridgeContext, (Element)object, true, attributedStringBuffer, arrayList3);
                    arrayList2.add(object);
                    arrayList.add(new Integer(attributedStringBuffer.length()));
                }
            }
            node = node.getNextSibling();
        }
        object = attributedStringBuffer.toAttributedString();
        int n2 = 0;
        boolean bl = false;
        Iterator iterator = arrayList3.iterator();
        while (iterator.hasNext()) {
            n = (Integer)iterator.next();
            if (n == n2) continue;
            ((AttributedString)object).addAttribute(FLOW_LINE_BREAK, new Object(), n2, n);
            n2 = n;
        }
        n = 0;
        LinkedList<MarginInfo> linkedList = null;
        int n3 = 0;
        while (n3 < arrayList2.size()) {
            Element element2 = (Element)arrayList2.get(n3);
            int n4 = (Integer)arrayList.get(n3);
            if (n == n4) {
                if (linkedList == null) {
                    linkedList = new LinkedList<MarginInfo>();
                }
                linkedList.add(this.makeMarginInfo(element2));
            } else {
                ((AttributedString)object).addAttribute(FLOW_PARAGRAPH, this.makeMarginInfo(element2), n, n4);
                if (linkedList != null) {
                    ((AttributedString)object).addAttribute(FLOW_EMPTY_PARAGRAPH, linkedList, n, n4);
                    linkedList = null;
                }
            }
            ++n3;
            n = n4;
        }
        return object;
    }

    protected List getRegions(BridgeContext bridgeContext, Element element) {
        Node node = element.getFirstChild();
        while (node != null) {
            if (node.getNodeType() == 1 && node.getNamespaceURI() == this.getNamespaceURI()) {
                Element element2 = (Element)node;
                String string = node.getLocalName();
                if (string.equals("flowRegion")) {
                    return this.gatherRects(bridgeContext, element2);
                }
            }
            node = node.getNextSibling();
        }
        return null;
    }

    protected List gatherRects(BridgeContext bridgeContext, Element element) {
        LinkedList<Rectangle2D> linkedList = new LinkedList<Rectangle2D>();
        Node node = element.getFirstChild();
        while (node != null) {
            if (node.getNodeType() == 1 && node.getNamespaceURI() == this.getNamespaceURI()) {
                UnitProcessor.Context context;
                Rectangle2D rectangle2D;
                Element element2 = (Element)node;
                String string = node.getLocalName();
                if (string.equals("region") && (rectangle2D = this.buildRect(context = UnitProcessor.createContext(bridgeContext, element2), element2)) != null) {
                    linkedList.add(rectangle2D);
                }
            }
            node = node.getNextSibling();
        }
        return linkedList;
    }

    protected Rectangle2D buildRect(UnitProcessor.Context context, Element element) {
        String string = element.getAttributeNS(null, "x");
        float f = 0.0f;
        if (string.length() != 0) {
            f = UnitProcessor.svgHorizontalCoordinateToUserSpace(string, "x", context);
        }
        string = element.getAttributeNS(null, "y");
        float f2 = 0.0f;
        if (string.length() != 0) {
            f2 = UnitProcessor.svgVerticalCoordinateToUserSpace(string, "y", context);
        }
        if ((string = element.getAttributeNS(null, "width")).length() == 0) {
            throw new BridgeException(element, "attribute.missing", new Object[]{"width", string});
        }
        float f3 = UnitProcessor.svgHorizontalLengthToUserSpace(string, "width", context);
        if (f3 == 0.0f) {
            return null;
        }
        string = element.getAttributeNS(null, "height");
        if (string.length() == 0) {
            throw new BridgeException(element, "attribute.missing", new Object[]{"height", string});
        }
        float f4 = UnitProcessor.svgVerticalLengthToUserSpace(string, "height", context);
        if (f4 == 0.0f) {
            return null;
        }
        return new Rectangle2D.Float(f, f2, f3, f4);
    }

    protected void fillAttributedStringBuffer(BridgeContext bridgeContext, Element element, boolean bl, SVGTextElementBridge.AttributedStringBuffer attributedStringBuffer, List list) {
        if (!SVGUtilities.matchUserAgent(element, bridgeContext.getUserAgent())) {
            return;
        }
        String string = XMLSupport.getXMLSpace(element);
        boolean bl2 = string.equals("preserve");
        boolean bl3 = true;
        boolean bl4 = !bl2;
        boolean bl5 = !bl2;
        Element element2 = element;
        Map map = null;
        Node node = element.getFirstChild();
        while (node != null) {
            boolean bl6 = node.getNextSibling() == null;
            int n = attributedStringBuffer.getLastChar();
            bl4 = !bl2 && bl3 && (bl || n == 32 || n == -1);
            switch (node.getNodeType()) {
                case 1: {
                    if (node.getNamespaceURI() != this.getNamespaceURI()) break;
                    element2 = (Element)node;
                    String string2 = node.getLocalName();
                    if (string2.equals("flowLine")) {
                        this.fillAttributedStringBuffer(bridgeContext, element2, false, attributedStringBuffer, list);
                        list.add(new Integer(attributedStringBuffer.length()));
                        break;
                    }
                    if (string2.equals("flowSpan") || string2.equals("altGlyph") || string2.equals("a")) {
                        this.fillAttributedStringBuffer(bridgeContext, element2, false, attributedStringBuffer, list);
                        break;
                    }
                    if (!string2.equals("tref")) break;
                    String string3 = XLinkSupport.getXLinkHref((Element)node);
                    Element element3 = bridgeContext.getReferencedElement((Element)node, string3);
                    string = TextUtilities.getElementContent(element3);
                    if ((string = this.normalizeString(string, bl2, bl4, bl6 && bl)) == null) break;
                    boolean bl7 = bl5 = !bl2 && string.charAt(0) == ' ';
                    if (bl5 && !attributedStringBuffer.isEmpty()) {
                        attributedStringBuffer.stripLast();
                    }
                    Map map2 = this.getAttributeMap(bridgeContext, element2, null);
                    attributedStringBuffer.append(string, map2);
                    break;
                }
                case 3: 
                case 4: {
                    string = node.getNodeValue();
                    string = this.normalizeString(string, bl2, bl4, bl6 && bl);
                    if (string == null) break;
                    boolean bl8 = bl5 = !bl2 && string.charAt(0) == ' ';
                    if (bl5 && !attributedStringBuffer.isEmpty()) {
                        attributedStringBuffer.stripLast();
                    }
                    if (map == null) {
                        map = this.getAttributeMap(bridgeContext, element, null);
                    }
                    attributedStringBuffer.append(string, map);
                }
            }
            bl3 = false;
            node = node.getNextSibling();
        }
    }

    protected void checkMap(Map map) {
        if (map.containsKey(TEXTPATH)) {
            return;
        }
        if (map.containsKey(ANCHOR_TYPE)) {
            return;
        }
        if (map.containsKey(LETTER_SPACING)) {
            return;
        }
        if (map.containsKey(WORD_SPACING)) {
            return;
        }
        if (map.containsKey(KERNING)) {
            return;
        }
    }

    public MarginInfo makeMarginInfo(Element element) {
        float f;
        float f2;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        String string = element.getAttributeNS(null, "margin");
        try {
            if (string.length() != 0) {
                f5 = f6 = (f2 = Float.parseFloat(string));
                f4 = f6;
                f3 = f6;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        string = element.getAttributeNS(null, "top-margin");
        try {
            if (string.length() != 0) {
                f3 = f2 = Float.parseFloat(string);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        string = element.getAttributeNS(null, "right-margin");
        try {
            if (string.length() != 0) {
                float f7;
                f4 = f7 = Float.parseFloat(string);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        string = element.getAttributeNS(null, "bottom-margin");
        try {
            if (string.length() != 0) {
                float f8;
                f5 = f8 = Float.parseFloat(string);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        string = element.getAttributeNS(null, "left-margin");
        try {
            if (string.length() != 0) {
                float f9;
                f6 = f9 = Float.parseFloat(string);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        float f10 = f6;
        float f11 = f4;
        string = element.getAttributeNS(null, "first-line-left-margin");
        try {
            if (string.length() != 0) {
                f10 = f = Float.parseFloat(string);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        string = element.getAttributeNS(null, "first-line-right-margin");
        try {
            if (string.length() != 0) {
                f11 = f = Float.parseFloat(string);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        int n = 0;
        string = element.getAttributeNS(null, "justification");
        try {
            if (string.length() != 0) {
                if (string.equals("start")) {
                    n = 0;
                } else if (string.equals("middle")) {
                    n = 1;
                } else if (string.equals("end")) {
                    n = 2;
                } else if (string.equals("full")) {
                    n = 3;
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        String string2 = element.getLocalName();
        boolean bl = string2.equals("flowRegionBreak");
        return new MarginInfo(f3, f4, f5, f6, f10, f11, n, bl);
    }

    public static class LineBreakInfo {
        int breakIdx;
        float lineAdvAdj;
        boolean relative;

        public LineBreakInfo(int n, float f, boolean bl) {
            this.breakIdx = n;
            this.lineAdvAdj = f;
            this.relative = bl;
        }

        public int getBreakIdx() {
            return this.breakIdx;
        }

        public boolean isRelative() {
            return this.relative;
        }

        public float getLineAdvAdj() {
            return this.lineAdvAdj;
        }
    }
}

