/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.gvt.font;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphJustificationInfo;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.AttributedCharacterIterator;
import java.util.Iterator;
import java.util.List;
import org.apache.batik.gvt.font.GVTFont;
import org.apache.batik.gvt.font.GVTGlyphMetrics;
import org.apache.batik.gvt.font.GVTGlyphVector;
import org.apache.batik.gvt.text.AttributedCharacterSpanIterator;

public class MultiGlyphVector
implements GVTGlyphVector {
    GVTGlyphVector[] gvs;
    int[] nGlyphs;
    int[] off;
    int nGlyph;

    public MultiGlyphVector(List list) {
        this.gvs = new GVTGlyphVector[list.size()];
        this.nGlyphs = new int[list.size()];
        this.off = new int[list.size()];
        Iterator iterator = list.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            GVTGlyphVector gVTGlyphVector;
            this.off[n] = this.nGlyph;
            this.gvs[n] = gVTGlyphVector = (GVTGlyphVector)iterator.next();
            this.nGlyphs[n] = gVTGlyphVector.getNumGlyphs();
            this.nGlyph += this.nGlyphs[n];
            ++n;
        }
        int n2 = n - 1;
        this.nGlyphs[n2] = this.nGlyphs[n2] + 1;
    }

    public int getNumGlyphs() {
        return this.nGlyph;
    }

    int getGVIdx(int n) {
        if (n > this.nGlyph) {
            return -1;
        }
        if (n == this.nGlyph) {
            return this.gvs.length - 1;
        }
        int n2 = 0;
        while (n2 < this.nGlyphs.length) {
            if (n - this.off[n2] < this.nGlyphs[n2]) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public GVTFont getFont() {
        throw new IllegalArgumentException("Can't be correctly Implemented");
    }

    public FontRenderContext getFontRenderContext() {
        return this.gvs[0].getFontRenderContext();
    }

    public int getGlyphCode(int n) {
        int n2 = this.getGVIdx(n);
        return this.gvs[n2].getGlyphCode(n - this.off[n2]);
    }

    public GlyphJustificationInfo getGlyphJustificationInfo(int n) {
        int n2 = this.getGVIdx(n);
        return this.gvs[n2].getGlyphJustificationInfo(n - this.off[n2]);
    }

    public Shape getGlyphLogicalBounds(int n) {
        int n2 = this.getGVIdx(n);
        return this.gvs[n2].getGlyphLogicalBounds(n - this.off[n2]);
    }

    public GVTGlyphMetrics getGlyphMetrics(int n) {
        int n2 = this.getGVIdx(n);
        return this.gvs[n2].getGlyphMetrics(n - this.off[n2]);
    }

    public Shape getGlyphOutline(int n) {
        int n2 = this.getGVIdx(n);
        return this.gvs[n2].getGlyphOutline(n - this.off[n2]);
    }

    public Point2D getGlyphPosition(int n) {
        int n2 = this.getGVIdx(n);
        return this.gvs[n2].getGlyphPosition(n - this.off[n2]);
    }

    public AffineTransform getGlyphTransform(int n) {
        int n2 = this.getGVIdx(n);
        return this.gvs[n2].getGlyphTransform(n - this.off[n2]);
    }

    public Shape getGlyphVisualBounds(int n) {
        int n2 = this.getGVIdx(n);
        return this.gvs[n2].getGlyphVisualBounds(n - this.off[n2]);
    }

    public void setGlyphPosition(int n, Point2D point2D) {
        int n2 = this.getGVIdx(n);
        this.gvs[n2].setGlyphPosition(n - this.off[n2], point2D);
    }

    public void setGlyphTransform(int n, AffineTransform affineTransform) {
        int n2 = this.getGVIdx(n);
        this.gvs[n2].setGlyphTransform(n - this.off[n2], affineTransform);
    }

    public void setGlyphVisible(int n, boolean bl) {
        int n2 = this.getGVIdx(n);
        this.gvs[n2].setGlyphVisible(n - this.off[n2], bl);
    }

    public boolean isGlyphVisible(int n) {
        int n2 = this.getGVIdx(n);
        return this.gvs[n2].isGlyphVisible(n - this.off[n2]);
    }

    public int[] getGlyphCodes(int n, int n2, int[] nArray) {
        int[] nArray2 = nArray;
        if (nArray2 == null) {
            nArray2 = new int[n2];
        }
        int[] nArray3 = null;
        int n3 = this.getGVIdx(n);
        int n4 = n - this.off[n3];
        int n5 = 0;
        while (n2 != 0) {
            int n6 = n2;
            if (n4 + n6 > this.nGlyphs[n3]) {
                n6 = this.nGlyphs[n3] - n4;
            }
            GVTGlyphVector gVTGlyphVector = this.gvs[n3];
            if (n5 == 0) {
                gVTGlyphVector.getGlyphCodes(n4, n6, nArray2);
            } else {
                if (nArray3 == null || nArray3.length < n6) {
                    nArray3 = new int[n6];
                }
                gVTGlyphVector.getGlyphCodes(n4, n6, nArray3);
                int n7 = 0;
                while (n7 < n6) {
                    nArray2[n5 + n7] = nArray3[n7];
                    ++n7;
                }
            }
            n4 = 0;
            ++n3;
            n2 -= n6;
            n5 += n6;
        }
        return nArray2;
    }

    public float[] getGlyphPositions(int n, int n2, float[] fArray) {
        float[] fArray2 = fArray;
        if (fArray2 == null) {
            fArray2 = new float[n2 * 2];
        }
        float[] fArray3 = null;
        int n3 = this.getGVIdx(n);
        int n4 = n - this.off[n3];
        int n5 = 0;
        while (n2 != 0) {
            int n6 = n2;
            if (n4 + n6 > this.nGlyphs[n3]) {
                n6 = this.nGlyphs[n3] - n4;
            }
            GVTGlyphVector gVTGlyphVector = this.gvs[n3];
            if (n5 == 0) {
                gVTGlyphVector.getGlyphPositions(n4, n6, fArray2);
            } else {
                if (fArray3 == null || fArray3.length < n6 * 2) {
                    fArray3 = new float[n6 * 2];
                }
                gVTGlyphVector.getGlyphPositions(n4, n6, fArray3);
                int n7 = 0;
                while (n7 < n6 * 2) {
                    fArray2[n5 + n7] = fArray3[n7];
                    ++n7;
                }
            }
            n4 = 0;
            ++n3;
            n2 -= n6;
            n5 += n6 * 2;
        }
        return fArray2;
    }

    public Rectangle2D getLogicalBounds() {
        Rectangle2D rectangle2D = null;
        int n = 0;
        while (n < this.gvs.length) {
            Rectangle2D rectangle2D2 = this.gvs[n].getLogicalBounds();
            rectangle2D = rectangle2D == null ? rectangle2D2 : rectangle2D.createUnion(rectangle2D2);
            ++n;
        }
        return rectangle2D;
    }

    public Shape getOutline() {
        Path2D path2D = null;
        int n = 0;
        while (n < this.gvs.length) {
            Shape shape = this.gvs[n].getOutline();
            if (path2D == null) {
                path2D = new GeneralPath(shape);
            } else {
                path2D.append(shape, false);
            }
            ++n;
        }
        return path2D;
    }

    public Shape getOutline(float f, float f2) {
        Shape shape = this.getOutline();
        AffineTransform affineTransform = AffineTransform.getTranslateInstance(f, f2);
        shape = affineTransform.createTransformedShape(shape);
        return shape;
    }

    public Rectangle2D getVisualBounds() {
        Rectangle2D rectangle2D = null;
        int n = 0;
        while (n < this.gvs.length) {
            Rectangle2D rectangle2D2 = this.gvs[n].getVisualBounds();
            rectangle2D = rectangle2D == null ? rectangle2D2 : rectangle2D.createUnion(rectangle2D2);
            ++n;
        }
        return rectangle2D;
    }

    public void performDefaultLayout() {
        int n = 0;
        while (n < this.gvs.length) {
            this.gvs[n].performDefaultLayout();
            ++n;
        }
    }

    public int getCharacterCount(int n, int n2) {
        int n3 = this.getGVIdx(n);
        int n4 = this.getGVIdx(n2);
        int n5 = 0;
        int n6 = n3;
        while (n6 <= n4) {
            int n7 = n - this.off[n6];
            int n8 = n2 - this.off[n6];
            if (n8 >= this.nGlyphs[n6]) {
                n8 = this.nGlyphs[n6] - 1;
            }
            n5 += this.gvs[n6].getCharacterCount(n7, n8);
            n += n8 - n7 + 1;
            ++n6;
        }
        return n5;
    }

    public void draw(Graphics2D graphics2D, AttributedCharacterIterator attributedCharacterIterator) {
        int n = attributedCharacterIterator.getBeginIndex();
        int n2 = 0;
        while (n2 < this.gvs.length) {
            GVTGlyphVector gVTGlyphVector = this.gvs[n2];
            int n3 = gVTGlyphVector.getCharacterCount(0, gVTGlyphVector.getNumGlyphs()) + 1;
            gVTGlyphVector.draw(graphics2D, new AttributedCharacterSpanIterator(attributedCharacterIterator, n, n3));
            n = n3;
            ++n2;
        }
    }
}

