/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.script.rhino;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Vector;
import org.apache.batik.script.Interpreter;
import org.apache.batik.script.InterpreterException;
import org.apache.batik.script.Window;
import org.apache.batik.script.rhino.BatikSecuritySupport;
import org.apache.batik.script.rhino.EventTargetWrapHandler;
import org.apache.batik.script.rhino.EventTargetWrapper;
import org.apache.batik.script.rhino.RhinoClassLoader;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.ImporterTopLevel;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeJavaPackage;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.SecuritySupport;
import org.mozilla.javascript.WrapHandler;
import org.mozilla.javascript.WrappedException;
import org.w3c.dom.events.EventTarget;

public class RhinoInterpreter
implements Interpreter {
    private static String[] TO_BE_IMPORTED = new String[]{"java.lang", "org.w3c.dom", "org.w3c.dom.css", "org.w3c.dom.events", "org.w3c.dom.smil", "org.w3c.dom.stylesheets", "org.w3c.dom.svg", "org.w3c.dom.views"};
    private static final int MAX_CACHED_SCRIPTS = 32;
    private ScriptableObject globalObject = null;
    private LinkedList compiledScripts = new LinkedList();
    private WrapHandler wrapHandler = new EventTargetWrapHandler(this);
    private SecuritySupport securitySupport = new BatikSecuritySupport();
    protected RhinoClassLoader rhinoClassLoader;
    protected Context defaultContext;
    protected Vector contexts;
    static /* synthetic */ Class class$org$apache$batik$script$rhino$WindowWrapper;

    public RhinoInterpreter(URL uRL) {
        this.rhinoClassLoader = new RhinoClassLoader(uRL);
        Context.setCachingEnabled((boolean)false);
        Context.setCachingEnabled((boolean)true);
        this.defaultContext = new Context(this.securitySupport);
        Context context = this.enterContext();
        try {
            ImporterTopLevel importerTopLevel = new ImporterTopLevel(context);
            this.globalObject = importerTopLevel;
            Object[] objectArray = new NativeJavaPackage[TO_BE_IMPORTED.length];
            int n = 0;
            while (n < TO_BE_IMPORTED.length) {
                objectArray[n] = new NativeJavaPackage(TO_BE_IMPORTED[n]);
                ++n;
            }
            ImporterTopLevel.importPackage((Context)context, (Scriptable)this.globalObject, (Object[])objectArray, null);
            context.setWrapHandler(this.wrapHandler);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            Context.exit();
            throw throwable;
        }
        Context.exit();
    }

    public Context enterContext() {
        Context context = Context.enter((Context)this.defaultContext);
        if (context != this.defaultContext && !this.contexts.contains(context)) {
            context.setSecuritySupport(this.securitySupport);
            this.contexts.add(context);
        }
        return context;
    }

    protected ScriptableObject getGlobalObject() {
        return this.globalObject;
    }

    public Object evaluate(Reader reader) throws InterpreterException, IOException {
        Object object = null;
        Context context = this.enterContext();
        context.setWrapHandler(this.wrapHandler);
        try {
            try {
                object = context.evaluateReader((Scriptable)this.globalObject, reader, "<SVG>", 1, (Object)this.rhinoClassLoader);
            }
            catch (JavaScriptException javaScriptException) {
                if (javaScriptException.getValue() instanceof Exception) {
                    Exception exception = (Exception)javaScriptException.getValue();
                    throw new InterpreterException(exception, exception.getMessage(), -1, -1);
                }
                throw new InterpreterException((Exception)((Object)javaScriptException), javaScriptException.getMessage(), -1, -1);
            }
            catch (WrappedException wrappedException) {
                throw new InterpreterException((Exception)wrappedException.getWrappedException(), wrappedException.getWrappedException().getMessage(), -1, -1);
            }
            catch (RuntimeException runtimeException) {
                throw new InterpreterException(runtimeException, runtimeException.getMessage(), -1, -1);
            }
            Object var8_4 = null;
        }
        catch (Throwable throwable) {
            Object var8_5 = null;
            Context.exit();
            throw throwable;
        }
        Context.exit();
        return object;
    }

    public Object evaluate(String string) throws InterpreterException {
        Context context = this.enterContext();
        context.setWrapHandler(this.wrapHandler);
        Script script = null;
        Entry entry = null;
        Iterator iterator = this.compiledScripts.iterator();
        while (iterator.hasNext()) {
            entry = (Entry)iterator.next();
            if (!entry.str.equals(string)) continue;
            script = entry.script;
            iterator.remove();
            break;
        }
        if (script == null) {
            try {
                script = context.compileReader((Scriptable)this.globalObject, (Reader)new StringReader(string), "<SVG>", 1, (Object)this.rhinoClassLoader);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (this.compiledScripts.size() + 1 > 32) {
                this.compiledScripts.removeFirst();
            }
            this.compiledScripts.addLast(new Entry(string, script));
        } else {
            this.compiledScripts.addLast(entry);
        }
        Object object = null;
        try {
            try {
                object = script.exec(context, (Scriptable)this.globalObject);
            }
            catch (JavaScriptException javaScriptException) {
                if (javaScriptException.getValue() instanceof Exception) {
                    Exception exception = (Exception)javaScriptException.getValue();
                    throw new InterpreterException(exception, exception.getMessage(), -1, -1);
                }
                throw new InterpreterException((Exception)((Object)javaScriptException), javaScriptException.getMessage(), -1, -1);
            }
            catch (WrappedException wrappedException) {
                throw new InterpreterException((Exception)wrappedException.getWrappedException(), wrappedException.getWrappedException().getMessage(), -1, -1);
            }
            catch (RuntimeException runtimeException) {
                throw new InterpreterException(runtimeException, runtimeException.getMessage(), -1, -1);
            }
            Object var11_8 = null;
        }
        catch (Throwable throwable) {
            Object var11_9 = null;
            Context.exit();
            throw throwable;
        }
        Context.exit();
        return object;
    }

    public void dispose() {
    }

    public void bindObject(String string, Object object) {
        Context context = this.enterContext();
        context.setWrapHandler(this.wrapHandler);
        try {
            Scriptable scriptable = Context.toObject((Object)object, (Scriptable)this.globalObject);
            this.globalObject.put(string, (Scriptable)this.globalObject, (Object)scriptable);
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            Context.exit();
            throw throwable;
        }
        Context.exit();
        if (string.equals("window") && object instanceof Window) {
            try {
                ScriptableObject.defineClass((Scriptable)this.globalObject, (Class)(class$org$apache$batik$script$rhino$WindowWrapper == null ? (class$org$apache$batik$script$rhino$WindowWrapper = RhinoInterpreter.class$("org.apache.batik.script.rhino.WindowWrapper")) : class$org$apache$batik$script$rhino$WindowWrapper));
                this.evaluate(new StringReader("window = new Window(window)"));
                this.globalObject = (ScriptableObject)this.globalObject.get("window", (Scriptable)this.globalObject);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    void callHandler(Function function, Object object) throws JavaScriptException {
        Context context = this.enterContext();
        context.setWrapHandler(this.wrapHandler);
        try {
            object = Context.toObject((Object)object, (Scriptable)this.globalObject);
            Object[] objectArray = new Object[]{object};
            function.call(context, (Scriptable)this.globalObject, (Scriptable)this.globalObject, objectArray);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            Context.exit();
            throw throwable;
        }
        Context.exit();
    }

    void callHandler(Function function, Object[] objectArray) throws JavaScriptException {
        Context context = this.enterContext();
        context.setWrapHandler(this.wrapHandler);
        try {
            function.call(context, (Scriptable)this.globalObject, (Scriptable)this.globalObject, objectArray);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            Context.exit();
            throw throwable;
        }
        Context.exit();
    }

    void callHandler(Function function, ArgumentsBuilder argumentsBuilder) throws JavaScriptException {
        Context context = this.enterContext();
        context.setWrapHandler(this.wrapHandler);
        try {
            function.call(context, (Scriptable)this.globalObject, (Scriptable)this.globalObject, argumentsBuilder.buildArguments());
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            Context.exit();
            throw throwable;
        }
        Context.exit();
    }

    Scriptable buildEventTargetWrapper(EventTarget eventTarget) {
        return new EventTargetWrapper((Scriptable)this.globalObject, eventTarget, this);
    }

    public void setOut(Writer writer) {
    }

    public Locale getLocale() {
        return null;
    }

    public void setLocale(Locale locale) {
    }

    public String formatMessage(String string, Object[] objectArray) {
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static interface ArgumentsBuilder {
        public Object[] buildArguments();
    }

    private static class Entry {
        String str;
        Script script;

        Entry(String string, Script script) {
            this.str = string;
            this.script = script;
        }
    }
}

