/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen;

import java.awt.BasicStroke;
import org.apache.batik.ext.awt.g2d.GraphicContext;
import org.apache.batik.svggen.AbstractSVGConverter;
import org.apache.batik.svggen.SVGDescriptor;
import org.apache.batik.svggen.SVGStrokeDescriptor;

public class SVGBasicStroke
extends AbstractSVGConverter {
    public SVGDescriptor toSVG(GraphicContext graphicContext) {
        if (graphicContext.getStroke() instanceof BasicStroke) {
            return SVGBasicStroke.toSVG((BasicStroke)graphicContext.getStroke());
        }
        return null;
    }

    public static SVGStrokeDescriptor toSVG(BasicStroke basicStroke) {
        String string = AbstractSVGConverter.doubleString(basicStroke.getLineWidth());
        String string2 = SVGBasicStroke.endCapToSVG(basicStroke.getEndCap());
        String string3 = SVGBasicStroke.joinToSVG(basicStroke.getLineJoin());
        String string4 = AbstractSVGConverter.doubleString(basicStroke.getMiterLimit());
        float[] fArray = basicStroke.getDashArray();
        String string5 = null;
        string5 = fArray != null ? SVGBasicStroke.dashArrayToSVG(fArray) : "none";
        String string6 = AbstractSVGConverter.doubleString(basicStroke.getDashPhase());
        return new SVGStrokeDescriptor(string, string2, string3, string4, string5, string6);
    }

    private static String dashArrayToSVG(float[] fArray) {
        StringBuffer stringBuffer = new StringBuffer();
        if (fArray.length > 0) {
            stringBuffer.append(AbstractSVGConverter.doubleString(fArray[0]));
        }
        int n = 1;
        while (n < fArray.length) {
            stringBuffer.append(",");
            stringBuffer.append(AbstractSVGConverter.doubleString(fArray[n]));
            ++n;
        }
        return stringBuffer.toString();
    }

    private static String joinToSVG(int n) {
        switch (n) {
            case 2: {
                return "bevel";
            }
            case 1: {
                return "round";
            }
        }
        return "miter";
    }

    private static String endCapToSVG(int n) {
        switch (n) {
            case 0: {
                return "butt";
            }
            case 1: {
                return "round";
            }
        }
        return "square";
    }
}

