/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.util;

import java.net.URL;
import java.security.Policy;
import org.apache.batik.util.BatikSecurityManager;
import org.apache.batik.util.Messages;

public class ApplicationSecurityEnforcer {
    public static final String EXCEPTION_ALIEN_SECURITY_MANAGER = "ApplicationSecurityEnforcer.message.security.exception.alien.security.manager";
    public static final String EXCEPTION_NO_POLICY_FILE = "ApplicationSecurityEnforcer.message.null.pointer.exception.no.policy.file";
    public static final String PROPERTY_JAVA_SECURITY_POLICY = "java.security.policy";
    public static final String JAR_PROTOCOL = "jar:";
    public static final String JAR_URL_FILE_SEPARATOR = "!/";
    public static final String PROPERTY_APP_DEV_BASE = "app.dev.base";
    public static final String PROPERTY_APP_JAR_BASE = "app.jar.base";
    public static final String APP_MAIN_CLASS_DIR = "classes/";
    protected Class appMainClass;
    protected String securityPolicy;
    protected String appJarFile;
    protected String appMainClassRelativeURL;
    protected BatikSecurityManager lastSecurityManagerInstalled;

    public ApplicationSecurityEnforcer(Class clazz, String string, String string2) {
        this.appMainClass = clazz;
        this.securityPolicy = string;
        this.appJarFile = string2;
        this.appMainClassRelativeURL = clazz.getName().replace('.', '/') + ".class";
    }

    public void enforceSecurity(boolean bl) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null && securityManager != this.lastSecurityManagerInstalled) {
            throw new SecurityException(Messages.getString(EXCEPTION_ALIEN_SECURITY_MANAGER));
        }
        if (bl) {
            if (securityManager == null) {
                this.installSecurityManager();
            }
        } else if (securityManager != null) {
            System.setSecurityManager(null);
            this.lastSecurityManagerInstalled = null;
        }
    }

    public void installSecurityManager() {
        Policy policy = Policy.getPolicy();
        BatikSecurityManager batikSecurityManager = new BatikSecurityManager();
        ClassLoader classLoader = this.appMainClass.getClassLoader();
        URL uRL = classLoader.getResource(this.securityPolicy);
        if (uRL == null) {
            throw new NullPointerException(Messages.formatMessage(EXCEPTION_NO_POLICY_FILE, new Object[]{this.securityPolicy}));
        }
        System.setProperty(PROPERTY_JAVA_SECURITY_POLICY, uRL.toString());
        uRL = classLoader.getResource(this.appMainClassRelativeURL);
        if (uRL == null) {
            throw new Error(this.appMainClassRelativeURL);
        }
        String string = uRL.toString();
        if (string.startsWith(JAR_PROTOCOL)) {
            this.setJarBase(string);
        } else {
            this.setDevBase(string);
        }
        System.setSecurityManager(batikSecurityManager);
        this.lastSecurityManagerInstalled = batikSecurityManager;
        policy.refresh();
    }

    private void setJarBase(String string) {
        int n = (string = string.substring(JAR_PROTOCOL.length())).indexOf(this.appJarFile + JAR_URL_FILE_SEPARATOR + this.appMainClassRelativeURL);
        if (n == -1) {
            throw new Error();
        }
        String string2 = string.substring(0, n);
        System.setProperty(PROPERTY_APP_JAR_BASE, string2);
    }

    private void setDevBase(String string) {
        int n = string.indexOf(APP_MAIN_CLASS_DIR + this.appMainClassRelativeURL);
        if (n == -1) {
            throw new Error();
        }
        String string2 = string.substring(0, n);
        System.setProperty(PROPERTY_APP_DEV_BASE, string2);
    }
}

