/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.apps;

import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Method;
import org.apache.fop.apps.CommandLineOptions;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.InputHandler;
import org.apache.fop.configuration.Configuration;
import org.apache.fop.configuration.ConfigurationReader;
import org.apache.fop.messaging.MessageHandler;
import org.xml.sax.InputSource;

public class Options {
    boolean errorDump = false;
    static /* synthetic */ Class class$java$lang$Thread;
    static /* synthetic */ Class class$org$apache$fop$configuration$ConfigurationReader;

    public Options() throws FOPException {
        this.loadStandardConfiguration();
        this.initOptions();
    }

    public Options(File file) throws FOPException {
        this();
        this.loadUserconfiguration(file);
    }

    public Options(CommandLineOptions commandLineOptions) throws FOPException {
        this();
        this.setCommandLineOptions(commandLineOptions);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    void initOptions() {
        if (Configuration.getBooleanValue("quiet").booleanValue()) {
            MessageHandler.setQuiet(true);
        }
        if (Configuration.getBooleanValue("debugMode").booleanValue()) {
            this.errorDump = true;
        }
        if (Configuration.getBooleanValue("dumpConfiguration").booleanValue()) {
            Configuration.put("dumpConfiguration", "true");
            Configuration.dumpConfiguration();
        }
    }

    public void loadStandardConfiguration() throws FOPException {
        Object object;
        String string = "config.xml";
        InputStream inputStream = null;
        try {
            object = (class$java$lang$Thread != null ? class$java$lang$Thread : (class$java$lang$Thread = Options.class$("java.lang.Thread"))).getMethod("getContextClassLoader", new Class[0]);
            if (object != null) {
                ClassLoader classLoader = (ClassLoader)((Method)object).invoke((Object)Thread.currentThread(), new Object[0]);
                inputStream = classLoader.getResourceAsStream("conf/" + string);
            }
        }
        catch (Exception exception) {}
        if (inputStream == null) {
            inputStream = (class$org$apache$fop$configuration$ConfigurationReader != null ? class$org$apache$fop$configuration$ConfigurationReader : (class$org$apache$fop$configuration$ConfigurationReader = Options.class$("org.apache.fop.configuration.ConfigurationReader"))).getResourceAsStream("/conf/" + string);
        }
        if (inputStream == null) {
            throw new FOPException("can't find default configuration file");
        }
        if (this.errorDump) {
            MessageHandler.logln("reading default configuration file");
        }
        object = new ConfigurationReader(new InputSource(inputStream));
        if (this.errorDump) {
            ((ConfigurationReader)object).setDumpError(true);
        }
        ((ConfigurationReader)object).start();
    }

    public void loadUserconfiguration(File file) {
        block3: {
            if (file == null) break block3;
            MessageHandler.logln("reading user configuration file");
            ConfigurationReader configurationReader = new ConfigurationReader(InputHandler.fileInputSource(file));
            if (this.errorDump) {
                configurationReader.setDumpError(true);
            }
            try {
                configurationReader.start();
            }
            catch (FOPException fOPException) {
                MessageHandler.errorln("Could not load user configuration file " + file + " - error: " + fOPException.getMessage());
                MessageHandler.errorln("using default values");
                if (!this.errorDump) break block3;
                configurationReader.dumpError(fOPException);
            }
        }
    }

    public void loadUserconfiguration(String string) {
        this.loadUserconfiguration(new File(string));
    }

    void setCommandLineOptions(CommandLineOptions commandLineOptions) {
        String string;
        boolean bl;
        File file = commandLineOptions.getUserConfigFile();
        if (file != null) {
            this.loadUserconfiguration(file);
        }
        if (commandLineOptions.isDebugMode() != null) {
            this.errorDump = commandLineOptions.isDebugMode();
            Configuration.put("debugMode", new Boolean(this.errorDump));
        }
        if (bl = commandLineOptions.dumpConfiguration() != null ? commandLineOptions.dumpConfiguration().booleanValue() : Configuration.getBooleanValue("dumpConfiguration").booleanValue()) {
            Configuration.put("dumpConfiguration", "true");
            Configuration.dumpConfiguration();
            System.exit(0);
        }
        if (commandLineOptions.isQuiet() != null) {
            MessageHandler.setQuiet(commandLineOptions.isQuiet());
        }
        if ((string = Configuration.getStringValue("baseDir")) == null) {
            try {
                string = new File(commandLineOptions.getInputFile().getAbsolutePath()).getParentFile().toURL().toExternalForm();
                Configuration.put("baseDir", string);
            }
            catch (Exception exception) {}
        }
        if (this.errorDump) {
            MessageHandler.logln("base directory: " + string);
        }
    }
}

