/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.datatypes;

import java.util.Enumeration;
import java.util.Vector;
import org.apache.fop.datatypes.Length;
import org.apache.fop.fo.expr.Numeric;
import org.apache.fop.fo.expr.PropertyException;

public class MixedLength
extends Length {
    private Vector lengths;

    public MixedLength(Vector vector) {
        this.lengths = vector;
    }

    public Numeric asNumeric() {
        Numeric numeric = null;
        Enumeration enumeration = this.lengths.elements();
        while (enumeration.hasMoreElements()) {
            Length length = (Length)enumeration.nextElement();
            if (numeric == null) {
                numeric = length.asNumeric();
                continue;
            }
            try {
                Numeric numeric2;
                numeric = numeric2 = numeric.add(length.asNumeric());
            }
            catch (PropertyException propertyException) {
                System.err.println("Can't convert MixedLength to Numeric: " + propertyException);
            }
        }
        return numeric;
    }

    protected void computeValue() {
        int n = 0;
        boolean bl = true;
        Enumeration enumeration = this.lengths.elements();
        while (enumeration.hasMoreElements()) {
            Length length = (Length)enumeration.nextElement();
            n += length.mvalue();
            if (length.isComputed()) continue;
            bl = false;
        }
        this.setComputedValue(n, bl);
    }

    public double getTableUnits() {
        double d = 0.0;
        Enumeration enumeration = this.lengths.elements();
        while (enumeration.hasMoreElements()) {
            d += ((Length)enumeration.nextElement()).getTableUnits();
        }
        return d;
    }

    public void resolveTableUnit(double d) {
        Enumeration enumeration = this.lengths.elements();
        while (enumeration.hasMoreElements()) {
            ((Length)enumeration.nextElement()).resolveTableUnit(d);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.lengths.elements();
        while (enumeration.hasMoreElements()) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append('+');
            }
            stringBuffer.append(enumeration.nextElement().toString());
        }
        return stringBuffer.toString();
    }
}

