/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import org.apache.fop.apps.FOPException;
import org.apache.fop.datatypes.ColorType;
import org.apache.fop.datatypes.Length;
import org.apache.fop.datatypes.PercentLength;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.FObjMixed;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.Status;
import org.apache.fop.layout.AccessibilityProps;
import org.apache.fop.layout.Area;
import org.apache.fop.layout.AuralProps;
import org.apache.fop.layout.BackgroundProps;
import org.apache.fop.layout.BlockArea;
import org.apache.fop.layout.BorderAndPadding;
import org.apache.fop.layout.FontState;
import org.apache.fop.layout.LineArea;
import org.apache.fop.layout.MarginInlineProps;
import org.apache.fop.layout.RelativePositionProps;

public class Leader
extends FObjMixed {
    public Leader(FObj fObj, PropertyList propertyList) {
        super(fObj, propertyList);
        this.name = "fo:leader";
    }

    public int addLeader(BlockArea blockArea, FontState fontState, float f, float f2, float f3, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        LineArea lineArea = blockArea.getCurrentLineArea();
        if (lineArea == null) {
            return -1;
        }
        lineArea.changeFont(fontState);
        lineArea.changeColor(f, f2, f3);
        if (n3 <= lineArea.getRemainingWidth()) {
            lineArea.addLeader(n, n2, n3, n4, n6, n5, n7, n8);
        } else {
            lineArea = blockArea.createNextLineArea();
            if (lineArea == null) {
                return -1;
            }
            lineArea.changeFont(fontState);
            lineArea.changeColor(f, f2, f3);
            if (n2 <= lineArea.getContentWidth()) {
                lineArea.addLeader(n, n2, n3, n4, n6, n5, n7, n8);
            } else {
                this.log.error("Leader doesn't fit into line, it will be clipped to fit.");
                lineArea.addLeader(n, lineArea.getRemainingWidth(), n3, n4, n6, n5, n7, n8);
            }
        }
        return 1;
    }

    public Status layout(Area area) throws FOPException {
        if (!(area instanceof BlockArea)) {
            this.log.warn("in this version of Fop fo:leader must be a direct child of fo:block ");
            return new Status(1);
        }
        BlockArea blockArea = (BlockArea)area;
        AccessibilityProps accessibilityProps = this.propMgr.getAccessibilityProps();
        AuralProps auralProps = this.propMgr.getAuralProps();
        BorderAndPadding borderAndPadding = this.propMgr.getBorderAndPadding();
        BackgroundProps backgroundProps = this.propMgr.getBackgroundProps();
        MarginInlineProps marginInlineProps = this.propMgr.getMarginInlineProps();
        RelativePositionProps relativePositionProps = this.propMgr.getRelativePositionProps();
        ColorType colorType = this.properties.get("color").getColorType();
        float f = colorType.red();
        float f2 = colorType.green();
        float f3 = colorType.blue();
        int n = this.properties.get("leader-pattern").getEnum();
        int n2 = this.properties.get("leader-length.optimum").getLength().mvalue();
        int n3 = this.properties.get("leader-length.minimum").getLength().mvalue();
        Length length = this.properties.get("leader-length.maximum").getLength();
        int n4 = length instanceof PercentLength ? (int)(((PercentLength)length).value() * (double)area.getAllocationWidth()) : length.mvalue();
        int n5 = this.properties.get("rule-thickness").getLength().mvalue();
        int n6 = this.properties.get("rule-style").getEnum();
        int n7 = this.properties.get("leader-pattern-width").getLength().mvalue();
        int n8 = this.properties.get("leader-alignment").getEnum();
        String string = this.properties.get("id").getString();
        blockArea.getIDReferences().initializeID(string, blockArea);
        int n9 = this.addLeader(blockArea, this.propMgr.getFontState(area.getFontInfo()), f, f2, f3, n, n3, n2, n4, n5, n6, n7, n8);
        if (n9 == 1) {
            return new Status(1);
        }
        return new Status(3);
    }

    public static FObj.Maker maker() {
        return new Maker();
    }

    public static class Maker
    extends FObj.Maker {
        public FObj make(FObj fObj, PropertyList propertyList) throws FOPException {
            return new Leader(fObj, propertyList);
        }
    }
}

