/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import org.apache.fop.apps.FOPException;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.Status;
import org.apache.fop.fo.flow.ListItemBody;
import org.apache.fop.fo.flow.ListItemLabel;
import org.apache.fop.layout.AccessibilityProps;
import org.apache.fop.layout.Area;
import org.apache.fop.layout.BlockArea;
import org.apache.fop.layout.MarginProps;
import org.apache.fop.layout.RelativePositionProps;

public class ListItem
extends FObj {
    int align;
    int alignLast;
    int breakBefore;
    int breakAfter;
    int lineHeight;
    int startIndent;
    int endIndent;
    int spaceBefore;
    int spaceAfter;
    String id;
    BlockArea blockArea;

    public ListItem(FObj fObj, PropertyList propertyList) {
        super(fObj, propertyList);
        this.name = "fo:list-item";
    }

    public int getContentWidth() {
        if (this.blockArea != null) {
            return this.blockArea.getContentWidth();
        }
        return 0;
    }

    public Status layout(Area area) throws FOPException {
        Object object;
        Object object2;
        Object object3;
        if (this.marker == -1000) {
            AccessibilityProps accessibilityProps = this.propMgr.getAccessibilityProps();
            object3 = this.propMgr.getAuralProps();
            object2 = this.propMgr.getBorderAndPadding();
            object = this.propMgr.getBackgroundProps();
            MarginProps marginProps = this.propMgr.getMarginProps();
            RelativePositionProps relativePositionProps = this.propMgr.getRelativePositionProps();
            this.align = this.properties.get("text-align").getEnum();
            this.alignLast = this.properties.get("text-align-last").getEnum();
            this.lineHeight = this.properties.get("line-height").getLength().mvalue();
            this.spaceBefore = this.properties.get("space-before.optimum").getLength().mvalue();
            this.spaceAfter = this.properties.get("space-after.optimum").getLength().mvalue();
            this.id = this.properties.get("id").getString();
            area.getIDReferences().createID(this.id);
            this.marker = 0;
        }
        if (area instanceof BlockArea) {
            area.end();
        }
        if (this.spaceBefore != 0) {
            area.addDisplaySpace(this.spaceBefore);
        }
        this.blockArea = new BlockArea(this.propMgr.getFontState(area.getFontInfo()), area.getAllocationWidth(), area.spaceLeft(), 0, 0, 0, this.align, this.alignLast, this.lineHeight);
        this.blockArea.setGeneratedBy(this);
        ++this.areasGenerated;
        if (this.areasGenerated == 1) {
            this.blockArea.isFirst(true);
        }
        this.blockArea.addLineagePair(this, this.areasGenerated);
        if (this.hasMarkers()) {
            this.blockArea.addMarkers(this.getMarkers());
        }
        this.blockArea.setPage(area.getPage());
        this.blockArea.start();
        this.blockArea.setAbsoluteHeight(area.getAbsoluteHeight());
        this.blockArea.setIDReferences(area.getIDReferences());
        int n = this.children.size();
        if (n != 2) {
            throw new FOPException("list-item must have exactly two children");
        }
        object3 = (ListItemLabel)this.children.elementAt(0);
        object2 = (ListItemBody)this.children.elementAt(1);
        if (this.marker == 0) {
            area.getIDReferences().configureID(this.id, area);
            object = ((ListItemLabel)object3).layout(this.blockArea);
            if (((Status)object).isIncomplete()) {
                return object;
            }
        }
        if (((Status)(object = ((ListItemBody)object2).layout(this.blockArea))).isIncomplete()) {
            this.blockArea.end();
            area.addChild(this.blockArea);
            area.increaseHeight(this.blockArea.getHeight());
            area.setAbsoluteHeight(this.blockArea.getAbsoluteHeight());
            this.marker = 1;
            return object;
        }
        this.blockArea.end();
        area.addChild(this.blockArea);
        area.increaseHeight(this.blockArea.getHeight());
        area.setAbsoluteHeight(this.blockArea.getAbsoluteHeight());
        if (this.spaceAfter != 0) {
            area.addDisplaySpace(this.spaceAfter);
        }
        if (area instanceof BlockArea) {
            area.start();
        }
        this.blockArea.isLast(true);
        return new Status(1);
    }

    public static FObj.Maker maker() {
        return new Maker();
    }

    public static class Maker
    extends FObj.Maker {
        public FObj make(FObj fObj, PropertyList propertyList) throws FOPException {
            return new ListItem(fObj, propertyList);
        }
    }
}

