/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import org.apache.fop.fo.flow.TableCell;

public class RowSpanMgr {
    private SpanInfo[] spanInfo;
    private boolean ignoreKeeps = false;

    public RowSpanMgr(int n) {
        this.spanInfo = new SpanInfo[n];
    }

    public void addRowSpan(TableCell tableCell, int n, int n2, int n3, int n4) {
        this.spanInfo[n - 1] = new SpanInfo(tableCell, n3, n4);
        int n5 = 0;
        while (n5 < n2 - 1) {
            this.spanInfo[n + n5] = new SpanInfo(null, n3, n4);
            ++n5;
        }
    }

    public void finishRow(int n) {
        int n2 = 0;
        while (n2 < this.spanInfo.length) {
            if (this.spanInfo[n2] != null && this.spanInfo[n2].finishRow(n)) {
                this.spanInfo[n2] = null;
            }
            ++n2;
        }
    }

    public int getRemainingHeight(int n) {
        if (this.spanInfo[n - 1] != null) {
            return this.spanInfo[n - 1].heightRemaining();
        }
        return 0;
    }

    public TableCell getSpanningCell(int n) {
        if (this.spanInfo[n - 1] != null) {
            return this.spanInfo[n - 1].cell;
        }
        return null;
    }

    public boolean hasUnfinishedSpans() {
        int n = 0;
        while (n < this.spanInfo.length) {
            if (this.spanInfo[n] != null) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean ignoreKeeps() {
        return this.ignoreKeeps;
    }

    public boolean isInLastRow(int n) {
        if (this.spanInfo[n - 1] != null) {
            return this.spanInfo[n - 1].isInLastRow();
        }
        return false;
    }

    public boolean isSpanned(int n) {
        return this.spanInfo[n - 1] != null;
    }

    public void setIgnoreKeeps(boolean bl) {
        this.ignoreKeeps = bl;
    }

    class SpanInfo {
        int cellHeight;
        int totalRowHeight;
        int rowsRemaining;
        TableCell cell;

        SpanInfo(TableCell tableCell, int n, int n2) {
            this.cell = tableCell;
            this.cellHeight = n;
            this.totalRowHeight = 0;
            this.rowsRemaining = n2;
        }

        boolean finishRow(int n) {
            this.totalRowHeight += n;
            if (--this.rowsRemaining == 0) {
                if (this.cell != null) {
                    this.cell.setRowHeight(this.totalRowHeight);
                }
                return true;
            }
            return false;
        }

        int heightRemaining() {
            int n = this.cellHeight - this.totalRowHeight;
            return n > 0 ? n : 0;
        }

        boolean isInLastRow() {
            return this.rowsRemaining == 1;
        }
    }
}

