/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.pagination;

import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.fop.apps.FOPException;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.pagination.LayoutMasterSet;
import org.apache.fop.fo.pagination.Region;
import org.apache.fop.fo.pagination.RegionAfter;
import org.apache.fop.fo.pagination.RegionBefore;
import org.apache.fop.fo.pagination.RegionEnd;
import org.apache.fop.fo.pagination.RegionStart;
import org.apache.fop.layout.BodyRegionArea;
import org.apache.fop.layout.MarginProps;
import org.apache.fop.layout.PageMaster;
import org.apache.fop.layout.RegionArea;

public class SimplePageMaster
extends FObj {
    private Hashtable _regions;
    LayoutMasterSet layoutMasterSet;
    PageMaster pageMaster;
    String masterName;
    boolean beforePrecedence;
    int beforeHeight;
    boolean afterPrecedence;
    int afterHeight;

    protected SimplePageMaster(FObj fObj, PropertyList propertyList) throws FOPException {
        super(fObj, propertyList);
        this.name = "fo:simple-page-master";
        if (fObj.getName().equals("fo:layout-master-set")) {
            this.layoutMasterSet = (LayoutMasterSet)fObj;
            this.masterName = this.properties.get("master-name").getString();
            if (this.masterName == null) {
                this.log.warn("simple-page-master does not have a master-name and so is being ignored");
            } else {
                this.layoutMasterSet.addSimplePageMaster(this);
            }
        } else {
            throw new FOPException("fo:simple-page-master must be child of fo:layout-master-set, not " + fObj.getName());
        }
        this._regions = new Hashtable();
    }

    protected void addRegion(Region region) throws FOPException {
        if (this._regions.containsKey(region.getRegionClass())) {
            throw new FOPException("Only one region of class " + region.getRegionClass() + " allowed within a simple-page-master.");
        }
        this._regions.put(region.getRegionClass(), region);
    }

    protected void end() {
        RegionArea regionArea;
        int n = this.properties.get("page-width").getLength().mvalue();
        int n2 = this.properties.get("page-height").getLength().mvalue();
        MarginProps marginProps = this.propMgr.getMarginProps();
        int n3 = marginProps.marginLeft;
        int n4 = n2 - marginProps.marginTop;
        int n5 = n - marginProps.marginLeft - marginProps.marginRight;
        int n6 = n2 - marginProps.marginTop - marginProps.marginBottom;
        this.pageMaster = new PageMaster(n, n2);
        if (this.getRegion("body") != null) {
            regionArea = (BodyRegionArea)this.getRegion("body").makeRegionArea(n3, n4, n5, n6);
            this.pageMaster.addBody((BodyRegionArea)regionArea);
        } else {
            this.log.error("simple-page-master must have a region of class body");
        }
        if (this.getRegion("before") != null) {
            regionArea = this.getRegion("before").makeRegionArea(n3, n4, n5, n6);
            this.pageMaster.addBefore(regionArea);
            this.beforePrecedence = ((RegionBefore)this.getRegion("before")).getPrecedence();
            this.beforeHeight = regionArea.getHeight();
        } else {
            this.beforePrecedence = false;
        }
        if (this.getRegion("after") != null) {
            regionArea = this.getRegion("after").makeRegionArea(n3, n4, n5, n6);
            this.pageMaster.addAfter(regionArea);
            this.afterPrecedence = ((RegionAfter)this.getRegion("after")).getPrecedence();
            this.afterHeight = regionArea.getHeight();
        } else {
            this.afterPrecedence = false;
        }
        if (this.getRegion("start") != null) {
            regionArea = ((RegionStart)this.getRegion("start")).makeRegionArea(n3, n4, n5, n6, this.beforePrecedence, this.afterPrecedence, this.beforeHeight, this.afterHeight);
            this.pageMaster.addStart(regionArea);
        }
        if (this.getRegion("end") != null) {
            regionArea = ((RegionEnd)this.getRegion("end")).makeRegionArea(n3, n4, n5, n6, this.beforePrecedence, this.afterPrecedence, this.beforeHeight, this.afterHeight);
            this.pageMaster.addEnd(regionArea);
        }
    }

    public String getMasterName() {
        return this.masterName;
    }

    public PageMaster getNextPageMaster() {
        return this.pageMaster;
    }

    public PageMaster getPageMaster() {
        return this.pageMaster;
    }

    protected Region getRegion(String string) {
        return (Region)this._regions.get(string);
    }

    protected Hashtable getRegions() {
        return this._regions;
    }

    public static FObj.Maker maker() {
        return new Maker();
    }

    protected boolean regionNameExists(String string) {
        Enumeration enumeration = this._regions.elements();
        while (enumeration.hasMoreElements()) {
            Region region = (Region)enumeration.nextElement();
            if (!region.getRegionName().equals(string)) continue;
            return true;
        }
        return false;
    }

    public static class Maker
    extends FObj.Maker {
        public FObj make(FObj fObj, PropertyList propertyList) throws FOPException {
            return new SimplePageMaster(fObj, propertyList);
        }
    }
}

