/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.properties;

import org.apache.fop.apps.FOPException;
import org.apache.fop.datatypes.Space;
import org.apache.fop.fo.EnumProperty;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.LengthProperty;
import org.apache.fop.fo.NumberProperty;
import org.apache.fop.fo.Property;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.SpaceProperty;

public class GenericSpace
extends SpaceProperty.Maker {
    private static final Property.Maker s_MinimumMaker = new LengthProperty.Maker("generic-space.minimum");
    private static final Property.Maker s_OptimumMaker = new LengthProperty.Maker("generic-space.optimum");
    private static final Property.Maker s_MaximumMaker = new LengthProperty.Maker("generic-space.maximum");
    private static final Property.Maker s_PrecedenceMaker = new SP_PrecedenceMaker("generic-space.precedence");
    private static final Property.Maker s_ConditionalityMaker = new SP_ConditionalityMaker("generic-space.conditionality");
    Property.Maker m_shorthandMaker = this.getSubpropMaker("minimum");
    private Property m_defaultProp = null;

    protected GenericSpace(String string) {
        super(string);
    }

    public Property checkEnumValues(String string) {
        return this.m_shorthandMaker.checkEnumValues(string);
    }

    public Property convertProperty(Property property, PropertyList propertyList, FObj fObj) throws FOPException {
        if (property instanceof SpaceProperty) {
            return property;
        }
        if (!(property instanceof EnumProperty)) {
            property = this.m_shorthandMaker.convertProperty(property, propertyList, fObj);
        }
        if (property != null) {
            Property property2 = this.makeCompound(propertyList, fObj);
            Space space = property2.getSpace();
            space.setComponent("minimum", property, false);
            space.setComponent("optimum", property, false);
            space.setComponent("maximum", property, false);
            return property2;
        }
        return null;
    }

    protected String getDefaultForConditionality() {
        return "discard";
    }

    protected String getDefaultForMaximum() {
        return "0pt";
    }

    protected String getDefaultForMinimum() {
        return "0pt";
    }

    protected String getDefaultForOptimum() {
        return "0pt";
    }

    protected String getDefaultForPrecedence() {
        return "0";
    }

    protected Property.Maker getSubpropMaker(String string) {
        if (string.equals("minimum")) {
            return s_MinimumMaker;
        }
        if (string.equals("optimum")) {
            return s_OptimumMaker;
        }
        if (string.equals("maximum")) {
            return s_MaximumMaker;
        }
        if (string.equals("precedence")) {
            return s_PrecedenceMaker;
        }
        if (string.equals("conditionality")) {
            return s_ConditionalityMaker;
        }
        return super.getSubpropMaker(string);
    }

    public Property getSubpropValue(Property property, String string) {
        Space space = property.getSpace();
        return space.getComponent(string);
    }

    protected boolean isCompoundMaker() {
        return true;
    }

    public boolean isInherited() {
        return false;
    }

    public Property make(PropertyList propertyList) throws FOPException {
        if (this.m_defaultProp == null) {
            this.m_defaultProp = this.makeCompound(propertyList, propertyList.getParentFObj());
        }
        return this.m_defaultProp;
    }

    protected Property makeCompound(PropertyList propertyList, FObj fObj) throws FOPException {
        Space space = new Space();
        Property property = this.getSubpropMaker("minimum").make(propertyList, this.getDefaultForMinimum(), fObj);
        space.setComponent("minimum", property, true);
        property = this.getSubpropMaker("optimum").make(propertyList, this.getDefaultForOptimum(), fObj);
        space.setComponent("optimum", property, true);
        property = this.getSubpropMaker("maximum").make(propertyList, this.getDefaultForMaximum(), fObj);
        space.setComponent("maximum", property, true);
        property = this.getSubpropMaker("precedence").make(propertyList, this.getDefaultForPrecedence(), fObj);
        space.setComponent("precedence", property, true);
        property = this.getSubpropMaker("conditionality").make(propertyList, this.getDefaultForConditionality(), fObj);
        space.setComponent("conditionality", property, true);
        return new SpaceProperty(space);
    }

    public static Property.Maker maker(String string) {
        return new GenericSpace(string);
    }

    protected Property setSubprop(Property property, String string, Property property2) {
        Space space = property.getSpace();
        space.setComponent(string, property2, false);
        return property;
    }

    public static interface Enums {

        public static interface Precedence {
            public static final int FORCE = 31;
        }

        public static interface Conditionality {
            public static final int DISCARD = 17;
            public static final int RETAIN = 67;
        }
    }

    private static class SP_PrecedenceMaker
    extends NumberProperty.Maker
    implements Enums.Precedence {
        protected static final EnumProperty s_propFORCE = new EnumProperty(31);

        SP_PrecedenceMaker(String string) {
            super(string);
        }

        public Property checkEnumValues(String string) {
            if (string.equals("force")) {
                return s_propFORCE;
            }
            return super.checkEnumValues(string);
        }
    }

    private static class SP_ConditionalityMaker
    extends EnumProperty.Maker
    implements Enums.Conditionality {
        protected static final EnumProperty s_propDISCARD = new EnumProperty(17);
        protected static final EnumProperty s_propRETAIN = new EnumProperty(67);

        SP_ConditionalityMaker(String string) {
            super(string);
        }

        public Property checkEnumValues(String string) {
            if (string.equals("discard")) {
                return s_propDISCARD;
            }
            if (string.equals("retain")) {
                return s_propRETAIN;
            }
            return super.checkEnumValues(string);
        }
    }
}

