/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts.apps;

import java.io.File;
import java.io.FileInputStream;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.fop.fonts.PFMFile;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PFMReader {
    private boolean invokedStandalone = false;

    public Document constructFontXML(PFMFile pFMFile, String string, String string2, String string3, String string4) {
        Object object;
        Document document;
        System.out.println("Creating xml font file...");
        System.out.println();
        try {
            document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            System.out.println("Can't create DOM implementation " + parserConfigurationException.getMessage());
            return null;
        }
        Element element = document.createElement("font-metrics");
        document.appendChild(element);
        element.setAttribute("type", "TYPE1");
        Element element2 = document.createElement("font-name");
        element.appendChild(element2);
        element2.appendChild(document.createTextNode(pFMFile.getPostscriptName()));
        String string5 = pFMFile.getPostscriptName();
        int n = string5.indexOf("-");
        if (n >= 0) {
            object = new char[string5.length() - 1];
            string5.getChars(0, n, (char[])object, 0);
            string5.getChars(n + 1, string5.length(), (char[])object, n);
            string5 = new String((char[])object);
        }
        element2 = document.createElement("embed");
        element.appendChild(element2);
        if (string4 != null) {
            element2.setAttribute("file", string4);
        }
        if (string3 != null) {
            element2.setAttribute("class", string3);
        }
        element2 = document.createElement("encoding");
        element.appendChild(element2);
        element2.appendChild(document.createTextNode(String.valueOf(pFMFile.getCharSetName()) + "Encoding"));
        element2 = document.createElement("cap-height");
        element.appendChild(element2);
        object = new Integer(pFMFile.getCapHeight());
        element2.appendChild(document.createTextNode(((Integer)object).toString()));
        element2 = document.createElement("x-height");
        element.appendChild(element2);
        object = new Integer(pFMFile.getXHeight());
        element2.appendChild(document.createTextNode(((Integer)object).toString()));
        element2 = document.createElement("ascender");
        element.appendChild(element2);
        object = new Integer(pFMFile.getLowerCaseAscent());
        element2.appendChild(document.createTextNode(((Integer)object).toString()));
        element2 = document.createElement("descender");
        element.appendChild(element2);
        object = new Integer(-pFMFile.getLowerCaseDescent());
        element2.appendChild(document.createTextNode(((Integer)object).toString()));
        Element element3 = document.createElement("bbox");
        element.appendChild(element3);
        int[] nArray = pFMFile.getFontBBox();
        String[] stringArray = new String[]{"left", "bottom", "right", "top"};
        int n2 = 0;
        while (n2 < 4) {
            element2 = document.createElement(stringArray[n2]);
            element3.appendChild(element2);
            object = new Integer(nArray[n2]);
            element2.appendChild(document.createTextNode(((Integer)object).toString()));
            ++n2;
        }
        element2 = document.createElement("flags");
        element.appendChild(element2);
        object = new Integer(pFMFile.getFlags());
        element2.appendChild(document.createTextNode(((Integer)object).toString()));
        element2 = document.createElement("stemv");
        element.appendChild(element2);
        object = new Integer(pFMFile.getStemV());
        element2.appendChild(document.createTextNode(((Integer)object).toString()));
        element2 = document.createElement("italicangle");
        element.appendChild(element2);
        object = new Integer(pFMFile.getItalicAngle());
        element2.appendChild(document.createTextNode(((Integer)object).toString()));
        element2 = document.createElement("first-char");
        element.appendChild(element2);
        object = new Integer(pFMFile.getFirstChar());
        element2.appendChild(document.createTextNode(((Integer)object).toString()));
        element2 = document.createElement("last-char");
        element.appendChild(element2);
        object = new Integer(pFMFile.getLastChar());
        element2.appendChild(document.createTextNode(((Integer)object).toString()));
        Element element4 = document.createElement("widths");
        element.appendChild(element4);
        short s = pFMFile.getFirstChar();
        while (s <= pFMFile.getLastChar()) {
            element2 = document.createElement("char");
            element4.appendChild(element2);
            element2.setAttribute("idx", Integer.toString(s));
            element2.setAttribute("wdt", new Integer(pFMFile.getCharWidth(s)).toString());
            s = (short)(s + 1);
        }
        Enumeration enumeration = pFMFile.getKerning().keys();
        while (enumeration.hasMoreElements()) {
            Integer n3 = (Integer)enumeration.nextElement();
            element2 = document.createElement("kerning");
            element2.setAttribute("kpx1", n3.toString());
            element.appendChild(element2);
            Element element5 = null;
            Hashtable hashtable = (Hashtable)pFMFile.getKerning().get(n3);
            Enumeration enumeration2 = hashtable.keys();
            while (enumeration2.hasMoreElements()) {
                Integer n4 = (Integer)enumeration2.nextElement();
                element5 = document.createElement("pair");
                element5.setAttribute("kpx2", n4.toString());
                Integer n5 = (Integer)hashtable.get(n4);
                element5.setAttribute("kern", n5.toString());
                element2.appendChild(element5);
            }
        }
        return document;
    }

    private static final void displayUsage() {
        System.out.println(" java org.apache.fop.fonts.apps.PFMReader [options] metricfile.pfm xmlfile.xml\n");
        System.out.println(" where options can be:\n");
        System.out.println(" -fn <fontname>\n");
        System.out.println("     default is to use the fontname in the .ttf file, but\n     you can override that name to make sure that the\n");
        System.out.println("     embedded font is used (if you're embedding fonts)\n");
        System.out.println("     instead of installed fonts when viewing documents with Acrobat Reader.\n");
    }

    private String escapeString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            if (string.charAt(n) == '\\') {
                stringBuffer.append("\\\\");
            } else {
                stringBuffer.append(string.charAt(n));
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public PFMFile loadPFM(String string) {
        try {
            System.out.println("Reading " + string + "...");
            System.out.println();
            FileInputStream fileInputStream = new FileInputStream(string);
            PFMFile pFMFile = new PFMFile();
            pFMFile.load(fileInputStream);
            return pFMFile;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static void main(String[] stringArray) {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        Hashtable hashtable = new Hashtable();
        String[] stringArray2 = PFMReader.parseArguments(hashtable, stringArray);
        PFMReader pFMReader = new PFMReader();
        pFMReader.invokedStandalone = true;
        System.out.println("PFM Reader v1.1");
        System.out.println();
        if (hashtable.get("-ef") != null) {
            string = (String)hashtable.get("-ef");
        }
        if (hashtable.get("-er") != null) {
            string2 = (String)hashtable.get("-er");
        }
        if (hashtable.get("-fn") != null) {
            string4 = (String)hashtable.get("-fn");
        }
        if (hashtable.get("-cn") != null) {
            string3 = (String)hashtable.get("-cn");
        }
        if (stringArray2.length != 2 || hashtable.get("-h") != null || hashtable.get("-help") != null || hashtable.get("--help") != null) {
            PFMReader.displayUsage();
        } else {
            PFMFile pFMFile = pFMReader.loadPFM(stringArray2[0]);
            if (pFMFile != null) {
                pFMReader.preview(pFMFile);
                Document document = pFMReader.constructFontXML(pFMFile, string4, string3, string2, string);
                pFMReader.writeFontXML(document, stringArray2[1]);
            }
        }
    }

    private static String[] parseArguments(Hashtable hashtable, String[] stringArray) {
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].startsWith("-")) {
                if (n + 1 < stringArray.length && !stringArray[n + 1].startsWith("-")) {
                    hashtable.put(stringArray[n], stringArray[n + 1]);
                    ++n;
                } else {
                    hashtable.put(stringArray[n], "");
                }
            } else {
                vector.addElement(stringArray[n]);
            }
            ++n;
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public void preview(PFMFile pFMFile) {
        PrintStream printStream = System.out;
        printStream.print("Font: ");
        printStream.println(pFMFile.getWindowsName());
        printStream.print("Name: ");
        printStream.println(pFMFile.getPostscriptName());
        printStream.print("CharSet: ");
        printStream.println(pFMFile.getCharSetName());
        printStream.print("CapHeight: ");
        printStream.println(pFMFile.getCapHeight());
        printStream.print("XHeight: ");
        printStream.println(pFMFile.getXHeight());
        printStream.print("LowerCaseAscent: ");
        printStream.println(pFMFile.getLowerCaseAscent());
        printStream.print("LowerCaseDescent: ");
        printStream.println(pFMFile.getLowerCaseDescent());
        printStream.print("Having widths for ");
        printStream.print(pFMFile.getLastChar() - pFMFile.getFirstChar());
        printStream.print(" characters (");
        printStream.print(pFMFile.getFirstChar());
        printStream.print("-");
        printStream.print(pFMFile.getLastChar());
        printStream.println(").");
        printStream.print("for example: Char ");
        printStream.print(pFMFile.getFirstChar());
        printStream.print(" has a width of ");
        printStream.println(pFMFile.getCharWidth(pFMFile.getFirstChar()));
        printStream.println();
    }

    public void writeFontXML(Document document, String string) {
        System.out.println("Writing xml font file " + string + "...");
        System.out.println();
        try {
            TransformerFactory.newInstance().newTransformer().transform(new DOMSource(document), new StreamResult(new File(string)));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

