/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.image;

import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.awt.image.PixelGrabber;
import java.util.Hashtable;

public class FopImageConsumer
implements ImageConsumer {
    protected int width = -1;
    protected int height = -1;
    protected Integer imageStatus = new Integer(-1);
    protected int hints = 0;
    protected Hashtable properties = null;
    protected ColorModel cm = null;
    protected ImageProducer ip = null;

    public FopImageConsumer(ImageProducer imageProducer) {
        this.ip = imageProducer;
    }

    public ColorModel getColorModel() {
        return this.cm;
    }

    public int getHeight() {
        return this.height;
    }

    public int[] getImage() throws Exception {
        int[] nArray = new int[this.width * this.height];
        PixelGrabber pixelGrabber = new PixelGrabber(this.ip, 0, 0, this.width, this.height, nArray, 0, this.width);
        pixelGrabber.setDimensions(this.width, this.height);
        pixelGrabber.setColorModel(this.cm);
        pixelGrabber.setHints(this.hints);
        pixelGrabber.setProperties(this.properties);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            throw new Exception("Image grabbing interrupted : " + interruptedException.getMessage());
        }
        return nArray;
    }

    public int getWidth() {
        return this.width;
    }

    public void imageComplete(int n) {
        Integer n2 = this.imageStatus;
        synchronized (n2) {
            if (this.imageStatus != 3 && this.imageStatus != 2) {
                this.imageStatus = new Integer(n);
            }
        }
    }

    public boolean isImageReady() throws Exception {
        Integer n = this.imageStatus;
        synchronized (n) {
            if (this.imageStatus == 4) {
                throw new Exception("Image aborted");
            }
            if (this.imageStatus == 1) {
                throw new Exception("Image error");
            }
            if (this.imageStatus == 3 || this.imageStatus == 2) {
                boolean bl = true;
                Object var3_4 = null;
                return bl;
            }
            boolean bl = false;
            Object var3_5 = null;
            return bl;
        }
    }

    public void setColorModel(ColorModel colorModel) {
        this.cm = colorModel;
    }

    public void setDimensions(int n, int n2) {
        this.width = n;
        this.height = n2;
    }

    public void setHints(int n) {
        this.hints = n;
    }

    public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, byte[] byArray, int n5, int n6) {
    }

    public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, int[] nArray, int n5, int n6) {
    }

    public void setProperties(Hashtable hashtable) {
        this.properties = hashtable;
    }
}

