/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layout;

import org.apache.fop.datatypes.ColorType;
import org.apache.fop.datatypes.CondLength;

public class BorderAndPadding
implements Cloneable {
    public static final int TOP = 0;
    public static final int RIGHT = 1;
    public static final int BOTTOM = 2;
    public static final int LEFT = 3;
    private BorderInfo[] borderInfo = new BorderInfo[4];
    private ResolvedCondLength[] padding = new ResolvedCondLength[4];

    public Object clone() throws CloneNotSupportedException {
        BorderAndPadding borderAndPadding = (BorderAndPadding)super.clone();
        borderAndPadding.padding = (ResolvedCondLength[])this.padding.clone();
        borderAndPadding.borderInfo = (BorderInfo[])this.borderInfo.clone();
        int n = 0;
        while (n < this.padding.length) {
            if (this.padding[n] != null) {
                borderAndPadding.padding[n] = (ResolvedCondLength)this.padding[n].clone();
            }
            if (this.borderInfo[n] != null) {
                borderAndPadding.borderInfo[n] = (BorderInfo)this.borderInfo[n].clone();
            }
            ++n;
        }
        return borderAndPadding;
    }

    public int getBorderBottomWidth(boolean bl) {
        return this.getBorderWidth(2, bl);
    }

    public ColorType getBorderColor(int n) {
        if (this.borderInfo[n] != null) {
            return this.borderInfo[n].mColor;
        }
        return null;
    }

    public int getBorderLeftWidth(boolean bl) {
        return this.getBorderWidth(3, bl);
    }

    public int getBorderRightWidth(boolean bl) {
        return this.getBorderWidth(1, bl);
    }

    public int getBorderStyle(int n) {
        if (this.borderInfo[n] != null) {
            return this.borderInfo[n].mStyle;
        }
        return 0;
    }

    public int getBorderTopWidth(boolean bl) {
        return this.getBorderWidth(0, bl);
    }

    private int getBorderWidth(int n, boolean bl) {
        if (this.borderInfo[n] == null || bl && ((BorderInfo)this.borderInfo[n]).mWidth.bDiscard) {
            return 0;
        }
        return ((BorderInfo)this.borderInfo[n]).mWidth.iLength;
    }

    private int getPadding(int n, boolean bl) {
        if (this.padding[n] == null || bl && this.padding[n].bDiscard) {
            return 0;
        }
        return this.padding[n].iLength;
    }

    public int getPaddingBottom(boolean bl) {
        return this.getPadding(2, bl);
    }

    public int getPaddingLeft(boolean bl) {
        return this.getPadding(3, bl);
    }

    public int getPaddingRight(boolean bl) {
        return this.getPadding(1, bl);
    }

    public int getPaddingTop(boolean bl) {
        return this.getPadding(0, bl);
    }

    public void setBorder(int n, int n2, CondLength condLength, ColorType colorType) {
        this.borderInfo[n] = new BorderInfo(n2, condLength, colorType);
    }

    public void setBorderLength(int n, int n2) {
        ((BorderInfo)this.borderInfo[n]).mWidth.iLength = n2;
    }

    public void setPadding(int n, CondLength condLength) {
        this.padding[n] = new ResolvedCondLength(condLength);
    }

    public void setPaddingLength(int n, int n2) {
        this.padding[n].iLength = n2;
    }

    private static class ResolvedCondLength
    implements Cloneable {
        int iLength;
        boolean bDiscard;

        ResolvedCondLength(CondLength condLength) {
            this.bDiscard = condLength.isDiscard();
            this.iLength = condLength.mvalue();
        }

        public Object clone() throws CloneNotSupportedException {
            return super.clone();
        }
    }

    public static class BorderInfo
    implements Cloneable {
        private int mStyle;
        private ColorType mColor;
        private ResolvedCondLength mWidth;

        BorderInfo(int n, CondLength condLength, ColorType colorType) {
            this.mStyle = n;
            this.mWidth = new ResolvedCondLength(condLength);
            this.mColor = colorType;
        }

        public Object clone() throws CloneNotSupportedException {
            BorderInfo borderInfo = (BorderInfo)super.clone();
            borderInfo.mWidth = (ResolvedCondLength)this.mWidth.clone();
            return borderInfo;
        }
    }
}

