/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layout.hyphenation;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import org.apache.fop.layout.hyphenation.Hyphen;
import org.apache.fop.layout.hyphenation.HyphenationException;
import org.apache.fop.layout.hyphenation.PatternConsumer;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class PatternParser
extends DefaultHandler
implements PatternConsumer {
    XMLReader parser;
    int currElement;
    PatternConsumer consumer;
    StringBuffer token = new StringBuffer();
    Vector exception;
    char hyphenChar;
    String errMsg;
    static final int ELEM_CLASSES = 1;
    static final int ELEM_EXCEPTIONS = 2;
    static final int ELEM_PATTERNS = 3;
    static final int ELEM_HYPHEN = 4;

    public PatternParser() throws HyphenationException {
        this.parser = PatternParser.createParser();
        this.parser.setContentHandler(this);
        this.parser.setErrorHandler(this);
        this.hyphenChar = (char)45;
    }

    public PatternParser(PatternConsumer patternConsumer) throws HyphenationException {
        this();
        this.consumer = patternConsumer;
    }

    public void addClass(String string) {
        System.out.println("class: " + string);
    }

    public void addException(String string, Vector vector) {
        System.out.println("exception: " + string + " : " + vector.toString());
    }

    public void addPattern(String string, String string2) {
        System.out.println("pattern: " + string + " : " + string2);
    }

    public void characters(char[] cArray, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer(n2);
        stringBuffer.append(cArray, n, n2);
        String string = this.readToken(stringBuffer);
        while (string != null) {
            switch (this.currElement) {
                case 1: {
                    this.consumer.addClass(string);
                    break;
                }
                case 2: {
                    this.exception.addElement(string);
                    this.exception = this.normalizeException(this.exception);
                    this.consumer.addException(this.getExceptionWord(this.exception), (Vector)this.exception.clone());
                    this.exception.removeAllElements();
                    break;
                }
                case 3: {
                    this.consumer.addPattern(PatternParser.getPattern(string), PatternParser.getInterletterValues(string));
                    break;
                }
            }
            string = this.readToken(stringBuffer);
        }
    }

    static XMLReader createParser() throws HyphenationException {
        String string = System.getProperty("org.xml.sax.parser");
        if (string == null) {
            string = "org.apache.xerces.parsers.SAXParser";
        }
        try {
            return (XMLReader)Class.forName(string).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new HyphenationException("Could not find " + string);
        }
        catch (InstantiationException instantiationException) {
            throw new HyphenationException("Could not instantiate " + string);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new HyphenationException("Could not access " + string);
        }
        catch (ClassCastException classCastException) {
            throw new HyphenationException(String.valueOf(string) + " is not a SAX driver");
        }
    }

    public void endElement(String string, String string2, String string3) {
        if (this.token.length() > 0) {
            String string4 = this.token.toString();
            switch (this.currElement) {
                case 1: {
                    this.consumer.addClass(string4);
                    break;
                }
                case 2: {
                    this.exception.addElement(string4);
                    this.exception = this.normalizeException(this.exception);
                    this.consumer.addException(this.getExceptionWord(this.exception), (Vector)this.exception.clone());
                    break;
                }
                case 3: {
                    this.consumer.addPattern(PatternParser.getPattern(string4), PatternParser.getInterletterValues(string4));
                    break;
                }
            }
            if (this.currElement != 4) {
                this.token.setLength(0);
            }
        }
        this.currElement = this.currElement == 4 ? 2 : 0;
    }

    public void error(SAXParseException sAXParseException) {
        this.errMsg = "[Error] " + this.getLocationString(sAXParseException) + ": " + sAXParseException.getMessage();
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        this.errMsg = "[Fatal Error] " + this.getLocationString(sAXParseException) + ": " + sAXParseException.getMessage();
        throw sAXParseException;
    }

    protected static InputSource fileInputSource(String string) throws HyphenationException {
        File file = new File(string);
        String string2 = file.getAbsolutePath();
        String string3 = System.getProperty("file.separator");
        if (string3 != null && string3.length() == 1) {
            string2 = string2.replace(string3.charAt(0), '/');
        }
        if (string2.length() > 0 && string2.charAt(0) != '/') {
            string2 = String.valueOf('/') + string2;
        }
        try {
            return new InputSource(new URL("file", null, string2).toString());
        }
        catch (MalformedURLException malformedURLException) {
            throw new HyphenationException("unexpected MalformedURLException");
        }
    }

    protected String getExceptionWord(Vector vector) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < vector.size()) {
            Object e = vector.elementAt(n);
            if (e instanceof String) {
                stringBuffer.append((String)e);
            } else if (((Hyphen)e).noBreak != null) {
                stringBuffer.append(((Hyphen)e).noBreak);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    protected static String getInterletterValues(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = String.valueOf(string) + "a";
        int n = string2.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string2.charAt(n2);
            if (Character.isDigit(c)) {
                stringBuffer.append(c);
                ++n2;
            } else {
                stringBuffer.append('0');
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    private String getLocationString(SAXParseException sAXParseException) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = sAXParseException.getSystemId();
        if (string != null) {
            int n = string.lastIndexOf(47);
            if (n != -1) {
                string = string.substring(n + 1);
            }
            stringBuffer.append(string);
        }
        stringBuffer.append(':');
        stringBuffer.append(sAXParseException.getLineNumber());
        stringBuffer.append(':');
        stringBuffer.append(sAXParseException.getColumnNumber());
        return stringBuffer.toString();
    }

    protected static String getPattern(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            if (!Character.isDigit(string.charAt(n2))) {
                stringBuffer.append(string.charAt(n2));
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length > 0) {
            PatternParser patternParser = new PatternParser();
            patternParser.setConsumer(patternParser);
            patternParser.parse(stringArray[0]);
        }
    }

    protected Vector normalizeException(Vector vector) {
        Vector<Object> vector2 = new Vector<Object>();
        int n = 0;
        while (n < vector.size()) {
            Object e = vector.elementAt(n);
            if (e instanceof String) {
                String string = (String)e;
                StringBuffer stringBuffer = new StringBuffer();
                int n2 = 0;
                while (n2 < string.length()) {
                    char c = string.charAt(n2);
                    if (c != this.hyphenChar) {
                        stringBuffer.append(c);
                    } else {
                        vector2.addElement(stringBuffer.toString());
                        stringBuffer.setLength(0);
                        char[] cArray = new char[]{this.hyphenChar};
                        vector2.addElement(new Hyphen(new String(cArray), null, null));
                    }
                    ++n2;
                }
                if (stringBuffer.length() > 0) {
                    vector2.addElement(stringBuffer.toString());
                }
            } else {
                vector2.addElement(e);
            }
            ++n;
        }
        return vector2;
    }

    public void parse(String string) throws HyphenationException {
        InputSource inputSource = PatternParser.fileInputSource(string);
        try {
            this.parser.parse(inputSource);
        }
        catch (SAXException sAXException) {
            throw new HyphenationException(this.errMsg);
        }
        catch (IOException iOException) {
            throw new HyphenationException(iOException.getMessage());
        }
        catch (NullPointerException nullPointerException) {
            throw new HyphenationException("SAX parser not available");
        }
    }

    protected String readToken(StringBuffer stringBuffer) {
        int n;
        boolean bl = false;
        int n2 = 0;
        while (n2 < stringBuffer.length()) {
            if (!Character.isWhitespace(stringBuffer.charAt(n2))) break;
            bl = true;
            ++n2;
        }
        if (bl) {
            n = n2;
            while (n < stringBuffer.length()) {
                stringBuffer.setCharAt(n - n2, stringBuffer.charAt(n));
                ++n;
            }
            stringBuffer.setLength(stringBuffer.length() - n2);
            if (this.token.length() > 0) {
                String string = this.token.toString();
                this.token.setLength(0);
                return string;
            }
        }
        bl = false;
        n2 = 0;
        while (n2 < stringBuffer.length()) {
            if (Character.isWhitespace(stringBuffer.charAt(n2))) {
                bl = true;
                break;
            }
            ++n2;
        }
        this.token.append(stringBuffer.toString().substring(0, n2));
        n = n2;
        while (n < stringBuffer.length()) {
            stringBuffer.setCharAt(n - n2, stringBuffer.charAt(n));
            ++n;
        }
        stringBuffer.setLength(stringBuffer.length() - n2);
        if (bl) {
            String string = this.token.toString();
            this.token.setLength(0);
            return string;
        }
        this.token.append((Object)stringBuffer);
        return null;
    }

    public void setConsumer(PatternConsumer patternConsumer) {
        this.consumer = patternConsumer;
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) {
        if (string2.equals("hyphen-char")) {
            String string4 = attributes.getValue("value");
            if (string4 != null && string4.length() == 1) {
                this.hyphenChar = string4.charAt(0);
            }
        } else if (string2.equals("classes")) {
            this.currElement = 1;
        } else if (string2.equals("patterns")) {
            this.currElement = 3;
        } else if (string2.equals("exceptions")) {
            this.currElement = 2;
            this.exception = new Vector();
        } else if (string2.equals("hyphen")) {
            if (this.token.length() > 0) {
                this.exception.addElement(this.token.toString());
            }
            this.exception.addElement(new Hyphen(attributes.getValue("pre"), attributes.getValue("no"), attributes.getValue("post")));
            this.currElement = 4;
        }
        this.token.setLength(0);
    }

    public void warning(SAXParseException sAXParseException) {
        this.errMsg = "[Warning] " + this.getLocationString(sAXParseException) + ": " + sAXParseException.getMessage();
    }
}

