/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.io.UnsupportedEncodingException;
import java.util.Vector;
import org.apache.fop.pdf.PDFNumber;
import org.apache.fop.pdf.PDFObject;

public class PDFFunction
extends PDFObject {
    protected int functionType = 0;
    protected Vector domain = null;
    protected Vector range = null;
    protected Vector size = null;
    protected int bitsPerSample = 1;
    protected int order = 1;
    protected Vector encode = null;
    protected Vector decode = null;
    protected StringBuffer functionDataStream = null;
    protected Vector filter = null;
    protected Vector cZero = null;
    protected Vector cOne = null;
    protected double interpolationExponentN = 1.0;
    protected Vector functions = null;
    protected Vector bounds = null;

    public PDFFunction(int n, int n2, Vector vector, Vector vector2, StringBuffer stringBuffer) {
        super(n);
        this.functionType = 4;
        this.functionDataStream = stringBuffer;
        this.domain = vector;
        this.range = vector2;
    }

    public PDFFunction(int n, int n2, Vector vector, Vector vector2, Vector vector3, int n3, int n4, Vector vector4, Vector vector5, StringBuffer stringBuffer, Vector vector6) {
        super(n);
        this.functionType = 0;
        this.size = vector3;
        this.bitsPerSample = n3;
        this.order = n4;
        this.encode = vector4;
        this.decode = vector5;
        this.functionDataStream = stringBuffer;
        this.filter = vector6;
        this.domain = vector;
        this.range = vector2;
    }

    public PDFFunction(int n, int n2, Vector vector, Vector vector2, Vector vector3, Vector vector4, double d) {
        super(n);
        this.functionType = 2;
        this.cZero = vector3;
        this.cOne = vector4;
        this.interpolationExponentN = d;
        this.domain = vector;
        this.range = vector2;
    }

    public PDFFunction(int n, int n2, Vector vector, Vector vector2, Vector vector3, Vector vector4, Vector vector5) {
        super(n);
        this.functionType = 3;
        this.functions = vector3;
        this.bounds = vector4;
        this.encode = vector5;
        this.domain = vector;
        this.range = vector2;
    }

    public byte[] toPDF() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(String.valueOf(this.number) + " " + this.generation + " obj\n<< \n/FunctionType " + this.functionType + " \n");
        if (this.functionType == 0) {
            if (this.domain != null) {
                stringBuffer.append("/Domain [ ");
                n = this.domain.size();
                n3 = 0;
                while (n3 < n) {
                    stringBuffer.append(String.valueOf(PDFNumber.doubleOut((Double)this.domain.elementAt(n3))) + " ");
                    ++n3;
                }
                stringBuffer.append("] \n");
            } else {
                stringBuffer.append("/Domain [ 0 1 ] \n");
            }
            if (this.size != null) {
                stringBuffer.append("/Size [ ");
                n = this.size.size();
                n3 = 0;
                while (n3 < n) {
                    stringBuffer.append(String.valueOf(PDFNumber.doubleOut((Double)this.size.elementAt(n3))) + " ");
                    ++n3;
                }
                stringBuffer.append("] \n");
            }
            if (this.encode != null) {
                stringBuffer.append("/Encode [ ");
                n = this.encode.size();
                n3 = 0;
                while (n3 < n) {
                    stringBuffer.append(String.valueOf(PDFNumber.doubleOut((Double)this.encode.elementAt(n3))) + " ");
                    ++n3;
                }
                stringBuffer.append("] \n");
            } else {
                stringBuffer.append("/Encode [ ");
                n = this.functions.size();
                n3 = 0;
                while (n3 < n) {
                    stringBuffer.append("0 1 ");
                    ++n3;
                }
                stringBuffer.append("] \n");
            }
            stringBuffer.append("/BitsPerSample " + this.bitsPerSample);
            if (this.order == 1 || this.order == 3) {
                stringBuffer.append(" \n/Order " + this.order + " \n");
            }
            if (this.range != null) {
                stringBuffer.append("/Range [ ");
                n = this.range.size();
                n3 = 0;
                while (n3 < n) {
                    stringBuffer.append(String.valueOf(PDFNumber.doubleOut((Double)this.range.elementAt(n3))) + " ");
                    ++n3;
                }
                stringBuffer.append("] \n");
            }
            if (this.decode != null) {
                stringBuffer.append("/Decode [ ");
                n = this.decode.size();
                n3 = 0;
                while (n3 < n) {
                    stringBuffer.append(String.valueOf(PDFNumber.doubleOut((Double)this.decode.elementAt(n3))) + " ");
                    ++n3;
                }
                stringBuffer.append("] \n");
            }
            if (this.functionDataStream != null) {
                stringBuffer.append("/Length " + (this.functionDataStream.length() + 1) + " \n");
            }
            if (this.filter != null) {
                n = this.filter.size();
                stringBuffer.append("/Filter ");
                if (n == 1) {
                    stringBuffer.append("/" + (String)this.filter.elementAt(0) + " \n");
                } else {
                    stringBuffer.append("[ ");
                    n3 = 0;
                    while (n3 < n) {
                        stringBuffer.append("/" + (String)this.filter.elementAt(0) + " ");
                        ++n3;
                    }
                    stringBuffer.append("] \n");
                }
            }
            stringBuffer.append(">> \n");
            if (this.functionDataStream != null) {
                stringBuffer.append("stream\n" + this.functionDataStream + "\nendstream\n");
            }
            stringBuffer.append("endobj\n");
        } else if (this.functionType == 2) {
            if (this.domain != null) {
                stringBuffer.append("/Domain [ ");
                n = this.domain.size();
                n3 = 0;
                while (n3 < n) {
                    stringBuffer.append(String.valueOf(PDFNumber.doubleOut((Double)this.domain.elementAt(n3))) + " ");
                    ++n3;
                }
                stringBuffer.append("] \n");
            } else {
                stringBuffer.append("/Domain [ 0 1 ] \n");
            }
            if (this.range != null) {
                stringBuffer.append("/Range [ ");
                n = this.range.size();
                n3 = 0;
                while (n3 < n) {
                    stringBuffer.append(String.valueOf(PDFNumber.doubleOut((Double)this.range.elementAt(n3))) + " ");
                    ++n3;
                }
                stringBuffer.append("] \n");
            }
            if (this.cZero != null) {
                stringBuffer.append("/C0 [ ");
                n = this.cZero.size();
                n3 = 0;
                while (n3 < n) {
                    stringBuffer.append(String.valueOf(PDFNumber.doubleOut((Double)this.cZero.elementAt(n3))) + " ");
                    ++n3;
                }
                stringBuffer.append("] \n");
            }
            if (this.cOne != null) {
                stringBuffer.append("/C1 [ ");
                n = this.cOne.size();
                n3 = 0;
                while (n3 < n) {
                    stringBuffer.append(String.valueOf(PDFNumber.doubleOut((Double)this.cOne.elementAt(n3))) + " ");
                    ++n3;
                }
                stringBuffer.append("] \n");
            }
            stringBuffer.append("/N " + PDFNumber.doubleOut(new Double(this.interpolationExponentN)) + " \n");
            stringBuffer.append(">> \nendobj\n");
        } else if (this.functionType == 3) {
            if (this.domain != null) {
                stringBuffer.append("/Domain [ ");
                n = this.domain.size();
                n3 = 0;
                while (n3 < n) {
                    stringBuffer.append(String.valueOf(PDFNumber.doubleOut((Double)this.domain.elementAt(n3))) + " ");
                    ++n3;
                }
                stringBuffer.append("] \n");
            } else {
                stringBuffer.append("/Domain [ 0 1 ] \n");
            }
            if (this.range != null) {
                stringBuffer.append("/Range [ ");
                n = this.range.size();
                n3 = 0;
                while (n3 < n) {
                    stringBuffer.append(String.valueOf(PDFNumber.doubleOut((Double)this.range.elementAt(n3))) + " ");
                    ++n3;
                }
                stringBuffer.append("] \n");
            }
            if (this.functions != null) {
                stringBuffer.append("/Functions [ ");
                n2 = this.functions.size();
                n3 = 0;
                while (n3 < n2) {
                    stringBuffer.append(String.valueOf(((PDFFunction)this.functions.elementAt(n3)).referencePDF()) + " ");
                    ++n3;
                }
                stringBuffer.append("] \n");
            }
            if (this.encode != null) {
                stringBuffer.append("/Encode [ ");
                n = this.encode.size();
                n3 = 0;
                while (n3 < n) {
                    stringBuffer.append(String.valueOf(PDFNumber.doubleOut((Double)this.encode.elementAt(n3))) + " ");
                    ++n3;
                }
                stringBuffer.append("] \n");
            } else {
                stringBuffer.append("/Encode [ ");
                n = this.functions.size();
                n3 = 0;
                while (n3 < n) {
                    stringBuffer.append("0 1 ");
                    ++n3;
                }
                stringBuffer.append("] \n");
            }
            stringBuffer.append("/Bounds [ ");
            if (this.bounds != null) {
                n = this.bounds.size();
                n3 = 0;
                while (n3 < n) {
                    stringBuffer.append(String.valueOf(PDFNumber.doubleOut((Double)this.bounds.elementAt(n3))) + " ");
                    ++n3;
                }
            } else if (this.functions != null) {
                String string = PDFNumber.doubleOut(new Double(1.0 / (double)n2));
                n3 = 0;
                while (n3 + 1 < n2) {
                    stringBuffer.append(String.valueOf(string) + " ");
                    ++n3;
                }
                string = null;
            }
            stringBuffer.append("] \n");
            stringBuffer.append(">> \nendobj\n");
        } else if (this.functionType == 4) {
            if (this.domain != null) {
                stringBuffer.append("/Domain [ ");
                n = this.domain.size();
                n3 = 0;
                while (n3 < n) {
                    stringBuffer.append(String.valueOf(PDFNumber.doubleOut((Double)this.domain.elementAt(n3))) + " ");
                    ++n3;
                }
                stringBuffer.append("] \n");
            } else {
                stringBuffer.append("/Domain [ 0 1 ] \n");
            }
            if (this.range != null) {
                stringBuffer.append("/Range [ ");
                n = this.range.size();
                n3 = 0;
                while (n3 < n) {
                    stringBuffer.append(String.valueOf(PDFNumber.doubleOut((Double)this.range.elementAt(n3))) + " ");
                    ++n3;
                }
                stringBuffer.append("] \n");
            }
            if (this.functionDataStream != null) {
                stringBuffer.append("/Length " + (this.functionDataStream.length() + 1) + " \n");
            }
            stringBuffer.append(">> \n");
            if (this.functionDataStream != null) {
                stringBuffer.append("stream\n{ " + this.functionDataStream + " } \nendstream\n");
            }
            stringBuffer.append("endobj\n");
        }
        try {
            return stringBuffer.toString().getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return stringBuffer.toString().getBytes();
        }
    }
}

