/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.apache.fop.datatypes.ColorSpace;
import org.apache.fop.pdf.PDFStream;

public class PDFICCStream
extends PDFStream {
    private int origLength;
    private int len1;
    private int len3;
    private byte[] originalData = null;
    private ColorSpace cs;

    public PDFICCStream(int n) {
        super(n);
        this.cs = null;
    }

    public PDFICCStream(int n, ColorSpace colorSpace) throws IOException {
        super(n);
        this.setColorSpace(colorSpace);
    }

    protected int output(OutputStream outputStream) throws IOException {
        byte[] byArray;
        int n = 0;
        String string = this.applyFilters();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.number).append(" ").append(this.generation).append(" obj\n<< ");
        stringBuffer.append("/N ").append(this.cs.getNumComponents()).append(" ");
        if (this.cs.getColorSpace() > 0) {
            stringBuffer.append("/Alternate /").append(this.cs.getColorSpacePDFString()).append(" ");
        }
        stringBuffer.append("/Length ").append(this._data.size() + 1).append(" ").append(string);
        stringBuffer.append(" >>\n");
        try {
            byArray = stringBuffer.toString().getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byArray = stringBuffer.toString().getBytes();
        }
        outputStream.write(byArray);
        n += byArray.length;
        n += this.outputStreamData(outputStream);
        try {
            byArray = "endobj\n".getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byArray = "endobj\n".getBytes();
        }
        outputStream.write(byArray);
        return n += byArray.length;
    }

    public void setColorSpace(ColorSpace colorSpace) throws IOException {
        this.cs = colorSpace;
        this.setData(colorSpace.getICCProfile());
    }
}

