/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.avalon.framework.logger.Logger;
import org.apache.fop.apps.FOPException;
import org.apache.fop.datatypes.ColorType;
import org.apache.fop.image.FopImage;
import org.apache.fop.image.FopImageException;
import org.apache.fop.image.ImageArea;
import org.apache.fop.layout.Area;
import org.apache.fop.layout.AreaContainer;
import org.apache.fop.layout.BlockArea;
import org.apache.fop.layout.BodyAreaContainer;
import org.apache.fop.layout.Box;
import org.apache.fop.layout.DisplaySpace;
import org.apache.fop.layout.FontInfo;
import org.apache.fop.layout.FontState;
import org.apache.fop.layout.LineArea;
import org.apache.fop.layout.Page;
import org.apache.fop.layout.SpanArea;
import org.apache.fop.layout.inline.ForeignObjectArea;
import org.apache.fop.layout.inline.InlineArea;
import org.apache.fop.layout.inline.InlineSpace;
import org.apache.fop.layout.inline.LeaderArea;
import org.apache.fop.layout.inline.WordArea;
import org.apache.fop.render.Renderer;
import org.apache.fop.svg.SVGArea;

public abstract class AbstractRenderer
implements Renderer {
    protected Logger log;
    protected int currentYPosition = 0;
    protected int currentXPosition = 0;
    protected int currentAreaContainerXPosition = 0;

    protected abstract void addFilledRect(int var1, int var2, int var3, int var4, ColorType var5);

    /*
     * Unable to fully structure code
     */
    protected void doBackground(Area var1_1, int var2_2, int var3_3, int var4_4, int var5_5) {
        block19: {
            if (var5_5 == 0 || var4_4 == 0) {
                return;
            }
            var6_6 = var1_1.getBackground();
            if (var6_6 == null) {
                return;
            }
            if (var6_6.backColor.alpha() == 0.0f) {
                this.addFilledRect(var2_2, var3_3, var4_4, -var5_5, var6_6.backColor);
            }
            if (var6_6.backImage == null) break block19;
            try {
                var7_7 = var6_6.backImage.getWidth() * 1000;
                var8_8 = var6_6.backImage.getHeight() * 1000;
            }
            catch (FopImageException var9_9) {
                this.log.error("Error obtaining bg image width and height", (Throwable)var9_9);
                return;
            }
            var9_10 = var2_2;
            var10_11 = var3_3;
            var11_12 = var2_2 + var4_4;
            var12_13 = var3_3 - var5_5;
            var13_14 = var4_4 % var7_7;
            var14_15 = var5_5 % var8_8;
            var15_16 = true;
            var16_17 = true;
            switch (var6_6.backRepeat) {
                case 64: {
                    var16_17 = false;
                    break;
                }
                case 65: {
                    var15_16 = false;
                    break;
                }
                case 48: {
                    var15_16 = false;
                    var16_17 = false;
                    break;
                }
                default: {
                    this.log.error("Ignoring invalid background-repeat property");
                }
                case 35: 
                case 63: 
            }
            var17_18 = var1_1.getFontState();
            ** GOTO lbl57
            {
                if (var9_10 + var7_7 <= var11_12) {
                    if (var10_11 - var8_8 >= var12_13) {
                        this.drawImageScaled(var9_10, var10_11, var7_7, var8_8, var6_6.backImage, var17_18);
                    } else {
                        this.drawImageClipped(var9_10, var10_11, 0, 0, var7_7, var14_15, var6_6.backImage, var17_18);
                    }
                } else if (var10_11 - var8_8 >= var12_13) {
                    this.drawImageClipped(var9_10, var10_11, 0, 0, var13_14, var8_8, var6_6.backImage, var17_18);
                } else {
                    this.drawImageClipped(var9_10, var10_11, 0, 0, var13_14, var14_15, var6_6.backImage, var17_18);
                }
                if (!var15_16) ** GOTO lbl54
                var9_10 += var7_7;
                do {
                    if (var9_10 < var11_12) continue block8;
lbl54:
                    // 2 sources

                    var9_10 = var2_2;
                    if (!var16_17) break block8;
                    var10_11 -= var8_8;
lbl57:
                    // 2 sources

                } while (var10_11 > var12_13);
            }
        }
    }

    protected abstract void doFrame(Area var1);

    protected void drawImage(int n, int n2, FopImage fopImage, FontState fontState) {
        int n3;
        int n4;
        try {
            n4 = fopImage.getWidth() * 1000;
            n3 = fopImage.getHeight() * 1000;
        }
        catch (FopImageException fopImageException) {
            this.log.error("Failed to obtain the image width and height", (Throwable)fopImageException);
            return;
        }
        this.drawImageScaled(n, n2, n4, n3, fopImage, fontState);
    }

    protected abstract void drawImageClipped(int var1, int var2, int var3, int var4, int var5, int var6, FopImage var7, FontState var8);

    protected abstract void drawImageScaled(int var1, int var2, int var3, int var4, FopImage var5, FontState var6);

    public abstract void render(Page var1, OutputStream var2) throws IOException, FOPException;

    public void renderAreaContainer(AreaContainer areaContainer) {
        int n = this.currentYPosition;
        int n2 = this.currentAreaContainerXPosition;
        if (areaContainer.getPosition() == 1) {
            this.currentYPosition = areaContainer.getYPosition();
            this.currentAreaContainerXPosition = areaContainer.getXPosition();
        } else if (areaContainer.getPosition() == 62) {
            this.currentYPosition -= areaContainer.getYPosition();
            this.currentAreaContainerXPosition += areaContainer.getXPosition();
        } else if (areaContainer.getPosition() == 77) {
            this.currentYPosition -= areaContainer.getPaddingTop() + areaContainer.getBorderTopWidth();
        }
        this.currentXPosition = this.currentAreaContainerXPosition;
        this.doFrame(areaContainer);
        Enumeration enumeration = areaContainer.getChildren().elements();
        while (enumeration.hasMoreElements()) {
            Box box = (Box)enumeration.nextElement();
            box.render(this);
        }
        this.currentYPosition = n;
        this.currentAreaContainerXPosition = n2;
        if (areaContainer.getPosition() == 77) {
            this.currentYPosition -= areaContainer.getHeight();
        }
    }

    public void renderBlockArea(BlockArea blockArea) {
        this.currentYPosition -= blockArea.getPaddingTop() + blockArea.getBorderTopWidth();
        this.doFrame(blockArea);
        Enumeration enumeration = blockArea.getChildren().elements();
        while (enumeration.hasMoreElements()) {
            Box box = (Box)enumeration.nextElement();
            box.render(this);
        }
        this.currentYPosition -= blockArea.getPaddingBottom() + blockArea.getBorderBottomWidth();
    }

    public void renderBodyAreaContainer(BodyAreaContainer bodyAreaContainer) {
        int n = this.currentYPosition;
        int n2 = this.currentAreaContainerXPosition;
        if (bodyAreaContainer.getPosition() == 1) {
            this.currentYPosition = bodyAreaContainer.getYPosition();
            this.currentAreaContainerXPosition = bodyAreaContainer.getXPosition();
        } else if (bodyAreaContainer.getPosition() == 62) {
            this.currentYPosition -= bodyAreaContainer.getYPosition();
            this.currentAreaContainerXPosition += bodyAreaContainer.getXPosition();
        }
        this.currentXPosition = this.currentAreaContainerXPosition;
        int n3 = this.currentAreaContainerXPosition;
        int n4 = this.currentYPosition;
        int n5 = bodyAreaContainer.getAllocationWidth();
        int n6 = bodyAreaContainer.getMaxHeight();
        this.doBackground(bodyAreaContainer, n3, n4, n5, n6);
        this.renderAreaContainer(bodyAreaContainer.getBeforeFloatReferenceArea());
        this.renderAreaContainer(bodyAreaContainer.getFootnoteReferenceArea());
        Enumeration enumeration = bodyAreaContainer.getMainReferenceArea().getChildren().elements();
        while (enumeration.hasMoreElements()) {
            Box box = (Box)enumeration.nextElement();
            box.render(this);
        }
        if (bodyAreaContainer.getPosition() != 77) {
            this.currentYPosition = n;
            this.currentAreaContainerXPosition = n2;
        } else {
            this.currentYPosition -= bodyAreaContainer.getHeight();
        }
    }

    public abstract void renderDisplaySpace(DisplaySpace var1);

    public abstract void renderForeignObjectArea(ForeignObjectArea var1);

    public void renderImageArea(ImageArea imageArea) {
        int n = this.currentXPosition + imageArea.getXOffset();
        int n2 = this.currentYPosition;
        int n3 = imageArea.getContentWidth();
        int n4 = imageArea.getHeight();
        this.currentYPosition -= n4;
        FopImage fopImage = imageArea.getImage();
        if (fopImage == null) {
            this.log.error("Error while loading image : area.getImage() is null");
        } else {
            this.drawImageScaled(n, n2, n3, n4, fopImage, imageArea.getFontState());
        }
        this.currentXPosition += n3;
    }

    public abstract void renderInlineSpace(InlineSpace var1);

    public abstract void renderLeaderArea(LeaderArea var1);

    public void renderLineArea(LineArea lineArea) {
        int n = this.currentAreaContainerXPosition + lineArea.getStartIndent();
        int n2 = this.currentYPosition;
        int n3 = lineArea.getContentWidth();
        int n4 = lineArea.getHeight();
        this.currentYPosition -= lineArea.getPlacementOffset();
        this.currentXPosition = n;
        int n5 = this.currentYPosition;
        Enumeration enumeration = lineArea.getChildren().elements();
        while (enumeration.hasMoreElements()) {
            Box box = (Box)enumeration.nextElement();
            if (box instanceof InlineArea) {
                InlineArea inlineArea = (InlineArea)box;
                this.currentYPosition = n2 - inlineArea.getYOffset();
            } else {
                this.currentYPosition = n2 - lineArea.getPlacementOffset();
            }
            box.render(this);
        }
        this.currentYPosition = n2 - n4;
        this.currentXPosition = n;
    }

    public abstract void renderPage(Page var1);

    public abstract void renderSVGArea(SVGArea var1);

    public void renderSpanArea(SpanArea spanArea) {
        Enumeration enumeration = spanArea.getChildren().elements();
        while (enumeration.hasMoreElements()) {
            Box box = (Box)enumeration.nextElement();
            box.render(this);
        }
    }

    public abstract void renderWordArea(WordArea var1);

    public void setLogger(Logger logger) {
        this.log = logger;
    }

    public abstract void setOptions(Hashtable var1);

    public abstract void setProducer(String var1);

    public abstract void setupFontInfo(FontInfo var1) throws FOPException;

    public abstract void startRenderer(OutputStream var1) throws IOException;

    public abstract void stopRenderer(OutputStream var1) throws IOException;
}

