/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.fop.apps.FOPException;
import org.apache.fop.datatypes.ColorType;
import org.apache.fop.datatypes.IDReferences;
import org.apache.fop.layout.Area;
import org.apache.fop.layout.BlockArea;
import org.apache.fop.layout.BorderAndPadding;
import org.apache.fop.layout.DisplaySpace;
import org.apache.fop.layout.FontInfo;
import org.apache.fop.layout.Page;
import org.apache.fop.layout.inline.ForeignObjectArea;
import org.apache.fop.layout.inline.InlineSpace;
import org.apache.fop.layout.inline.LeaderArea;
import org.apache.fop.layout.inline.WordArea;
import org.apache.fop.pdf.PDFColor;
import org.apache.fop.pdf.PDFPathPaint;
import org.apache.fop.render.AbstractRenderer;
import org.apache.fop.render.pdf.FontSetup;
import org.apache.fop.svg.SVGArea;

public abstract class PrintRenderer
extends AbstractRenderer {
    protected String currentFontName;
    protected int currentFontSize;
    protected PDFPathPaint currentStroke = null;
    protected PDFPathPaint currentFill = null;
    protected int prevUnderlineXEndPos;
    protected int prevUnderlineYEndPos;
    protected int prevUnderlineSize;
    protected PDFColor prevUnderlineColor;
    protected int prevOverlineXEndPos;
    protected int prevOverlineYEndPos;
    protected int prevOverlineSize;
    protected PDFColor prevOverlineColor;
    protected int prevLineThroughXEndPos;
    protected int prevLineThroughYEndPos;
    protected int prevLineThroughSize;
    protected PDFColor prevLineThroughColor;
    protected FontInfo fontInfo;
    protected IDReferences idReferences;

    protected void addFilledRect(int n, int n2, int n3, int n4, ColorType colorType) {
        PDFColor pDFColor = new PDFColor(colorType);
        this.addRect(n, n2, n3, n4, pDFColor, pDFColor);
    }

    protected void addFilledRect(int n, int n2, int n3, int n4, PDFPathPaint pDFPathPaint) {
        this.addRect(n, n2, n3, n4, pDFPathPaint, pDFPathPaint);
    }

    protected abstract void addLine(int var1, int var2, int var3, int var4, int var5, int var6, PDFPathPaint var7);

    protected abstract void addLine(int var1, int var2, int var3, int var4, int var5, PDFPathPaint var6);

    protected abstract void addRect(int var1, int var2, int var3, int var4, PDFPathPaint var5);

    protected abstract void addRect(int var1, int var2, int var3, int var4, PDFPathPaint var5, PDFPathPaint var6);

    protected void addWordLines(WordArea wordArea, int n, int n2, int n3, PDFColor pDFColor) {
        int n4;
        if (wordArea.getUnderlined()) {
            n4 = n2 - n3 / 10;
            this.addLine(n, n4, n + wordArea.getContentWidth(), n4, n3 / 14, pDFColor);
            this.prevUnderlineXEndPos = n + wordArea.getContentWidth();
            this.prevUnderlineYEndPos = n4;
            this.prevUnderlineSize = n3 / 14;
            this.prevUnderlineColor = pDFColor;
        }
        if (wordArea.getOverlined()) {
            n4 = n2 + wordArea.getFontState().getAscender() + n3 / 10;
            this.addLine(n, n4, n + wordArea.getContentWidth(), n4, n3 / 14, pDFColor);
            this.prevOverlineXEndPos = n + wordArea.getContentWidth();
            this.prevOverlineYEndPos = n4;
            this.prevOverlineSize = n3 / 14;
            this.prevOverlineColor = pDFColor;
        }
        if (wordArea.getLineThrough()) {
            n4 = n2 + wordArea.getFontState().getAscender() * 3 / 8;
            this.addLine(n, n4, n + wordArea.getContentWidth(), n4, n3 / 14, pDFColor);
            this.prevLineThroughXEndPos = n + wordArea.getContentWidth();
            this.prevLineThroughYEndPos = n4;
            this.prevLineThroughSize = n3 / 14;
            this.prevLineThroughColor = pDFColor;
        }
    }

    protected void doFrame(Area area) {
        int n = this.currentAreaContainerXPosition;
        int n2 = area.getContentWidth();
        if (area instanceof BlockArea) {
            n += ((BlockArea)area).getStartIndent();
        }
        int n3 = area.getContentHeight();
        int n4 = this.currentYPosition;
        n2 = n2 + area.getPaddingLeft() + area.getPaddingRight();
        n3 = n3 + area.getPaddingTop() + area.getPaddingBottom();
        this.doBackground(area, n -= area.getPaddingLeft(), n4 += area.getPaddingTop(), n2, n3);
        BorderAndPadding borderAndPadding = area.getBorderAndPadding();
        int n5 = area.getBorderLeftWidth();
        int n6 = area.getBorderRightWidth();
        int n7 = area.getBorderTopWidth();
        int n8 = area.getBorderBottomWidth();
        if (n7 != 0) {
            this.addFilledRect(n, n4, n2, n7, new PDFColor(borderAndPadding.getBorderColor(0)));
        }
        if (n5 != 0) {
            this.addFilledRect(n - n5, n4 - n3 - n8, n5, n3 + n7 + n8, new PDFColor(borderAndPadding.getBorderColor(3)));
        }
        if (n6 != 0) {
            this.addFilledRect(n + n2, n4 - n3 - n8, n6, n3 + n7 + n8, new PDFColor(borderAndPadding.getBorderColor(1)));
        }
        if (n8 != 0) {
            this.addFilledRect(n, n4 - n3 - n8, n2, n8, new PDFColor(borderAndPadding.getBorderColor(2)));
        }
    }

    public void renderDisplaySpace(DisplaySpace displaySpace) {
        int n = displaySpace.getSize();
        this.currentYPosition -= n;
    }

    public abstract void renderForeignObjectArea(ForeignObjectArea var1);

    public void renderInlineSpace(InlineSpace inlineSpace) {
        this.currentXPosition += inlineSpace.getSize();
        if (inlineSpace.getUnderlined() && this.prevUnderlineColor != null) {
            this.addLine(this.prevUnderlineXEndPos, this.prevUnderlineYEndPos, this.prevUnderlineXEndPos + inlineSpace.getSize(), this.prevUnderlineYEndPos, this.prevUnderlineSize, this.prevUnderlineColor);
            this.prevUnderlineXEndPos += inlineSpace.getSize();
        }
        if (inlineSpace.getOverlined() && this.prevOverlineColor != null) {
            this.addLine(this.prevOverlineXEndPos, this.prevOverlineYEndPos, this.prevOverlineXEndPos + inlineSpace.getSize(), this.prevOverlineYEndPos, this.prevOverlineSize, this.prevOverlineColor);
            this.prevOverlineXEndPos += inlineSpace.getSize();
        }
        if (inlineSpace.getLineThrough() && this.prevLineThroughColor != null) {
            this.addLine(this.prevLineThroughXEndPos, this.prevLineThroughYEndPos, this.prevLineThroughXEndPos + inlineSpace.getSize(), this.prevLineThroughYEndPos, this.prevLineThroughSize, this.prevLineThroughColor);
            this.prevLineThroughXEndPos += inlineSpace.getSize();
        }
    }

    public void renderLeaderArea(LeaderArea leaderArea) {
        int n = this.currentXPosition;
        int n2 = this.currentYPosition;
        int n3 = leaderArea.getContentWidth();
        int n4 = leaderArea.getHeight();
        int n5 = leaderArea.getRuleThickness();
        int n6 = leaderArea.getRuleStyle();
        if (n5 != 0) {
            switch (n6) {
                case 21: {
                    this.addLine(n, n2, n + n3, n2, n5 / 3, n6, new PDFColor(leaderArea.getRed(), leaderArea.getGreen(), leaderArea.getBlue()));
                    this.addLine(n, n2 + 2 * n5 / 3, n + n3, n2 + 2 * n5 / 3, n5 / 3, n6, new PDFColor(leaderArea.getRed(), leaderArea.getGreen(), leaderArea.getBlue()));
                    break;
                }
                case 33: {
                    this.addLine(n, n2, n + n3, n2, n5 / 2, n6, new PDFColor(leaderArea.getRed(), leaderArea.getGreen(), leaderArea.getBlue()));
                    this.addLine(n, n2 + n5 / 2, n + n3, n2 + n5 / 2, n5 / 2, n6, new PDFColor(255, 255, 255));
                    break;
                }
                case 68: {
                    this.addLine(n, n2, n + n3, n2, n5 / 2, n6, new PDFColor(255, 255, 255));
                    this.addLine(n, n2 + n5 / 2, n + n3, n2 + n5 / 2, n5 / 2, n6, new PDFColor(leaderArea.getRed(), leaderArea.getGreen(), leaderArea.getBlue()));
                    break;
                }
                default: {
                    this.addLine(n, n2, n + n3, n2, n5, n6, new PDFColor(leaderArea.getRed(), leaderArea.getGreen(), leaderArea.getBlue()));
                }
            }
            this.currentXPosition += leaderArea.getContentWidth();
            this.currentYPosition += n5;
        }
    }

    public abstract void renderPage(Page var1);

    public abstract void renderSVGArea(SVGArea var1);

    public abstract void renderWordArea(WordArea var1);

    public abstract void setProducer(String var1);

    public void setupFontInfo(FontInfo fontInfo) throws FOPException {
        this.fontInfo = fontInfo;
        FontSetup.setup(fontInfo);
    }

    public void startRenderer(OutputStream outputStream) throws IOException {
    }

    public void stopRenderer(OutputStream outputStream) throws IOException {
        this.idReferences = null;
        this.currentFontName = "";
        this.currentStroke = null;
        this.currentFill = null;
        this.prevUnderlineColor = null;
        this.prevOverlineColor = null;
        this.prevLineThroughColor = null;
        this.fontInfo = null;
        this.idReferences = null;
    }
}

