/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.xml;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.avalon.framework.logger.Logger;
import org.apache.fop.apps.FOPException;
import org.apache.fop.fo.flow.Marker;
import org.apache.fop.image.FopImage;
import org.apache.fop.image.ImageArea;
import org.apache.fop.layout.AreaContainer;
import org.apache.fop.layout.BlockArea;
import org.apache.fop.layout.BodyAreaContainer;
import org.apache.fop.layout.Box;
import org.apache.fop.layout.DisplaySpace;
import org.apache.fop.layout.FontInfo;
import org.apache.fop.layout.FontState;
import org.apache.fop.layout.LineArea;
import org.apache.fop.layout.Page;
import org.apache.fop.layout.SpanArea;
import org.apache.fop.layout.inline.ForeignObjectArea;
import org.apache.fop.layout.inline.InlineArea;
import org.apache.fop.layout.inline.InlineSpace;
import org.apache.fop.layout.inline.LeaderArea;
import org.apache.fop.layout.inline.WordArea;
import org.apache.fop.render.Renderer;
import org.apache.fop.render.pdf.FontSetup;
import org.apache.fop.svg.SVGArea;

public class XMLRenderer
implements Renderer {
    protected Logger log;
    protected int indent = 0;
    protected String producer;
    protected PrintWriter writer;
    protected Hashtable options;
    private boolean consistentOutput = false;

    protected void drawImageClipped(int n, int n2, int n3, int n4, int n5, int n6, FopImage fopImage, FontState fontState) {
    }

    protected void drawImageScaled(int n, int n2, int n3, int n4, FopImage fopImage, FontState fontState) {
    }

    private boolean isCoarseXml() {
        return (Boolean)this.options.get("fineDetail");
    }

    public void render(Page page, OutputStream outputStream) throws IOException {
        this.renderPage(page);
    }

    public void renderAreaContainer(AreaContainer areaContainer) {
        this.writeStartTag("<AreaContainer name=\"" + areaContainer.getAreaName() + "\">");
        Enumeration enumeration = areaContainer.getChildren().elements();
        while (enumeration.hasMoreElements()) {
            Box box = (Box)enumeration.nextElement();
            box.render(this);
        }
        this.writeEndTag("</AreaContainer>");
    }

    public void renderBlockArea(BlockArea blockArea) {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<BlockArea start-indent=\"" + blockArea.getStartIndent() + "\"");
        stringBuffer.append(" end-indent=\"" + blockArea.getEndIndent() + "\"");
        stringBuffer.append("\nis-first=\"" + blockArea.isFirst() + "\"");
        stringBuffer.append(" is-last=\"" + blockArea.isLast() + "\"");
        if (blockArea.getGeneratedBy() != null) {
            stringBuffer.append(" generated-by=\"" + blockArea.getGeneratedBy().getName() + "//");
        }
        if (this.consistentOutput) {
            stringBuffer.append(String.valueOf(String.valueOf(blockArea.getGeneratedBy().getClass())) + "\"");
        } else {
            stringBuffer.append(String.valueOf(String.valueOf(blockArea.getGeneratedBy())) + "\"");
        }
        stringBuffer.append(">");
        this.writeStartTag(stringBuffer.toString());
        Vector vector = blockArea.getMarkers();
        if (!vector.isEmpty()) {
            this.writeStartTag("<Markers>");
            int n = 0;
            while (n < vector.size()) {
                object = (Marker)vector.elementAt(n);
                StringBuffer stringBuffer2 = new StringBuffer();
                stringBuffer2.append("<Marker marker-class-name=\"" + ((Marker)object).getMarkerClassName() + "\"");
                stringBuffer2.append(" RegisteredArea=\"" + ((Marker)object).getRegistryArea() + "\"");
                stringBuffer2.append("/>");
                this.writeEmptyElementTag(stringBuffer2.toString());
                ++n;
            }
            this.writeEndTag("</Markers>");
        }
        Enumeration enumeration = blockArea.getChildren().elements();
        while (enumeration.hasMoreElements()) {
            object = (Box)enumeration.nextElement();
            ((Box)object).render(this);
        }
        this.writeEndTag("</BlockArea>");
    }

    public void renderBodyAreaContainer(BodyAreaContainer bodyAreaContainer) {
        this.writeStartTag("<BodyAreaContainer>");
        Enumeration enumeration = bodyAreaContainer.getChildren().elements();
        while (enumeration.hasMoreElements()) {
            Box box = (Box)enumeration.nextElement();
            box.render(this);
        }
        this.writeEndTag("</BodyAreaContainer>");
    }

    public void renderDisplaySpace(DisplaySpace displaySpace) {
        if (!this.isCoarseXml()) {
            this.writeEmptyElementTag("<DisplaySpace size=\"" + displaySpace.getSize() + "\"/>");
        }
    }

    public void renderForeignObjectArea(ForeignObjectArea foreignObjectArea) {
        foreignObjectArea.getObject().render(this);
    }

    public void renderImageArea(ImageArea imageArea) {
        this.writeEmptyElementTag("<ImageArea/>");
    }

    public void renderInlineArea(InlineArea inlineArea) {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<InlineArea");
        stringBuffer.append("\nis-first=\"" + inlineArea.isFirst() + "\"");
        stringBuffer.append(" is-last=\"" + inlineArea.isLast() + "\"");
        if (inlineArea.getGeneratedBy() != null) {
            stringBuffer.append(" generated-by=\"" + inlineArea.getGeneratedBy().getName() + "//" + inlineArea.getGeneratedBy() + "\"");
        }
        stringBuffer.append(">");
        this.writeStartTag(stringBuffer.toString());
        Vector vector = inlineArea.getMarkers();
        if (!vector.isEmpty()) {
            this.writeStartTag("<Markers>");
            int n = 0;
            while (n < vector.size()) {
                object = (Marker)vector.elementAt(n);
                StringBuffer stringBuffer2 = new StringBuffer();
                stringBuffer2.append("<Marker marker-class-name=\"" + ((Marker)object).getMarkerClassName() + "\"");
                stringBuffer2.append(" RegisteredArea=\"" + ((Marker)object).getRegistryArea() + "\"");
                stringBuffer2.append("/>");
                this.writeEmptyElementTag(stringBuffer2.toString());
                ++n;
            }
            this.writeEndTag("</Markers>");
        }
        Enumeration enumeration = inlineArea.getChildren().elements();
        while (enumeration.hasMoreElements()) {
            object = (Box)enumeration.nextElement();
            ((Box)object).render(this);
        }
        this.writeEndTag("</InlineArea>");
    }

    public void renderInlineSpace(InlineSpace inlineSpace) {
        if (!this.isCoarseXml()) {
            this.writeEmptyElementTag("<InlineSpace size=\"" + inlineSpace.getSize() + "\"/>");
        } else {
            this.writer.write(" ");
        }
    }

    public void renderLeaderArea(LeaderArea leaderArea) {
        if (this.isCoarseXml()) {
            return;
        }
        String string = "";
        switch (leaderArea.getLeaderPattern()) {
            case 75: {
                string = "space";
                break;
            }
            case 70: {
                string = "rule";
                break;
            }
            case 19: {
                string = "dots";
                break;
            }
            case 88: {
                string = "use-content";
                break;
            }
        }
        this.writeEmptyElementTag("<Leader leader-pattern=\"" + string + " leader-length=\"" + leaderArea.getLeaderLength() + "\" rule-thickness=\"" + leaderArea.getRuleThickness() + "\" rule-style=\"" + leaderArea.getRuleStyle() + "\" red=\"" + leaderArea.getRed() + "\" green=\"" + leaderArea.getGreen() + "\" blue=\"" + leaderArea.getBlue() + "\"/>");
    }

    public void renderLineArea(LineArea lineArea) {
        Object object;
        if (!this.isCoarseXml()) {
            object = lineArea.getFontState().getFontWeight();
            this.writeStartTag("<LineArea font-weight=\"" + (String)object + "\">");
        }
        object = lineArea.getChildren().elements();
        while (object.hasMoreElements()) {
            Box box = (Box)object.nextElement();
            box.render(this);
        }
        if (!this.isCoarseXml()) {
            this.writeEndTag("</LineArea>");
        } else {
            this.writer.write("\n");
        }
    }

    public void renderPage(Page page) {
        this.writeStartTag("<Page number=\"" + page.getFormattedNumber() + "\">");
        BodyAreaContainer bodyAreaContainer = page.getBody();
        AreaContainer areaContainer = page.getBefore();
        AreaContainer areaContainer2 = page.getAfter();
        if (areaContainer != null) {
            this.renderAreaContainer(areaContainer);
        }
        this.renderBodyAreaContainer(bodyAreaContainer);
        if (areaContainer2 != null) {
            this.renderAreaContainer(areaContainer2);
        }
        this.writeEndTag("</Page>");
    }

    public void renderSVGArea(SVGArea sVGArea) {
        this.writeEmptyElementTag("<SVG/>");
    }

    public void renderSpanArea(SpanArea spanArea) {
        this.writeStartTag("<SpanArea>");
        Enumeration enumeration = spanArea.getChildren().elements();
        while (enumeration.hasMoreElements()) {
            Box box = (Box)enumeration.nextElement();
            box.render(this);
        }
        this.writeEndTag("</SpanArea>");
    }

    public void renderWordArea(WordArea wordArea) {
        String string = wordArea.getFontState().getFontWeight();
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = wordArea.getText();
        int n = string2.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string2.charAt(n2);
            stringBuffer = c > '\u007f' ? stringBuffer.append("&#" + c + ";") : stringBuffer.append(c);
            ++n2;
        }
        if (!this.isCoarseXml()) {
            this.writeElement("<WordArea font-weight=\"" + string + "\" red=\"" + wordArea.getRed() + "\" green=\"" + wordArea.getGreen() + "\" blue=\"" + wordArea.getBlue() + "\" width=\"" + wordArea.getContentWidth() + "\">" + stringBuffer.toString() + "</WordArea>");
        } else {
            this.writer.write(stringBuffer.toString());
        }
    }

    public void setLogger(Logger logger) {
        this.log = logger;
    }

    public void setOptions(Hashtable hashtable) {
        this.options = hashtable;
        Boolean bl = (Boolean)hashtable.get("consistentOutput");
        if (bl != null) {
            this.consistentOutput = bl;
        }
    }

    public void setProducer(String string) {
        this.producer = string;
    }

    public void setupFontInfo(FontInfo fontInfo) throws FOPException {
        FontSetup.setup(fontInfo);
    }

    public void startRenderer(OutputStream outputStream) throws IOException {
        this.log.debug("rendering areas to XML");
        this.writer = new PrintWriter(outputStream);
        this.writer.write("<?xml version=\"1.0\"?>\n<!-- produced by " + this.producer + " -->\n");
        this.writeStartTag("<AreaTree>");
    }

    public void stopRenderer(OutputStream outputStream) throws IOException {
        this.writeEndTag("</AreaTree>");
        this.writer.flush();
        this.log.debug("written out XML");
    }

    protected void writeElement(String string) {
        this.writeIndent();
        this.writer.write(String.valueOf(string) + "\n");
    }

    protected void writeEmptyElementTag(String string) {
        this.writeIndent();
        this.writer.write(String.valueOf(string) + "\n");
    }

    protected void writeEndTag(String string) {
        --this.indent;
        this.writeIndent();
        this.writer.write(String.valueOf(string) + "\n");
    }

    protected void writeIndent() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.indent) {
            stringBuffer = stringBuffer.append("  ");
            ++n;
        }
        this.writer.write(stringBuffer.toString());
    }

    protected void writeStartTag(String string) {
        this.writeIndent();
        this.writer.write(String.valueOf(string) + "\n");
        ++this.indent;
    }
}

