/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.svg;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfigTemplate;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferInt;
import java.awt.image.ImageObserver;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.io.StringWriter;
import java.text.AttributedCharacterIterator;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import org.apache.batik.ext.awt.g2d.AbstractGraphics2D;
import org.apache.batik.ext.awt.g2d.GraphicContext;
import org.apache.fop.apps.FOPException;
import org.apache.fop.datatypes.ColorSpace;
import org.apache.fop.image.FopImage;
import org.apache.fop.image.FopImageException;
import org.apache.fop.image.JpegImage;
import org.apache.fop.layout.FontState;
import org.apache.fop.pdf.PDFAnnotList;
import org.apache.fop.pdf.PDFColor;
import org.apache.fop.pdf.PDFDocument;
import org.apache.fop.pdf.PDFFilter;
import org.apache.fop.pdf.PDFFunction;
import org.apache.fop.pdf.PDFNumber;
import org.apache.fop.pdf.PDFPattern;
import org.apache.fop.render.pdf.CIDFont;
import org.apache.fop.render.pdf.fonts.LazyFont;

public class PDFGraphics2D
extends AbstractGraphics2D {
    boolean standalone = false;
    protected PDFDocument pdfDoc;
    PDFAnnotList currentAnnotList = null;
    protected FontState fontState;
    protected FontState ovFontState = null;
    StringWriter currentStream = new StringWriter();
    protected String currentFontName;
    protected int currentFontSize;
    protected int currentYPosition = 0;
    protected int currentXPosition = 0;
    PDFColor currentColour = new PDFColor(0, 0, 0);
    private HashMap imageInfos = new HashMap();
    private Graphics2D fmg;

    public PDFGraphics2D(PDFGraphics2D pDFGraphics2D) {
        super((AbstractGraphics2D)pDFGraphics2D);
        BufferedImage bufferedImage = new BufferedImage(1, 1, 2);
        this.fmg = bufferedImage.createGraphics();
    }

    public PDFGraphics2D(boolean bl) {
        super(bl);
        BufferedImage bufferedImage = new BufferedImage(1, 1, 2);
        this.fmg = bufferedImage.createGraphics();
    }

    public PDFGraphics2D(boolean bl, FontState fontState, PDFDocument pDFDocument, String string, int n, int n2, int n3) {
        super(bl);
        BufferedImage bufferedImage = new BufferedImage(1, 1, 2);
        this.fmg = bufferedImage.createGraphics();
        this.pdfDoc = pDFDocument;
        this.currentFontName = string;
        this.currentFontSize = n;
        this.currentYPosition = n3;
        this.currentXPosition = n2;
        this.fontState = fontState;
    }

    public void addJpegImage(JpegImage jpegImage, float f, float f2, float f3, float f4) {
        int n = this.pdfDoc.addImage(jpegImage);
        AffineTransform affineTransform = this.getTransform();
        double[] dArray = new double[6];
        affineTransform.getMatrix(dArray);
        this.currentStream.write("q\n");
        Shape shape = this.getClip();
        this.writeClip(shape);
        this.currentStream.write(dArray[0] + " " + dArray[1] + " " + dArray[2] + " " + dArray[3] + " " + dArray[4] + " " + dArray[5] + " cm\n");
        this.currentStream.write(f3 + " 0 0 " + -f4 + " " + f + " " + (f2 + f4) + " cm\n" + "/Im" + n + " Do\nQ\n");
    }

    private void addKerning(StringWriter stringWriter, Integer n, Integer n2, Hashtable hashtable, String string, String string2) {
        Integer n3;
        Hashtable hashtable2 = (Hashtable)hashtable.get(n);
        if (hashtable2 != null && (n3 = (Integer)hashtable2.get(n2)) != null) {
            this.currentStream.write(String.valueOf(string2) + -n3.intValue() + " " + string);
        }
    }

    public void addLink(Shape shape, AffineTransform affineTransform, String string, int n) {
        if (this.currentAnnotList == null) {
            this.currentAnnotList = this.pdfDoc.makeAnnotList();
        }
        AffineTransform affineTransform2 = this.getTransform();
        Shape shape2 = affineTransform2.createTransformedShape(shape);
        shape2 = affineTransform.createTransformedShape(shape2);
        Rectangle rectangle = shape2.getBounds();
        rectangle.x *= 1000;
        rectangle.y *= 1000;
        rectangle.height = -rectangle.height * 1000;
        rectangle.width *= 1000;
        if (n != 1) {
            String string2 = "/XYZ " + string;
            this.currentAnnotList.addLink(this.pdfDoc.makeLinkCurrentPage(rectangle, string2));
        } else {
            this.currentAnnotList.addLink(this.pdfDoc.makeLink(rectangle, string, n));
        }
    }

    protected void applyColor(Color color, boolean bl) {
        Color color2 = color;
        if (color2.getColorSpace().getType() == 5) {
            this.currentColour = new PDFColor(color2.getRed(), color2.getGreen(), color2.getBlue());
            this.currentStream.write(this.currentColour.getColorSpaceOut(bl));
        } else if (color2.getColorSpace().getType() == 9) {
            float[] fArray = color2.getColorComponents(new float[3]);
            double[] dArray = new double[3];
            int n = 0;
            while (n < 3) {
                dArray[n] = fArray[n];
                ++n;
            }
            this.currentColour = new PDFColor(dArray[0], dArray[1], dArray[2], dArray[3]);
            this.currentStream.write(this.currentColour.getColorSpaceOut(bl));
        } else if (color2.getColorSpace().getType() == 12) {
            float[] fArray = color2.getColorComponents(new float[1]);
            double[] dArray = new double[1];
            int n = 0;
            while (n < 1) {
                dArray[n] = fArray[n];
                ++n;
            }
            this.currentStream.write(this.currentColour.getColorSpaceOut(bl));
        } else {
            System.err.println("Color Space not supported by PDFGraphics2D");
        }
    }

    protected void applyPaint(Paint paint, boolean bl) {
        if (paint instanceof GradientPaint) {
            GradientPaint gradientPaint = (GradientPaint)paint;
            Color color = gradientPaint.getColor1();
            Color color2 = gradientPaint.getColor2();
            Point2D point2D = gradientPaint.getPoint1();
            Point2D point2D2 = gradientPaint.getPoint2();
            boolean bl2 = gradientPaint.isCyclic();
            Vector<Double> vector = new Vector<Double>();
            vector.addElement(new Double(point2D.getX()));
            vector.addElement(new Double(point2D.getY()));
            vector.addElement(new Double(point2D2.getX()));
            vector.addElement(new Double(point2D2.getY()));
            Vector<Boolean> vector2 = new Vector<Boolean>();
            vector2.addElement(new Boolean(true));
            vector2.addElement(new Boolean(true));
            Vector<Double> vector3 = new Vector<Double>();
            vector3.addElement(new Double(0.0));
            vector3.addElement(new Double(1.0));
            Vector<Double> vector4 = new Vector<Double>();
            vector4.addElement(new Double(0.0));
            vector4.addElement(new Double(1.0));
            vector4.addElement(new Double(0.0));
            vector4.addElement(new Double(1.0));
            Vector<Double> vector5 = new Vector<Double>();
            vector5.addElement(new Double(0.0));
            vector5.addElement(new Double(1.0));
            Vector vector6 = new Vector();
            Vector<PDFColor> vector7 = new Vector<PDFColor>();
            PDFColor pDFColor = new PDFColor(color.getRed(), color.getGreen(), color.getBlue());
            vector7.addElement(pDFColor);
            PDFColor pDFColor2 = new PDFColor(color2.getRed(), color2.getGreen(), color2.getBlue());
            vector7.addElement(pDFColor2);
            PDFFunction pDFFunction = this.pdfDoc.makeFunction(2, vector3, null, pDFColor.getVector(), pDFColor2.getVector(), 1.0);
            ColorSpace colorSpace = new ColorSpace(ColorSpace.DEVICE_RGB);
            PDFPattern pDFPattern = this.pdfDoc.createGradient(false, colorSpace, vector7, null, vector);
            this.currentStream.write(pDFPattern.getColorSpaceOut(bl));
        }
    }

    protected void applyStroke(Stroke stroke) {
        if (stroke instanceof BasicStroke) {
            int n;
            BasicStroke basicStroke = (BasicStroke)stroke;
            float[] fArray = basicStroke.getDashArray();
            if (fArray != null) {
                this.currentStream.write("[");
                n = 0;
                while (n < fArray.length) {
                    if ((int)fArray[n] == 0) {
                        this.currentStream.write("1");
                    } else {
                        this.currentStream.write(String.valueOf((int)fArray[n]));
                    }
                    if (n < fArray.length - 1) {
                        this.currentStream.write(" ");
                    }
                    ++n;
                }
                this.currentStream.write("] ");
                float f = basicStroke.getDashPhase();
                this.currentStream.write(String.valueOf((int)f) + " d\n");
            }
            n = basicStroke.getEndCap();
            switch (n) {
                case 0: {
                    this.currentStream.write("0 J\n");
                    break;
                }
                case 1: {
                    this.currentStream.write("1 J\n");
                    break;
                }
                case 2: {
                    this.currentStream.write("2 J\n");
                    break;
                }
            }
            int n2 = basicStroke.getLineJoin();
            switch (n2) {
                case 0: {
                    this.currentStream.write("0 j\n");
                    break;
                }
                case 1: {
                    this.currentStream.write("1 j\n");
                    break;
                }
                case 2: {
                    this.currentStream.write("2 j\n");
                    break;
                }
            }
            float f = basicStroke.getLineWidth();
            this.currentStream.write(String.valueOf(PDFNumber.doubleOut(f)) + " w\n");
            float f2 = basicStroke.getMiterLimit();
            this.currentStream.write(String.valueOf(PDFNumber.doubleOut(f2)) + " M\n");
        }
    }

    public BufferedImage buildBufferedImage(Dimension dimension) {
        return new BufferedImage(dimension.width, dimension.height, 2);
    }

    public void copyArea(int n, int n2, int n3, int n4, int n5, int n6) {
        System.out.println("copyArea");
    }

    public Graphics create() {
        return new PDFGraphics2D(this);
    }

    public void dispose() {
        this.pdfDoc = null;
        this.fontState = null;
        this.currentStream = null;
        this.currentFontName = null;
        this.currentColour = null;
    }

    protected void doDrawing(boolean bl, boolean bl2, boolean bl3) {
        if (bl) {
            if (bl2) {
                if (bl3) {
                    this.currentStream.write("B*\n");
                } else {
                    this.currentStream.write("B\n");
                }
            } else if (bl3) {
                this.currentStream.write("f*\n");
            } else {
                this.currentStream.write("f\n");
            }
        } else {
            this.currentStream.write("S\n");
        }
    }

    public void draw(Shape shape) {
        Color color = this.getColor();
        if (color.getAlpha() == 0) {
            return;
        }
        this.currentStream.write("q\n");
        Shape shape2 = this.getClip();
        this.writeClip(shape2);
        this.applyColor(color, false);
        this.applyPaint(this.getPaint(), false);
        this.applyStroke(this.getStroke());
        AffineTransform affineTransform = this.getTransform();
        double[] dArray = new double[6];
        affineTransform.getMatrix(dArray);
        this.currentStream.write(String.valueOf(PDFNumber.doubleOut(dArray[0])) + " " + PDFNumber.doubleOut(dArray[1]) + " " + PDFNumber.doubleOut(dArray[2]) + " " + PDFNumber.doubleOut(dArray[3]) + " " + PDFNumber.doubleOut(dArray[4]) + " " + PDFNumber.doubleOut(dArray[5]) + " cm\n");
        PathIterator pathIterator = shape.getPathIterator(new AffineTransform());
        while (!pathIterator.isDone()) {
            double[] dArray2 = new double[6];
            int n = pathIterator.currentSegment(dArray2);
            switch (n) {
                case 3: {
                    this.currentStream.write(String.valueOf(PDFNumber.doubleOut(dArray2[0])) + " " + PDFNumber.doubleOut(dArray2[1]) + " " + PDFNumber.doubleOut(dArray2[2]) + " " + PDFNumber.doubleOut(dArray2[3]) + " " + PDFNumber.doubleOut(dArray2[4]) + " " + PDFNumber.doubleOut(dArray2[5]) + " c\n");
                    break;
                }
                case 1: {
                    this.currentStream.write(String.valueOf(PDFNumber.doubleOut(dArray2[0])) + " " + PDFNumber.doubleOut(dArray2[1]) + " l\n");
                    break;
                }
                case 0: {
                    this.currentStream.write(String.valueOf(PDFNumber.doubleOut(dArray2[0])) + " " + PDFNumber.doubleOut(dArray2[1]) + " m\n");
                    break;
                }
                case 2: {
                    this.currentStream.write(String.valueOf(PDFNumber.doubleOut(dArray2[0])) + " " + PDFNumber.doubleOut(dArray2[1]) + " " + PDFNumber.doubleOut(dArray2[2]) + " " + PDFNumber.doubleOut(dArray2[3]) + " y\n");
                    break;
                }
                case 4: {
                    this.currentStream.write("h\n");
                    break;
                }
            }
            pathIterator.next();
        }
        this.doDrawing(false, true, false);
        this.currentStream.write("Q\n");
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, ImageObserver imageObserver) {
        System.out.println("drawImage");
        return true;
    }

    public boolean drawImage(Image image, int n, int n2, ImageObserver imageObserver) {
        Object object;
        Object object2;
        Cloneable cloneable;
        ImageInfo imageInfo = (ImageInfo)this.imageInfos.get(image);
        if (imageInfo == null) {
            Object object3;
            imageInfo = new ImageInfo();
            imageInfo.width = image.getWidth(imageObserver);
            imageInfo.height = image.getHeight(imageObserver);
            if (imageInfo.width == -1 || imageInfo.height == -1) {
                return false;
            }
            cloneable = new Dimension(imageInfo.width * 3, imageInfo.height * 3);
            object2 = this.buildBufferedImage((Dimension)cloneable);
            object = ((BufferedImage)object2).createGraphics();
            ((Graphics2D)object).setComposite(AlphaComposite.SrcOver);
            ((Graphics2D)object).setBackground(new Color(1, 1, 1, 0));
            ((Graphics2D)object).setPaint(new Color(1, 1, 1, 0));
            ((Graphics)object).fillRect(0, 0, imageInfo.width * 3, imageInfo.height * 3);
            ((Graphics2D)object).clip(new Rectangle(0, 0, ((BufferedImage)object2).getWidth(), ((BufferedImage)object2).getHeight()));
            if (!((Graphics)object).drawImage(image, 0, 0, ((BufferedImage)object2).getWidth(), ((BufferedImage)object2).getHeight(), imageObserver)) {
                return false;
            }
            ((Graphics)object).dispose();
            byte[] byArray = new byte[((BufferedImage)object2).getWidth() * ((BufferedImage)object2).getHeight() * 3];
            byte[] byArray2 = new byte[((BufferedImage)object2).getWidth() * ((BufferedImage)object2).getHeight()];
            Raster raster = ((BufferedImage)object2).getData();
            DataBuffer dataBuffer = raster.getDataBuffer();
            int n3 = 0;
            boolean bl = false;
            switch (dataBuffer.getDataType()) {
                case 3: {
                    object3 = ((DataBufferInt)dataBuffer).getBankData();
                    int n4 = 0;
                    while (n4 < ((int[][])object3).length) {
                        int[] nArray = object3[n4];
                        int n5 = 0;
                        while (n5 < nArray.length) {
                            int n6 = nArray[n5];
                            int n7 = n6 >>> 24;
                            if (n7 != 255) {
                                int n8 = 255 - n7;
                                int n9 = (n7 << 16) / 255;
                                byArray[n3++] = (byte)(n8 + ((n6 >> 16 & 0xFF) * n9 >> 16));
                                byArray[n3++] = (byte)(n8 + ((n6 >> 8 & 0xFF) * n9 >> 16));
                                byArray[n3++] = (byte)(n8 + ((n6 & 0xFF) * n9 >> 16));
                            } else {
                                byArray[n3++] = (byte)(n6 >> 16 & 0xFF);
                                byArray[n3++] = (byte)(n6 >> 8 & 0xFF);
                                byArray[n3++] = (byte)(n6 & 0xFF);
                            }
                            ++n5;
                        }
                        ++n4;
                    }
                    break;
                }
            }
            try {
                object3 = new TempImage("TempImage:" + image.toString(), ((BufferedImage)object2).getWidth(), ((BufferedImage)object2).getHeight(), byArray, byArray2);
                imageInfo.xObjectNum = this.pdfDoc.addImage((FopImage)object3);
                this.imageInfos.put(image, imageInfo);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        cloneable = this.getTransform();
        object2 = new double[6];
        cloneable.getMatrix((double[])object2);
        this.currentStream.write("q\n");
        object = this.getClip();
        this.writeClip((Shape)object);
        this.currentStream.write(object2[0] + " " + object2[1] + " " + object2[2] + " " + (double)object2[3] + " " + (double)object2[4] + " " + (double)object2[5] + " cm\n");
        this.currentStream.write(imageInfo.width + " 0 0 " + -imageInfo.height + " " + n + " " + (n2 + imageInfo.height) + " cm\n" + "/Im" + imageInfo.xObjectNum + " Do\nQ\n");
        return true;
    }

    public void drawRenderableImage(RenderableImage renderableImage, AffineTransform affineTransform) {
        System.out.println("drawRenderableImage");
    }

    public void drawRenderedImage(RenderedImage renderedImage, AffineTransform affineTransform) {
        System.out.println("drawRenderedImage");
    }

    public void drawString(String string, float f, float f2) {
        Object object;
        Object object2;
        Object object3;
        if (this.ovFontState == null) {
            object3 = this.getFont();
            String string2 = ((Font)object3).getFamily();
            if (string2.equals("sanserif")) {
                string2 = "sans-serif";
            }
            int n = ((Font)object3).getSize();
            object2 = ((Font)object3).isItalic() ? "italic" : "normal";
            object = ((Font)object3).isBold() ? "bold" : "normal";
            try {
                this.fontState = new FontState(this.fontState.getFontInfo(), string2, (String)object2, (String)object, n * 1000, 0);
            }
            catch (FOPException fOPException) {
                fOPException.printStackTrace();
            }
        } else {
            this.fontState = this.ovFontState;
            this.ovFontState = null;
        }
        object3 = this.fontState.getFontName();
        int n = this.fontState.getFontSize() / 1000;
        if (!((String)object3).equals(this.currentFontName) || n != this.currentFontSize) {
            this.currentFontName = object3;
            this.currentFontSize = n;
            this.currentStream.write("/" + (String)object3 + " " + n + " Tf\n");
        }
        this.currentStream.write("q\n");
        Shape shape = this.getClip();
        this.writeClip(shape);
        object2 = this.getColor();
        this.applyColor((Color)object2, true);
        object2 = this.getBackground();
        this.applyColor((Color)object2, false);
        this.currentStream.write("BT\n");
        object = null;
        boolean bl = false;
        object = this.fontState.getKerning();
        if (object != null && !((Hashtable)object).isEmpty()) {
            bl = true;
        }
        boolean bl2 = false;
        org.apache.fop.render.pdf.Font font = (org.apache.fop.render.pdf.Font)this.fontState.getFontInfo().getFonts().get(object3);
        if (font instanceof LazyFont) {
            if (((LazyFont)font).getRealFont() instanceof CIDFont) {
                bl2 = true;
            }
        } else if (font instanceof CIDFont) {
            bl2 = true;
        }
        String string3 = bl2 ? "<" : "(";
        String string4 = bl2 ? "> " : ") ";
        AffineTransform affineTransform = this.getTransform();
        affineTransform.translate(f, f2);
        double[] dArray = new double[6];
        affineTransform.getMatrix(dArray);
        this.currentStream.write(String.valueOf(PDFNumber.doubleOut(dArray[0])) + " " + PDFNumber.doubleOut(dArray[1]) + " " + PDFNumber.doubleOut(dArray[2]) + " " + PDFNumber.doubleOut(dArray[3]) + " " + PDFNumber.doubleOut(dArray[4]) + " " + PDFNumber.doubleOut(dArray[5]) + " cm\n");
        this.currentStream.write("1 0 0 -1 0 0 Tm [" + string3);
        int n2 = string.length();
        int n3 = 0;
        while (n3 < n2) {
            char c = this.fontState.mapChar(string.charAt(n3));
            if (!bl2) {
                if (c > '\u007f') {
                    this.currentStream.write("\\");
                    this.currentStream.write(Integer.toOctalString(c));
                } else {
                    switch (c) {
                        case '(': 
                        case ')': 
                        case '\\': {
                            this.currentStream.write("\\");
                            break;
                        }
                    }
                    this.currentStream.write(c);
                }
            } else {
                this.currentStream.write(this.getUnicodeString(c));
            }
            if (bl && n3 + 1 < n2) {
                this.addKerning(this.currentStream, new Integer(c), new Integer(this.fontState.mapChar(string.charAt(n3 + 1))), (Hashtable)object, string3, string4);
            }
            ++n3;
        }
        this.currentStream.write(string4);
        this.currentStream.write("] TJ\n");
        this.currentStream.write("ET\n");
        this.currentStream.write("Q\n");
    }

    public void drawString(AttributedCharacterIterator attributedCharacterIterator, float f, float f2) {
        System.err.println("drawString(AttributedCharacterIterator)");
        Shape shape = this.getClip();
        this.writeClip(shape);
        Color color = this.getColor();
        this.applyColor(color, true);
        color = this.getBackground();
        this.applyColor(color, false);
        this.currentStream.write("BT\n");
        AffineTransform affineTransform = this.getTransform();
        affineTransform.translate(f, f2);
        double[] dArray = new double[6];
        affineTransform.getMatrix(dArray);
        char c = attributedCharacterIterator.first();
        while (c != '\uffff') {
            Map<AttributedCharacterIterator.Attribute, Object> map = attributedCharacterIterator.getAttributes();
            String string = this.fontState.getFontName();
            int n = this.fontState.getFontSize();
            if (!string.equals(this.currentFontName) || n != this.currentFontSize) {
                this.currentFontName = string;
                this.currentFontSize = n;
                this.currentStream.write("/" + string + " " + n / 1000 + " Tf\n");
            }
            this.currentStream.write(String.valueOf(PDFNumber.doubleOut(dArray[0])) + " " + PDFNumber.doubleOut(dArray[1]) + " " + PDFNumber.doubleOut(dArray[2]) + " " + PDFNumber.doubleOut(dArray[3]) + " " + PDFNumber.doubleOut(dArray[4]) + " " + PDFNumber.doubleOut(dArray[5]) + " Tm (" + c + ") Tj\n");
            c = attributedCharacterIterator.next();
        }
        this.currentStream.write("ET\n");
    }

    public void fill(Shape shape) {
        Color color = this.getBackground();
        if (color.getAlpha() == 0 && (color = this.getColor()).getAlpha() == 0) {
            return;
        }
        this.currentStream.write("q\n");
        Shape shape2 = this.getClip();
        this.writeClip(shape2);
        color = this.getColor();
        this.applyColor(color, true);
        color = this.getBackground();
        this.applyColor(color, false);
        this.applyPaint(this.getPaint(), true);
        PathIterator pathIterator = shape.getPathIterator(this.getTransform());
        while (!pathIterator.isDone()) {
            double[] dArray = new double[6];
            int n = pathIterator.currentSegment(dArray);
            switch (n) {
                case 3: {
                    this.currentStream.write(String.valueOf(PDFNumber.doubleOut(dArray[0])) + " " + PDFNumber.doubleOut(dArray[1]) + " " + PDFNumber.doubleOut(dArray[2]) + " " + PDFNumber.doubleOut(dArray[3]) + " " + PDFNumber.doubleOut(dArray[4]) + " " + PDFNumber.doubleOut(dArray[5]) + " c\n");
                    break;
                }
                case 1: {
                    this.currentStream.write(String.valueOf(PDFNumber.doubleOut(dArray[0])) + " " + PDFNumber.doubleOut(dArray[1]) + " l\n");
                    break;
                }
                case 0: {
                    this.currentStream.write(String.valueOf(PDFNumber.doubleOut(dArray[0])) + " " + PDFNumber.doubleOut(dArray[1]) + " m\n");
                    break;
                }
                case 2: {
                    this.currentStream.write(String.valueOf(PDFNumber.doubleOut(dArray[0])) + " " + PDFNumber.doubleOut(dArray[1]) + " " + PDFNumber.doubleOut(dArray[2]) + " " + PDFNumber.doubleOut(dArray[3]) + " y\n");
                    break;
                }
                case 4: {
                    this.currentStream.write("h\n");
                    break;
                }
            }
            pathIterator.next();
        }
        this.doDrawing(true, false, pathIterator.getWindingRule() == 0);
        this.currentStream.write("Q\n");
    }

    public PDFAnnotList getAnnotList() {
        return this.currentAnnotList;
    }

    public GraphicsConfiguration getDeviceConfiguration() {
        return new PDFGraphicsConfiguration();
    }

    public FontMetrics getFontMetrics(Font font) {
        return this.fmg.getFontMetrics(font);
    }

    public String getString() {
        return this.currentStream.toString();
    }

    private String getUnicodeString(char c) {
        StringBuffer stringBuffer = new StringBuffer(4);
        byte[] byArray = null;
        try {
            char[] cArray = new char[]{c};
            byArray = new String(cArray).getBytes("UnicodeBigUnmarked");
        }
        catch (Exception exception) {}
        int n = 0;
        while (n < byArray.length) {
            int n2 = byArray[n] < 0 ? 256 + byArray[n] : byArray[n];
            String string = Integer.toHexString(n2);
            stringBuffer = string.length() == 1 ? stringBuffer.append("0" + string) : stringBuffer.append(string);
            ++n;
        }
        return stringBuffer.toString();
    }

    public void setGraphicContext(GraphicContext graphicContext) {
        this.gc = graphicContext;
    }

    public void setOverrideFontState(FontState fontState) {
        this.ovFontState = fontState;
    }

    public void setXORMode(Color color) {
        System.out.println("setXORMode");
    }

    protected void writeClip(Shape shape) {
        if (shape == null) {
            return;
        }
        PathIterator pathIterator = shape.getPathIterator(this.getTransform());
        while (!pathIterator.isDone()) {
            double[] dArray = new double[6];
            int n = pathIterator.currentSegment(dArray);
            switch (n) {
                case 3: {
                    this.currentStream.write(String.valueOf(PDFNumber.doubleOut(dArray[0])) + " " + PDFNumber.doubleOut(dArray[1]) + " " + PDFNumber.doubleOut(dArray[2]) + " " + PDFNumber.doubleOut(dArray[3]) + " " + PDFNumber.doubleOut(dArray[4]) + " " + PDFNumber.doubleOut(dArray[5]) + " c\n");
                    break;
                }
                case 1: {
                    this.currentStream.write(String.valueOf(PDFNumber.doubleOut(dArray[0])) + " " + PDFNumber.doubleOut(dArray[1]) + " l\n");
                    break;
                }
                case 0: {
                    this.currentStream.write(String.valueOf(PDFNumber.doubleOut(dArray[0])) + " " + PDFNumber.doubleOut(dArray[1]) + " m\n");
                    break;
                }
                case 2: {
                    this.currentStream.write(String.valueOf(PDFNumber.doubleOut(dArray[0])) + " " + PDFNumber.doubleOut(dArray[1]) + " " + PDFNumber.doubleOut(dArray[2]) + " " + PDFNumber.doubleOut(dArray[3]) + " y\n");
                    break;
                }
                case 4: {
                    this.currentStream.write("h\n");
                    break;
                }
            }
            pathIterator.next();
        }
        this.currentStream.write("W\n");
        this.currentStream.write("n\n");
    }

    private static class ImageInfo {
        public int width;
        public int height;
        public int xObjectNum;

        ImageInfo() {
        }
    }

    class TempImage
    implements FopImage {
        int m_height;
        int m_width;
        int m_bitsPerPixel;
        ColorSpace m_colorSpace;
        int m_bitmapSiye;
        byte[] m_bitmaps;
        byte[] m_mask;
        PDFColor transparent = new PDFColor(255, 255, 255);
        String url;

        TempImage(String string, int n, int n2, byte[] byArray, byte[] byArray2) throws FopImageException {
            this.url = string;
            this.m_height = n2;
            this.m_width = n;
            this.m_bitsPerPixel = 8;
            this.m_colorSpace = new ColorSpace(ColorSpace.DEVICE_RGB);
            this.m_bitmaps = byArray;
            this.m_mask = byArray2;
        }

        public void close() {
        }

        public byte[] getBitmaps() throws FopImageException {
            return this.m_bitmaps;
        }

        public int getBitmapsSize() throws FopImageException {
            return this.m_width * this.m_height * 3;
        }

        public int getBitsPerPixel() throws FopImageException {
            return this.m_bitsPerPixel;
        }

        public ColorSpace getColorSpace() throws FopImageException {
            return this.m_colorSpace;
        }

        public int getHeight() throws FopImageException {
            return this.m_height;
        }

        public byte[] getMask() throws FopImageException {
            return this.m_mask;
        }

        public PDFFilter getPDFFilter() throws FopImageException {
            return null;
        }

        public byte[] getRessourceBytes() throws FopImageException {
            return null;
        }

        public int getRessourceBytesSize() throws FopImageException {
            return 0;
        }

        public PDFColor getTransparentColor() throws FopImageException {
            return this.transparent;
        }

        public String getURL() {
            return this.url;
        }

        public int getWidth() throws FopImageException {
            return this.m_width;
        }

        public boolean invertImage() {
            return false;
        }

        public boolean isTransparent() throws FopImageException {
            return this.transparent != null;
        }
    }

    static class PDFGraphicsConfiguration
    extends GraphicsConfiguration {
        static BufferedImage BIWithAlpha = new BufferedImage(1, 1, 2);
        static BufferedImage BIWithOutAlpha = new BufferedImage(1, 1, 1);

        PDFGraphicsConfiguration() {
        }

        public BufferedImage createCompatibleImage(int n, int n2) {
            return new BufferedImage(n, n2, 2);
        }

        public BufferedImage createCompatibleImage(int n, int n2, int n3) {
            if (n3 == 1) {
                return new BufferedImage(n, n2, 1);
            }
            return new BufferedImage(n, n2, 2);
        }

        public Rectangle getBounds() {
            System.out.println("getting getBounds");
            return null;
        }

        public ColorModel getColorModel() {
            return BIWithAlpha.getColorModel();
        }

        public ColorModel getColorModel(int n) {
            if (n == 1) {
                return BIWithOutAlpha.getColorModel();
            }
            return BIWithAlpha.getColorModel();
        }

        public AffineTransform getDefaultTransform() {
            System.out.println("getting getDefaultTransform");
            return new AffineTransform();
        }

        public GraphicsDevice getDevice() {
            return new PDFGraphicsDevice(this);
        }

        public AffineTransform getNormalizingTransform() {
            System.out.println("getting getNormalizingTransform");
            return new AffineTransform(2.0f, 0.0f, 0.0f, 2.0f, 0.0f, 0.0f);
        }
    }

    static class PDFGraphicsDevice
    extends GraphicsDevice {
        GraphicsConfiguration gc;

        PDFGraphicsDevice(PDFGraphicsConfiguration pDFGraphicsConfiguration) {
            this.gc = pDFGraphicsConfiguration;
        }

        public GraphicsConfiguration getBestConfiguration(GraphicsConfigTemplate graphicsConfigTemplate) {
            return this.gc;
        }

        public GraphicsConfiguration[] getConfigurations() {
            return new GraphicsConfiguration[]{this.gc};
        }

        public GraphicsConfiguration getDefaultConfiguration() {
            return this.gc;
        }

        public String getIDstring() {
            return this.toString();
        }

        public int getType() {
            return 1;
        }
    }
}

