#ifndef lint
static char *RCSid = "$Header: /m/webster/src/c/misc/RCS/printindex.c,v 1.2 86/12/26 22:04:29 davy Exp $";
#endif

/*
 * printindex - print the index file.
 *
 * David A. Curry
 * Purdue University
 * Engineering Computer Network
 * Original: April, 1986
 * Revised: December, 1986
 *
 * $Log:	printindex.c,v $
 * Revision 1.2  86/12/26  22:04:29  davy
 * Changed to print the DBM file index.
 * 
 */
#include <sys/types.h>
#include <sys/time.h>
#include <sys/file.h>
#include <sys/resource.h>
#include <ctype.h>
#include <stdio.h>
#include <ndbm.h>

#include "../h/index.h"
#include "../h/wordfiles.h"

char word[BUFSIZ];

struct index idx;			/* index for this word		*/
struct header hdr;			/* the header			*/

main(argc, argv)
int argc;
char **argv;
{
	DBM *db;
	register int i;
	char buf[BUFSIZ];
	register FILE *fp;
	struct rlimit rlim;
	datum key, content;
	char *s = "abcdefghijklmnopqrstuvwxyz0123456789-'";

	/*
	 * Kick our limits.
	 */
	rlim.rlim_max = rlim.rlim_cur = RLIM_INFINITY;
	setrlimit(RLIMIT_FSIZE, &rlim);
	setrlimit(RLIMIT_STACK, &rlim);
	setrlimit(RLIMIT_DATA, &rlim);

	/*
	 * Read and print the header.
	 */
	sprintf(buf, "%s/%s", wordfiledir, wordfilehdr);

	if ((fp = fopen(buf, "r")) == NULL) {
		fprintf(stderr, "printindex: cannot open \"%s\".\n", buf);
		exit(1);
	}

	fread(&hdr, sizeof(struct header), 1, fp);

	printf("NUMBER OF WORDS: %d\n", hdr.h_nwords);
	printf("DATABASE SIZE:   %d\n", hdr.h_idxsize);

	if (argc == 1) {
		while (*s) {
			printf("%c starts at %d\n", *s, hdr.h_starts[SUBSCRIPT(*s)]);
			s++;
		}
	}

	fclose(fp);

	/*
	 * Open the index and index database.
	 */
	sprintf(buf, "%s/%s", wordfiledir, wordfileindex);

	if ((fp = fopen(buf, "r")) == NULL) {
		fprintf(stderr, "printindex: cannot open \"%s\".\n", buf);
		exit(1);
	}

	if ((db = dbm_open(buf, O_RDONLY, 0644)) == NULL) {
		fprintf(stderr, "printindex: cannot open index database.\n");
		exit(1);
	}
	
	if (argc == 1) {
		/*
		 * For each word in the index...
		 */
		while (fgets(buf, BUFSIZ, fp) != NULL) {
			buf[strlen(buf) - 1] = NULL;

			/*
			 * Look it up in the database.
			 */
			key.dptr = buf;
			key.dsize = strlen(buf);

			content = dbm_fetch(db, key);

			/*
			 * "Never" happens.
			 */
			if (content.dptr == NULL) {
				printf("\"%s\": not in database.\n", buf);
				continue;
			}

			/*
			 * Print the information.
			 */
			idx = *(struct index *) content.dptr;

			printf("\"%s\": %d in %s\n", buf, idx.i_filepos, wordfiles[idx.i_file]);
		}
	}
	else {
		while (--argc) {
			/*
			 * Look it up in the database.
			 */
			key.dptr = *++argv;
			key.dsize = strlen(*argv);

			content = dbm_fetch(db, key);

			/*
			 * "Never" happens.
			 */
			if (content.dptr == NULL) {
				printf("\"%s\": not in database.\n", *argv);
				continue;
			}

			/*
			 * Print the information.
			 */
			idx = *(struct index *) content.dptr;

			printf("\"%s\": %d in %s\n", *argv, idx.i_filepos, wordfiles[idx.i_file]);
		}
	}

	exit(0);
}
