/*
 * index.h - stuff dealing with the index file.
 *
 * David A. Curry
 * Purdue University
 * davy@ee.purdue.edu
 * April, 1986
 */
#define NSUBSCRIPTS	38
#define MAXANSWERS	256		/* number of answers (search.c)	*/
#define ANSWERSIZE	128		/* size of an answer (search.c)	*/

/*
 * Convert a character to a subscript:
 *		abcdefghijklmnopqrstuvwxyz0123456789-'
 */
#define SUBSCRIPT(c) \
	((c) == '\'' ? 0 : ((c) == '-') ? 1 : (isdigit((c)) ? ((c) - '0' + 2) : (isalpha((c)) ? ((c) - 'a' + 12) : 0)))

/*
 * Index file header.
 */
struct header {
	int	h_nwords;	/* number of words in the dictionary	*/
	daddr_t	h_idxsize;	/* size of the index file		*/
	daddr_t	h_starts[NSUBSCRIPTS];	/* starting points of letters	*/
};

/*
 * Index file entry.
 */
struct index {
	short	i_file;		/* file word is in (subscript)		*/
	daddr_t	i_filepos;	/* position in the file (for seek)	*/
};

/*
 * An answer to a search.
 */
struct answer {
	short	a_idxok;	/* 1 if idx structure valid		*/
	struct index a_idx;	/* index structure for this word	*/
	char	a_word[ANSWERSIZE]; /* the word				*/
};
