#!./mtwish -f
#
# Example of a threaded Tk program
#
# This program would be simpler without threads, so don't take this
# as an example of what to do with threads.

set countdown_script  {
    share abort count_lock
    set count {}
    foreach i {10 9 8 7 6 5 4 3 2 1} {
	set count "$count $i..."
	mutex lock $count_lock
	if {$abort}  { thread exit }
	thread post thread1 ".b configure -text \"$count\""
	mutex unlock $count_lock
	thread sleep 1
    }
    mutex lock $count_lock
    if {$abort}  { thread exit }
    thread post thread1 ".b configure -anchor c -text {BLASTOFF!} -command {}"
    mutex unlock $count_lock
}

share abort count_lock
set abort 0
set count_lock [mutex create]

proc abort {tid}  {
    share abort count_lock
    mutex lock $count_lock
    set abort 1
    .b configure -anchor c -text {ABORT!} -command {}
    mutex unlock $count_lock
}

button .b -width 50
.b configure -anchor w
pack .b

.b configure -command {abort $count_thread}

set count_thread [thread create $countdown_script]

