/*
 *
 * c o n t . c				-- Continuations management
 *
 * Copyright (C) 1993, 1994 Erick Gallesio - I3S - CNRS / UNSA <eg@unice.fr>
 * 
 *
 * Permission to use, copy, and/or distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that both the above copyright notice and this permission notice appear in
 * all copies and derived works.  Fees for distribution or use of this
 * software or derived works may only be charged with express written
 * permission of the copyright holder.  
 * This software is provided ``as is'' without express or implied warranty.
 *
 * This software is a derivative work of other copyrighted softwares; the
 * copyright notices of these softwares are placed in the file COPYRIGHTS
 *
 *
 *           Author: Erick Gallesio [eg@kaolin.unice.fr]
 *    Creation date:  8-Nov-1993 11:34
 * Last file update:  5-Apr-1994 11:59
 */

#include "stk.h"


static void lunwind(SCM stop, int n);

#ifdef sun
#define FLUSH_REGISTERS_WINDOW()	asm("t 0x3") /* Stolen in  in Elk 2.0 */
#else
#define FLUSH_REGISTERS_WINDOW()
#endif

/* Don't allocate these vars on stack */
static char *from, *to;
static long length;
static SCM escaped_value;
static int  i;
static char *p;


static int get_stack_length(void)
{
  char stack_limit;
  
  return (&stack_limit < stack_start_ptr) ? stack_start_ptr - &stack_limit
					  : &stack_limit - stack_start_ptr;
}

PRIMITIVE call_cc(SCM proc)
{
  SCM z;

  if (procedurep(proc) == ntruth)
    err("call-with-current-continuation: bad procedure", proc);

  /* Find the start adress and the length of the stack to save */
  length = get_stack_length();
  from   = (stack_start_ptr<(char *)&z) ? stack_start_ptr : stack_start_ptr-length;

  /* Allocate a new object for this continuation */
  NEWCELL(z, tc_cont);

  z->storage_as.cont.data = must_malloc(sizeof(struct cont) + length);

  C_START(z) 	  = from;
  C_LEN(z)   	  = length;
  C_WIND_STACK(z) = wind_stack;
  FLUSH_REGISTERS_WINDOW();
  for (i=length, to = C_STACK(z); i--; ) *to++ = *from++;

  /* Use a setjmp/longjmp for the continuation */
  if (setjmp(C_ENV(z)) == 0) {
    return apply(proc, cons(z, NIL));
  }
  else {
    return escaped_value;
  }
}

void throw(SCM fct, SCM val)
{
  static SCM tmp;
  union {
    char stack_end;
    char hole[1024]; /* Reserve 1K on stack */
  }u;

  /* Evaluate room on stack. If not enough call throw again to alloc. a new hole */
  if (&u.stack_end < stack_start_ptr) {
    /* Stack grows downward */
    if (&u.stack_end > C_START(fct)) throw(fct, val);
  }
  else {
    /* Stack grows upward */
    if (&u.stack_end < C_START(fct)+ C_LEN(fct)) throw(fct, val);
  }

  /* Take care of active dynamic-winds */
  tmp = C_WIND_STACK(fct);
  lunwind(tmp, llength(wind_stack) - llength(tmp));

  /* Save val in a global and reset stack as it was before calling call/cc */
  escaped_value = val; tmp = fct;
  FLUSH_REGISTERS_WINDOW();
  for(to=C_START(fct), from=C_STACK(fct), i=C_LEN(fct); i--; ) *to++ = *from++;

  /* And Go! */
  longjmp(C_ENV(tmp), JMP_THROW);
}

PRIMITIVE continuationp(SCM obj)
{
  return CONTINUATIONP(obj)? truth: ntruth;
}

/******************************************************************************
 *
 * Dynamic wind 
 *
 ******************************************************************************/

void lunwind_all(void)
{
  SCM p;

  for (p = wind_stack; NNULLP(p); p = CDR(p)) {
    wind_stack = CDR(p);
    apply(CAR(CDR(CAR(p))), NIL);
  }
}

static void lunwind(SCM stop, int n)
{
  if (wind_stack != stop) {
    if (n < 0) {
      lunwind(CDR(stop),n+1);
      apply(CAR(CAR(stop)),NIL);
      wind_stack = stop;
    }
    else {
      SCM old_wind_stack = wind_stack;
      
      wind_stack = CDR(wind_stack);
      apply(CAR(CDR(CAR(old_wind_stack))), NIL);
      lunwind(stop, n-1);
    }
  }
}

static void test_procedure(SCM thunk)
{
  if (procedurep(thunk) == ntruth) 
    err("dynamic-wind: bad procedure", thunk);
}

PRIMITIVE dynamic_wind(SCM thunk1, SCM thunk2, SCM thunk3)
{
  SCM result;

  test_procedure(thunk1);
  test_procedure(thunk2);
  test_procedure(thunk3);

  apply(thunk1, NIL);
  wind_stack = cons(LIST2(thunk1, thunk3), wind_stack);
  result = apply(thunk2, NIL);
  wind_stack = CDR(wind_stack);
  apply(thunk3, NIL);
  return result;
}
