/*
 *
 * l i s t . c			-- Lists procedures
 *
 * Copyright (C) 1993, 1994 Erick Gallesio - I3S - CNRS / UNSA <eg@unice.fr>
 * 
 *
 * Permission to use, copy, and/or distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that both the above copyright notice and this permission notice appear in
 * all copies and derived works.  Fees for distribution or use of this
 * software or derived works may only be charged with express written
 * permission of the copyright holder.  
 * This software is provided ``as is'' without express or implied warranty.
 *
 * This software is a derivative work of other copyrighted softwares; the
 * copyright notices of these softwares are placed in the file COPYRIGHTS
 *
 *
 *           Author: Erick Gallesio [eg@kaolin.unice.fr]
 *    Creation date: ??-Oct-1993 21:37
 * Last file update:  6-May-1994 18:14
 */

#include "stk.h"

PRIMITIVE pairp(SCM x)
{
  return CONSP(x) ? truth : ntruth;
}

PRIMITIVE cons(SCM x, SCM y)
{
  SCM z;
  NEWCELL(z,tc_cons);
  CAR(z) = x;
  CDR(z) = y;
  return z;
}

PRIMITIVE car(SCM x)
{
  if (TYPEP(x, tc_cons)) return CAR(x);
  err("car: wrong type of argument", x);
}

PRIMITIVE cdr(SCM x)
{
  if (TYPEP(x, tc_cons)) return CDR(x);
  err("cdr: wrong type of argument", x);
}

PRIMITIVE setcar(SCM cell, SCM value)
{
  if NCONSP(cell) err("set-car!: wrong type of argument", cell);
  CAR(cell) = value;
  return UNDEFINED;
}

PRIMITIVE setcdr(SCM cell, SCM value)
{
  if NCONSP(cell) err("set-cdr!: wrong type of argument", cell);
  CDR(cell) = value;
  return UNDEFINED;
}

static SCM internal_cxr(SCM l, char *fct)
{
  register SCM tmp = l;
  register char *p;

  for(p = fct + strlen(fct)-1; *p != 'X'; p--) {
    if (NCONSP(tmp)) {
      char name[50];
      sprintf(name, "c%sr: bad list", fct+1);
      err(name, l);
    }
    tmp = (*p == 'a') ? CAR(tmp) : CDR(tmp);
  }
  return tmp;
}

PRIMITIVE caar  (SCM l) { return internal_cxr(l, "Xaa");   }
PRIMITIVE cdar  (SCM l) { return internal_cxr(l, "Xda");   }
PRIMITIVE cadr  (SCM l) { return internal_cxr(l, "Xad");   }
PRIMITIVE cddr  (SCM l) { return internal_cxr(l, "Xdd");   }
PRIMITIVE caaar (SCM l) { return internal_cxr(l, "Xaaa");  }
PRIMITIVE cdaar (SCM l) { return internal_cxr(l, "Xdaa");  }
PRIMITIVE cadar (SCM l) { return internal_cxr(l, "Xada");  }
PRIMITIVE cddar (SCM l) { return internal_cxr(l, "Xdda");  }
PRIMITIVE caadr (SCM l) { return internal_cxr(l, "Xaad");  }
PRIMITIVE cdadr (SCM l) { return internal_cxr(l, "Xdad");  }
PRIMITIVE caddr (SCM l) { return internal_cxr(l, "Xadd");  }
PRIMITIVE cdddr (SCM l) { return internal_cxr(l, "Xddd");  }
PRIMITIVE caaaar(SCM l) { return internal_cxr(l, "Xaaaa"); }
PRIMITIVE cdaaar(SCM l) { return internal_cxr(l, "Xdaaa"); }
PRIMITIVE cadaar(SCM l) { return internal_cxr(l, "Xadaa"); }
PRIMITIVE cddaar(SCM l) { return internal_cxr(l, "Xddaa"); }
PRIMITIVE caadar(SCM l) { return internal_cxr(l, "Xaada"); }
PRIMITIVE cdadar(SCM l) { return internal_cxr(l, "Xdada"); }
PRIMITIVE caddar(SCM l) { return internal_cxr(l, "Xadda"); }
PRIMITIVE cdddar(SCM l) { return internal_cxr(l, "Xddda"); }
PRIMITIVE caaadr(SCM l) { return internal_cxr(l, "Xaaad"); }
PRIMITIVE cdaadr(SCM l) { return internal_cxr(l, "Xdaad"); }
PRIMITIVE cadadr(SCM l) { return internal_cxr(l, "Xadad"); }
PRIMITIVE cddadr(SCM l) { return internal_cxr(l, "Xddad"); }
PRIMITIVE caaddr(SCM l) { return internal_cxr(l, "Xaadd"); }
PRIMITIVE cdaddr(SCM l) { return internal_cxr(l, "Xdadd"); }
PRIMITIVE cadddr(SCM l) { return internal_cxr(l, "Xaddd"); }
PRIMITIVE cddddr(SCM l) { return internal_cxr(l, "Xdddd"); }

PRIMITIVE nullp(SCM x)
{
  return EQ(x, NIL) ? truth: ntruth;
}

int llength(SCM l)
{
  register SCM start = l;
  register int len   = 0;
	
  for ( ; ; ) {
    if (NULLP(l)) return len;
    if ((l == start && len) || NCONSP(l)) return -1;
    l = CDR(l);
    len += 1;
  }
}

PRIMITIVE listp(SCM x)
{
  return (llength(x) < 0) ? ntruth : truth;
}

PRIMITIVE list(SCM l)
{
  return l;
}

PRIMITIVE list_length(SCM l)
{
  int len = llength(l);
  if (len >= 0) return makeinteger((double) len);
  err("length: not calculable.", NIL);
}

static SCM append2(SCM l1, SCM l2)
{
  register SCM res, p;

  if (NULLP(l1)) return l2;
  if (NCONSP(l1)) goto Error;

  for (res = NIL; ; l1 = CDR(l1)) {
    if (NCONSP(l1))      goto Error;
    if (res == NIL){
      NEWCELL(res, tc_cons);
      p = res;
    }
    else {
      NEWCELL(CDR(p), tc_cons);
      p = CDR(p);
    }
    CAR(p) = CAR(l1);
    if (NCONSP(CDR(l1))) break;
  }
  CDR(p) = l2;
  return res;
Error: 
   err("append: argument is not a list", l1);
}

PRIMITIVE append(SCM l)
{
  switch (llength(l)) {
  case 0:  return NIL;
  case 1:  return CAR(l);
  case 2:  return append2(CAR(l), CAR(CDR(l)));
  default: return append2(CAR(l), append(CDR(l)));
  }
}

PRIMITIVE reverse(SCM l)
{
  SCM p, n = NIL;

  for(p=l; NNULLP(p); p=CDR(p)) {
    if (NCONSP(p)) err("reverse: bad list", l);
    n = cons(CAR(p),n);
  }
  return n;
}

PRIMITIVE list_tail(SCM list, SCM k)
{
  register long x;

  if (NCONSP(list)) err("list-tail: Bad list", list);
  x = integer_value(k);
  if (x >= 0) {
    SCM l = list;

    for (l=list; x > 0; x--) {
      if (NULLP(l) || NCONSP(l)) err("list-tail: list too short", list);
      l = CDR(l);
    }
    return l;
  }
  err("list-tail: index must be exact positive integer", k);
}

PRIMITIVE list_ref(SCM list, SCM k)
{
  register long x;

  if (NCONSP(list)) err("list-ref: Bad list", list);	
  x = integer_value(k);
  if (x >= 0) {
    SCM l = list;

    for ( ; x > 0; x--) {
      if (NULLP(l) || NCONSP(l)) goto Error;
      l = CDR(l);
    }
    
    if (CONSP(l)) return CAR(l);
  Error: 
    err("list-ref: list too short", list);
  }
  err("list-ref: index must be exact positive integer", k);
}

static SCM lmember(SCM obj, SCM list,  SCM (*predicate)(SCM, SCM) )
{
  register SCM ptr;
	
  if (NCONSP(list) && NNULLP(list)) goto Error;
  for (ptr=list; NNULLP(ptr); ) { 
    if (CONSP(ptr)) {
      if ((*predicate)(CAR(ptr), obj) == truth) return ptr;
    }
    else 
      /* end of a dotted list */
      return ((*predicate)(ptr, obj) == truth) ? ptr : ntruth;
    if ((ptr=CDR(ptr)) == list) goto Error;
  }
  return ntruth;
Error:
  err("member function: Bad list", list);
}

PRIMITIVE memq  (SCM obj, SCM list)	{return lmember(obj, list, eq);   }
PRIMITIVE memv  (SCM obj, SCM list)	{return lmember(obj, list, eqv);  }
PRIMITIVE member(SCM obj, SCM list)	{return lmember(obj, list, equal);}

static SCM lassoc(SCM obj, SCM alist, SCM (*predicate)(SCM, SCM))
{
  register SCM l,tmp;
	
  for(l=alist; CONSP(l); ) {
    tmp = CAR(l);
    if (CONSP(tmp) && (*predicate)(CAR(tmp), obj) == truth) return tmp;
    if ((l=CDR(l)) == alist) goto Error;
  }
  if (NULLP(l)) return(ntruth);
Error:
  err("assoc function: improper list", alist);
}

PRIMITIVE assq (SCM obj, SCM alist){return lassoc(obj, alist, eq);   }
PRIMITIVE assv (SCM obj, SCM alist){return lassoc(obj, alist, eqv);  }
PRIMITIVE assoc(SCM obj, SCM alist){return lassoc(obj, alist, equal);}


/***
 *
 * Non standard functions 
 *
 ***/

PRIMITIVE liststar(SCM l)
{
  if (NULLP(l)) return NIL;
  /* l is a pair */
  return NULLP(CDR (l)) ? CAR(l)
    		        : cons(CAR(l), liststar(CDR(l)));
}

PRIMITIVE copy_tree(SCM l)
{
  return CONSP(l) ? cons(copy_tree(CAR(l)), copy_tree(CDR(l))): l;
}
