/*
 *
 * t k - g l u e . c 		- Glue function between the scheme and Tk worlds
 *
 * Copyright (C) 1993, 1994 Erick Gallesio - I3S - CNRS / UNSA <eg@unice.fr>
 * 
 *
 * Permission to use, copy, and/or distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that both the above copyright notice and this permission notice appear in
 * all copies and derived works.  Fees for distribution or use of this
 * software or derived works may only be charged with express written
 * permission of the copyright holder.  
 * This software is provided ``as is'' without express or implied warranty.
 *
 * This software is a derivative work of other copyrighted softwares; the
 * copyright notices of these softwares are placed in the file COPYRIGHTS
 *
 *
 *            Author: Erick Gallesio [eg@unice.fr]
 *    Creation date: 19-Feb-1993 22:15
 * Last file update:  3-Jun-1994 10:30
 *
 *
 */

#ifdef USE_TK
#include <varargs.h>
#include "stk.h"

#define MAXARG 64	/* Max args on stack. Use malloc if greater */

/* Scheme objects used to represent the "." pseudo widget and its name */
SCM root_window, root_window_name;

/* 
 * In STk, result of a Tk primitive result is parsed to try to have a 
 * a result whose type is as convenient as possible.
 * However, certain command results are kept as string to avoid problems.
 */

static char *keeping[] =  {
  "option",
  "selection",
  "tk",
  "wm", 
  ""
};

void Keep_result_as_string(char *s) 
{
  SCM tmp = VCELL(intern(s));

  if (TKCOMMP(tmp))
    tmp->storage_as.tk.data->string_result = 1;
}


static SCM TkResult2Scheme(Tcl_Interp *interp)
{
  register char*s= interp->result;
  register SCM tmp1, tmp2, z, port;
  SCM result = NIL;
  int eof;

  if (*s) {
    /* Create a string port to read in the result */
    port = internal_open_input_string(s);
    result = internal_read_from_string(port, &eof, TRUE);
    if (result == sym_dot) result = root_window_name;

    if (!eof) {
      /*  Result was a list of value, build a proper Scheme list */
      tmp1 = result = cons(result, NIL);
      for ( ; ; ) {
	z = internal_read_from_string(port, &eof, TRUE);
	if (z == EVAL_ERROR || EOFP(z)) break;
	if (z == sym_dot) z = root_window_name;
	NEWCELL(tmp2, tc_cons);
	CAR(tmp2) = z; 
	CDR(tmp1) = tmp2;
	tmp1      = tmp2;
      }
      CDR(tmp1) = NIL;
    }
    /* close_string_port(port); */
  }

  Tcl_ResetResult(interp); 
  return (result == EVAL_ERROR)? UNDEFINED: result;
}

static SCM TkResult2String(Tcl_Interp *interp)
{
  register char *tmp, *d, *s= interp->result;
  register int len,newlen;
  SCM z;

  /* Build a Scheme string from Tk result and free the interp->result */
  len = newlen = strlen(s);
  tmp = d = must_malloc(len+1); /* overestimation */
  
  while (len--) {
    if (*s == '\\') {s++; newlen--;}
    *d++ = *s++;
  }
  
  /* Create a new Scheme string */
  NEWCELL(z, tc_string);
  z->storage_as.string.dim          = newlen;
  z->storage_as.string.data         = tmp;
  z->storage_as.string.data[newlen] = 0;
  Tcl_ResetResult(interp);
  return z;
}


char *convert_for_tk(SCM obj)
{
  switch (TYPE(obj)) {
    case tc_symbol:    return PNAME(obj);
    case tc_integer:
    case tc_bignum:
    case tc_flonum:    return CHARS(number2string(obj, UNBOUND));
    case tc_string:    return CHARS(obj);
    case tc_tkcommand: return (obj->storage_as.tk.data)->Id;
    case tc_keyword:   return obj->storage_as.keyword.data;
    case tc_boolean:   return (obj == truth)? "1" : "0";
    default:           /* Ok, take the big hammer (i.e. use a string port for 
			* type coercion) Here, use write (and not display) 
			* since it handles complex data structures containing
			* eventually special chars which must be escaped
			* Ex: (bind .w "<Enter>" '(display "<Enter>"))
			*     First <Enter> is unquotted and second is not
			*/
		       {
			 SCM port, res;
			 
			 port = open_output_string();
			 lprint(obj, port->storage_as.port.f, TK_MODE); 
			 res = get_output_string(port);
			 return CHARS(res);
		       }
  }
}

 
SCM execute_Tk_lib_cmd(SCM cmd, SCM args, SCM env, int eval_args)
{
  char *buffer[MAXARG+1];
  int tkres;
  char **argv 		= buffer;
  int argc  		= llength(args);
  SCM start 		= args;
  struct Tk_command *W	= cmd->storage_as.tk.data;

  if (argc > MAXARG) {
    /* allocate dynamically the argv array */
    argv=(char **) must_malloc((argc+1) * sizeof(char *));
  }

  /* First initialize an argv array */
  argv[0] = cmd->storage_as.tk.data->Id;
  
  for (argc = 1; NNULLP(args); args=CDR(args)) {
    if (NCONSP(args)) err("Malformed list of arguments", start);
    argv[argc++] = convert_for_tk(eval_args ? leval(CAR(args), env):
				              CAR(args));
  }
  argv[argc] = NULL;

  /* Capture the current environment in the command */
  

  /* Now, call the Tk library function */
  Tcl_ResetResult(main_interp);

  tkres = (*W->fct)(W->ptr, main_interp, argc, argv);
  
  if (argv != buffer) {
    /* argv was allocated dynamically. Dispose it */
    free(argv);
  }
  
  /* return result as a string or "evaluated" dependind of string_result field */

  if (tkres == TCL_OK)
    return cmd->storage_as.tk.data->string_result? TkResult2String(main_interp)
						 : TkResult2Scheme(main_interp);
  
  err(main_interp->result, NIL);
}

void init_glue(void)
{
  char **s;

  /* 
   * Take into account the fact that Tk main window  name (i.e. ``.'') 
   * cannot be used in list since it leads to erroneous evaluation 
   * (e.g. [focus .] would produce an error since read will find a malformed
   * pair).
   *
   */
  gc_protect(root_window_name = intern(ROOT_WINDOW));
  gc_protect(root_window      = leval(intern("."), NIL));
  VCELL(root_window_name)     =  root_window;

  for (s = keeping; **s; s++)
    Keep_result_as_string(*s);
}

#endif /* USE_TK */
