/* endian.c
* Demonstrates endian ordering
*/

#include <stdio.h>

void main( void )
{
	short   Data16; 
	long    Data32;
	char far *p;

	Data16 = 0x1234;
	Data32 = 0x56789abc;

	p = (char far *)&Data16;
	printf("16-bit quantity, data=%04x\n", Data16);
	printf("address %Fp = %02x\n", p, (int)(*p) & 0xff);
	p++ ;
	printf("address %Fp = %02x\n", p, (int)(*p) & 0xff);
	p++ ;


	p = (char far *)&Data32;
	printf("32-bit quantity, data=%08lx\n", Data32);
	printf("address %Fp = %02x\n", p, (int)(*p) & 0xff);
	p++ ;
	printf("address %Fp = %02x\n", p, (int)(*p) & 0xff);
	p++ ;
	printf("address %Fp = %02x\n", p, (int)(*p) & 0xff);
	p++ ;
	printf("address %Fp = %02x\n", p, (int)(*p) & 0xff);

}
