%{
/* 	$Id: seshl.l,v 2.5 1995/06/07 11:27:47 rosmord Exp $	 */

#include "quadra.h"
#include "sesh.h"
#include "hache.h"
#include "fonctions.h"

#undef YYLMAX
#define YYLMAX 10240
#include <string.h>
#include <strings.h>
#include <stdio.h>

#define G(x) {yylval=g(x); return HIEROGLYPHE;}
#define Commence(x) BEGIN(x); etat=x;

extern union _Donnees g(char *x, int sens); /* OK, c'est mal */
extern int signe_trouve;

extern TABLE definitions;

void traite();

char * nomdefine;

int dieze=0;
int couleur=0;
int signe_lu= FALSE;
int signe_deja_lu= FALSE;
int etat= INITIAL;
extern int numligne;
void TLIGNE();

/* Les ligatures */

char * les_ligatures[]= {
  "\\ligAROBDd ",
  "\\ligAROBD",
  "\\ligAROBDt",
  "\\ligAROBDra",
  "\\hierCC",
  "\\hierXX"
};

%}

entier	([0-9]+)
INTEGER	(-?{entier})
gardiner	(([A-Z]|Aa){entier}a*)
ident	([a-zA-Z0-9.'`]+)
ESPS	([ \t\n]+)
ESPSO	([ \t\n-]*)
ESP	([ \t\n])

%s DEFINE0 DEFINE1 HieroText TEXTEIMBR


%%
 	switch(etat)
	{ case INITIAL: BEGIN(INITIAL);break;
	  case HieroText: BEGIN(HieroText);break;
	}
                                        /* infamous trick. # should have ONE meaning */
                                        if ( signe_lu )
                                        { 
                                           if (signe_deja_lu) 
                                              { signe_deja_lu = FALSE; signe_lu= FALSE; }
                                           else
                                              { signe_deja_lu= TRUE;}
                                        }

<INITIAL>(.)	{ECHO; return TEXTE;}
<INITIAL>(\n)	{ECHO; numligne++; return TEXTE;}
<INITIAL>"\\hieroglyph"[ \n\t]*         |
<INITIAL>"\\begin{hieroglyph}"[ \n\t]*	{ TLIGNE();
	  Commence(HieroText); 
                                          signe_lu= FALSE;
                                          return DEBUTHIEROGS;}

<DEFINE0>{ESPS}	BEGIN(DEFINE1);
<DEFINE1>[^#]*"#"{ESP}*	{ char *pt;
	char *s= strdup(yytext);
	TLIGNE();
	pt= s + yyleng;
	while (*(--pt) != '#');
	*pt= 0;
	stocke(nomdefine, s);
	Commence(HieroText);}

<HieroText>{ESP}*"\\endhieroglyph"      |
<HieroText>{ESP}*"\\end{hieroglyph}"	{ TLIGNE(); Commence(INITIAL); return FINHIEROGS;}
<HieroText>D:d	{yylval.une_donnee.texte= les_ligatures[0];
 /*  mieux vaudrait des noms symboliques */
	  signe_lu= TRUE;
	  return LIGATURE;
	}

<HieroText>"o"	return POINTROUGE;
<HieroText>"O"	return POINTNOIR;
	 
<HieroText>D	{yylval.une_donnee.texte= les_ligatures[1];
	 signe_lu= TRUE;
	 return LIGATURE;}

<HieroText>D:t	{yylval.une_donnee.texte= les_ligatures[2];
                                          signe_lu= TRUE;
	 return LIGATURE;}
<HieroText>D:ra	{yylval.une_donnee.texte= les_ligatures[3];
                                          signe_lu= TRUE;
	 return LIGATURE;}
<HieroText>200	{yylval.une_donnee.texte= les_ligatures[4];
                                         signe_lu= TRUE;
	 return LIGATURE;} 
<HieroText>20	{yylval.une_donnee.texte= les_ligatures[5];
              	 signe_lu= TRUE;
	 return LIGATURE;}

<HieroText>"aA\\r1"	{ yylval.une_donnee =g("aAv",0); 
	  if (!signe_trouve) {REJECT } 
	  else { signe_lu= TRUE; return HIEROGLYPHE;}
	}

<HieroText>"Y1\\r3"	{ yylval.une_donnee =g("Y1v",0); 
	  if (!signe_trouve) {REJECT } 
	  else { signe_lu= TRUE; return HIEROGLYPHE;}
	}

<HieroText>{ident}	|
<HieroText>([A-Z]|Aa){entier}A*	{ yylval.une_donnee =g(yytext,0); 
	  if (!signe_trouve) {REJECT } 
	  else { signe_lu= TRUE; return HIEROGLYPHE;}
	}

<HieroText>","{ident}	{traite(yytext+1);}
<HieroText>"#def"{ESPS}{ident}	{ int i;
	  for (i=4; yytext[i] && (yytext[i] == ' ' || yytext[i]== '\t');
	       i++);
	  if  (yytext[i])
	  {
	    nomdefine=strdup(yytext+i);
	    BEGIN (DEFINE0);
	  }
	  else
	    yyerror("Mauvaise definition");
	}
<HieroText>"="	|
<HieroText>"-="	|
<HieroText>"-"	{ 
                                          yylval.un_separateur= S_intersignes; 
                                          return SEPARATEUR;
                                        }
<HieroText>{ESPS}	|
<HieroText>{ESPS}"-"	{
                                          TLIGNE(); 
                                          yylval.un_separateur= S_espace; 
                                          return SEPARATEUR;
                                        }
<HieroText>\n	{
                                         numligne++;
                                         yylval.un_separateur= S_espace; 
                                         return SEPARATEUR;
                                        }
<HieroText>[- \t\n]?"!"[\n \t-=]*	{
                                          TLIGNE(); 
                                          yylval.un_separateur= S_finligne;
                                          return SEPARATEUR;
                                        }
<HieroText>"-"?"!!"[\n \t-=]*	{ 
                                          TLIGNE();
                                          yylval.un_separateur= S_finpage;
                                          return SEPARATEUR;
                                        }
<HieroText>":="	return ':';
<HieroText>"*="	return '*';
<HieroText>{ESP}*"*"{ESP}*	return '*';
<HieroText>{ESP}*":"{ESP}*	{return ':'; }
<HieroText>"+l"	BEGIN(TEXTEIMBR);
<HieroText>"+dg"	return DROITEGAUCHE;
<HieroText>"+gd"	return GAUCHEDROITE;
<HieroText>{ESPSO}"+lr"	return LEFTRIGHT;
<HieroText>"+rl"{ESPSO}	return RIGHTLEFT;

<HieroText>"|"[^-]+	{ yylval.une_donnee.texte= strdup(yytext+1);
	  return TEXTESUPER;
	}
<HieroText>\\!	return KERNING;
<HieroText>"."	return POINT;
<HieroText>".."	return POINTPOINT;
<HieroText>{ident}	{traite(yytext); /* les macros-definitions !!! */}
<HieroText>"//"	return HACHUREG;
<HieroText>"h/"	return HACHUREH;
<HieroText>"v/"	return HACHUREV;
<HieroText>"/"	return HACHURET;
<HieroText>"#//"	return HACHUREGA;
<HieroText>"#h/"	return HACHUREHA ;
<HieroText>"#v/"	return HACHUREVA;
<HieroText>"#/"	return HACHURETA;
<HieroText>"^"	return HAPLOGRAPHIE;
<HieroText>"?"	return LACUNE;
<HieroText>"??"	return  LIGNELACUNE;
<HieroText>"[{"{ESPSO}	return DSTSUPERFETATOIRE;
<HieroText>{ESPSO}"}]"	return FSTSUPERFETATOIRE;
<HieroText>"[["{ESPSO}	return DSTEFFACE;
<HieroText>{ESPSO}"]]"	return FSTEFFACE;
<HieroText>"[\""{ESPSO}	return  DSTDISPARU ;
<HieroText>{ESPSO}"\"]"	return  FSTDISPARU ;
<HieroText>"['"{ESPSO}	return  DSTRAJOUTSCRIBE;
<HieroText>{ESPSO}"']"	return  FSTRAJOUTSCRIBE;
<HieroText>"[&"{ESPSO}	return  DSTRAJOUTAUTEUR;
<HieroText>{ESPSO}"&]"	return  FSTRAJOUTAUTEUR;
<HieroText>"<"{ESPSO}	{yylval.un_typegroupe= S_carto; return DEBUTCONSTRUCTION;}
<HieroText>"<b"{ESPSO}	{yylval.un_typegroupe= S_debcarto; return DEBUTCONSTRUCTION;}
<HieroText>"<m"{ESPSO}	{yylval.un_typegroupe= S_milcarto; return DEBUTCONSTRUCTION;}
<HieroText>"<e"{ESPSO}	{yylval.un_typegroupe= S_fincarto; return DEBUTCONSTRUCTION;}
<HieroText>{ESPSO}">"	{return CARTF;}
<HieroText>"<S"{ESPSO}	{yylval.un_typegroupe= S_serekh; return DEBUTCONSTRUCTION;}
<HieroText>"<F"{ESPSO}	{yylval.un_typegroupe= S_enceinte; return DEBUTCONSTRUCTION;}
<HieroText>"<H"{ESPSO}	{yylval.un_typegroupe= S_chateau; return DEBUTCONSTRUCTION;}
<HieroText>"<Sb"{ESPSO}	{yylval.un_typegroupe= S_debserekh; return DEBUTCONSTRUCTION;}
<HieroText>"<Sm"{ESPSO}	{yylval.un_typegroupe= S_milserekh; return DEBUTCONSTRUCTION;}
<HieroText>"<Se"{ESPSO}	{yylval.un_typegroupe= S_finserekh; return DEBUTCONSTRUCTION;}
<HieroText>"<Fb"{ESPSO}	{yylval.un_typegroupe= S_debenceinte; return DEBUTCONSTRUCTION;}
<HieroText>"<Fm"{ESPSO}	{yylval.un_typegroupe= S_milenceinte; return DEBUTCONSTRUCTION;}
<HieroText>"<Fe"{ESPSO}	{yylval.un_typegroupe= S_finenceinte; return DEBUTCONSTRUCTION;}
<HieroText>"<Hb"{ESPSO}	{yylval.un_typegroupe= S_debchateau; return DEBUTCONSTRUCTION;}
<HieroText>"<Hm"{ESPSO}	{yylval.un_typegroupe= S_milchateau; return DEBUTCONSTRUCTION;}
<HieroText>"<He"{ESPSO}	{yylval.un_typegroupe= S_finchateau; return DEBUTCONSTRUCTION;}
<HieroText>"#"	{if (signe_lu) return OVERWRITE; else REJECT;}
<HieroText>{ESPSO}"-#-"{ESPSO}	{ dieze=1-dieze; /* ne compliquons pas la grammaire */
	  if (dieze==1) return DIEZE0;
	  else return DIEZE1;}
<HieroText>\-?"$"\-?	{ couleur=1-couleur; /* ne compliquons pas la grammaire */
	  if (couleur==1) return COULEUR0;
	  else return COULEUR1;}
<HieroText>\\	{return REVERT;}
<HieroText>\\s[0-9]	{
                                          yylval.un_entier= atoi(yytext+2); 
                                          return SIZE;  
                                        }
<HieroText>\\R{INTEGER}	{
                                          yylval.un_entier= atoi(yytext+2); 
                                          return ROTATION;  
                                        }
<HieroText>(.)	return yytext[0];

<TEXTEIMBR>"+s"	{ yylval.une_donnee.texte= strdup(yytext);
	  yylval.une_donnee.texte[strlen(yylval.une_donnee.texte)-2]=0;
	  return ROMAIN;
	}
<TEXTEIMBR>(.|\n)	{TLIGNE(); yymore(); }
%%

void traite(texte)
     char * texte;
{
  int i;
  char *result;
  if ((result= trouve(texte, definitions)))
    {
      for (i=strlen(result) -1; i> -1; i--)
        unput(result[i]);		
    }
  else
  {
    char toto[300];
    sprintf(toto, "texte non reconnu: %s", texte);
    yyerror(toto);
  }
}

void TLIGNE()
{
  char *s;
  s= yytext;
  while ((s= strchr(s, '\n')))
  {
    numligne++;
    s++;
  }
}

/* 
 * Local Variables:
 * mode: c
 * tab-width: 40
 * End:
 */
