#!/usr/bin/perl
use strict;
use CGI qw(:standard :cgi-lib);

# server-side signup script

$ENV{PATH} = '';

my $username = param("username");

# Complain unless submitted username contains only valid characters
complain("bad username") unless($username =~ /^[\w_-]+$/);

# Complain if the submitted username is "root"
complain("bad username") if($username eq "root");

my $homedir;
if(substr($username, 0, 2) =~ /[_-\d]+/) {
  $homedir = "/afs/athena.mit.edu/user/other/$username";
}
else {
  my $c1 = substr($username, 0, 1);
  my $c2 = substr($username, 1, 1);
  $homedir = "/afs/athena.mit.edu/user/$c1/$c2/$username";
}

#my $scriptsdir = "$homedir/web_scripts";

# Run ls to confirm user's homedir and obtain user's homedir uid
my $ls_regexp = '^\S*\s+\S*\s+(\S*)\s+\S*\s+\S*\s+\S*\s+\S*\s+\S*\s+(\S*).*$';
my ($uid1, $name1) = (`/bin/ls -dln '$homedir'` =~ $ls_regexp);

# Complain if user's homedir does not exist
complain("homedir not found") if($name1 ne $homedir);

# Complain if user's uid is too low or too high
complain("bad uid") if($uid1 < 110 or $uid1 > 1000000);

# Run ls to confirm user's scriptsdir and obtain user's scriptsdir uid
#my ($uid2, $name2) = (`/bin/ls -dln '$scriptsdir'` =~ $ls_regexp);

# Complain if user's scriptsdir does not exist
#complain("scriptsdir not found") if($name2 ne $scriptsdir);

# Complain if scriptsdir uid does not match homedir uid
#complain("scriptsdir uid != homedir uid") if($uid2 ne $uid1);

# Complain if user's uid is already taken
complain("uid already taken") if(getpwuid $uid1);

# Add user to /etc/passwd
`/usr/bin/sudo -u root /usr/sbin/useradd -d '$homedir' -s '/usr/local/bin/modbash' -u '$uid1' -g '99' '$username'`;

# Add user to /etc/users (used by apache log-handling script)
open(USERS, ">>/etc/users");
print USERS "$username\n";
close(USERS);

# Do parts of setup that require afsagent privileges 
`/usr/bin/sudo -u afsagent /usr/local/bin/setup_user $username`;

# "Complain" that we are done
complain("done");

sub complain {
  my ($complaint) = @_;
  print <<ENDHTML;
Content-type: text/html;

<html>
<head></head>
<body><b>$complaint</b></body>
</html>
ENDHTML
  exit(0);
}
