;;; standalone-graphic.sc

;;; $Header: /deneb/src0/johani/scix-0.93/demo/RCS/standalone-graphic.sc,v 1.1 90/03/19 16:08:54 johani Exp $

(module graphic (main do-graphic))

(include "../include/objects.sch")
(include "../include/lw-objects.sch")
(include "../include/msg-handler.sch")
(include "../include/masks.sch")

(include "graphic.sc")

(define (usage)
  (display "Usage: graphic [-size size] [-display display]") 
  (newline))

(define (do-graphic clargs)
  (let ((dpy #f) (size 400))
    (let loop ((ls (cdr clargs)))
      (cond ((null? ls) #t)
	    ((and (equal? (car ls) "-size")
		  (not (null? (cdr ls)))
		  (string->number (cadr ls)) )
	     (set! size (string->number (cadr ls)))
	     (loop (cddr ls)) )
	    ((and (equal? (car ls) "-display")
		  (not (null? (cdr ls)))
		  (string? (cadr ls)) )
	     (set! dpy (make-display (cadr ls)))
	     (loop (cddr ls)) )
	    (else
	     (usage)
	     (exit) )))
    (if (not dpy)
	(set! dpy (make-display "")) )
    (demo-graphic size 'smart (dpy 'defaultscreen)) ))
