/*
 *               Copyright 1990 by Digital Equipment AB, Sweden
 * 
 *                                   and
 * 
 *                        Hakan Huss and Johan Ihren
 * 
 *                            All Rights Reserved
 * 
 *     Permission to use, copy, modify, and distribute this software and
 *     its documentation for any purpose and without fee is hereby
 *     granted, provided that the above copyright notice appear in all
 *     copies and that both that copyright notice and this permis-
 *     sion notice appear in supporting documentation, and that the
 *     names of the copyright holders not be used in advertising in
 *     publicity pertaining to distribution of the software without
 *     specific, written prior permission. The copyright holders make no
 *     representations about the suitability of this software for any
 *     purpose. It is provided "as is" without express or implied warranty.
 * 
 *     THE COPYRIGHT HOLDERS DISCLAIM ALL WARRANTIES WITH REGARD TO
 *     THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANT-
 *     ABILITY AND FITNESS, IN NO EVENT SHALL THE COPYRIGHT HOLDERS
 *     BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 *     ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR
 *     PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 *     TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE
 *     OR PERFORMANCE OF THIS SOFTWARE.
 * 
 *     Authors: Hakan Huss, KTH and Johan Ihren, KTH
 */

/*
 * fast-types.c -- C versions of the primitive X protocol types.
 * Note that currently they are byte-order-dependent---can't have that really.
 */

typedef char           INT8;
typedef short          INT16;
typedef long           INT32;
typedef unsigned char  CARD8;
typedef unsigned short CARD16;
typedef unsigned long  CARD32;

static int curpos = 0;

void zero_buffer_position()
  {
  curpos = 0;
  }

int current_buffer_position()
  {
  return curpos;
  }

/*
 * a_<datatype> -- all these functions return the amount of padding needed to
 *                 make it a multiple of four bytes long.
 */
int a_int8(n, curbuf)
INT8 n;
char *curbuf;
  {
  curbuf[curpos++] = n;
  return 3;
  }


int a_int16(n, curbuf)
INT16 n;
char *curbuf;
  {
  *(INT16 *)&curbuf[curpos] = n;
  curpos += sizeof(INT16);
  return 2;
  }

int a_int32(n, curbuf)
INT32 n;
char *curbuf;
  {
  *(INT32 *)&curbuf[curpos] = n;
  curpos += sizeof(INT32);
  return 0;
  }

int a_card8(n, curbuf)
CARD8 n;
char *curbuf;
  {
  int i;

  curbuf[curpos++] = n;
  return 3;
  }

int a_card16(n, curbuf)
CARD16 n;
char *curbuf;
  {
  int i;

  *(CARD16 *)&curbuf[curpos] = n;
  curpos += sizeof(CARD16);
  return 2;
  }

int a_card32(n, curbuf)
CARD32 n;
char *curbuf;
  {
  *(CARD32 *)&curbuf[curpos] = n;
  curpos += sizeof(CARD32);
  return 0;
  }

int a_string8x(s, len, curbuf)
char *s, *curbuf;
int len;
  {
  bcopy(s, &curbuf[curpos], len);
  curpos += len;
  curpos += ((4 - (len & 3)) & 3);
  return 0;
  }

/* Ugly */
int a_pad(n, curbuf)
int n;
char *curbuf;
  {
  curpos += n;
  }

int a_strx(s, len, curbuf)
char *s, *curbuf;
int len;
  {
  curbuf[curpos++] = (CARD8) len;
  bcopy(s, &curbuf[curpos], len);
  curpos += len;
  }

int strapp(s1, s2, len1, len2)
char *s1, *s2;
int len1, len2;
  {
  bcopy((char *)s2, (char *)s1 + len1, len2);
  return len1 + len2;
  }
