#ifndef lint
static char Xrcsid[] = "";
#endif /* lint */

#include <stdio.h>

#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>

#include <X11/Xaw/XawInit.h>
#include <X11/Xmu/Misc.h>
#include "PersonP.h"

#include "sitting.bitmap"
#include "speaker.bitmap"
#include "request.bitmap"

/****************************************************************
 *
 * Full class record constant
 *
 ****************************************************************/

/* Private Data */

/* This is a hack, see the comments in ClassInit(). */

extern XtActionList xaw_command_actions_list;

static char defaultTranslations[] =
    "<EnterWindow>:	    highlight()		\n\
     <LeaveWindow>:	    unhighlight()	\n\
     <Btn1Down>,<Btn1Up>:   notify()";

#define offset(field) XtOffset(PersonWidget, field)

static XtResource resources[] = {
   {XtNpose, XtCPose, XtRInt, sizeof(int),
      offset(person.pose), XtRImmediate, (caddr_t) PERSON_SITTING},
};

static void	Initialize(), PersonNotify();
static void	Redisplay();
static void	PersonHighlight(), PersonUnhighlight();
static void	ClassInit();
static Boolean	SetValues();

static XtActionsRec actionsList[] =
{
  {"notify",		PersonNotify},
  {"highlight",		PersonHighlight},
  {"unhighlight",	PersonUnhighlight},
};

#define SuperClass ((CommandWidgetClass)&commandClassRec)

PersonClassRec personClassRec = {
  {
    (WidgetClass) SuperClass,		/* superclass		  */	
    "Person",				/* class_name		  */
    sizeof(PersonRec),			/* size			  */
    ClassInit,				/* class_initialize	  */
    NULL,				/* class_part_initialize  */
    FALSE,				/* class_inited		  */
    Initialize,				/* initialize		  */
    NULL,				/* initialize_hook	  */
    XtInheritRealize,			/* realize		  */
    actionsList,			/* actions		  */
    XtNumber(actionsList),		/* num_actions		  */
    resources,				/* resources		  */
    XtNumber(resources),		/* resource_count	  */
    NULLQUARK,				/* xrm_class		  */
    FALSE,				/* compress_motion	  */
    TRUE,				/* compress_exposure	  */
    TRUE,				/* compress_enterleave    */
    FALSE,				/* visible_interest	  */
    NULL,         			/* destroy		  */
    XtInheritResize,			/* resize		  */
    Redisplay,				/* expose		  */
    SetValues,				/* set_values		  */
    NULL,				/* set_values_hook	  */
    XtInheritSetValuesAlmost,		/* set_values_almost	  */
    NULL,				/* get_values_hook	  */
    NULL,				/* accept_focus		  */
    XtVersion,				/* version		  */
    NULL,				/* callback_private	  */
    defaultTranslations,		/* tm_table		  */
    XtInheritQueryGeometry,		/* query_geometry	  */
    XtInheritDisplayAccelerator,	/* display_accelerator	  */
    NULL				/* extension		  */
  },  /* CoreClass fields initialization */
  {
    XtInheritChangeSensitive		/* change_sensitive	  */ 
  },  /* SimpleClass fields initialization */
  {
    0                                     /* field not used    */
  },  /* LabelClass fields initialization */
  {
    0                                     /* field not used    */
  },  /* CommmandClass fields initialization */
  {
	NULL,				/* sitting pixmap */
	NULL,				/* standing pixmap */
	NULL,				/* request pixmap */
  },  /* PersonClass fields initialization */
};

  /* for public consumption */
WidgetClass personWidgetClass = (WidgetClass) &personClassRec;

/****************************************************************
 *
 * Private Procedures
 *
 ****************************************************************/

static void 
Initialize(request, new)
Widget request, new;
{
	PersonWidget tw = (PersonWidget) new;
	PersonWidget tw_req = (PersonWidget) request;

	if (!tw->core.height)
		tw->core.height = sitting_height;
	if (!tw->core.width)
		tw->core.width = sitting_width;

/*
	tw->person.state = PERSON_SITTING;
*/
}

static void
ClassInit()
{
	PersonWidgetClass class = (PersonWidgetClass) personWidgetClass;

	XawInitializeWidgetSet();
}

/************************************************************
 *
 *  Action Procedures
 *
 ************************************************************/

static void	
PersonHighlight(w, event, params, num_params)
Widget w;
XEvent *event;
String *params;		/* unused */
Cardinal *num_params;	/* unused */
{
}

static void	
PersonUnhighlight(w, event, params, num_params)
Widget w;
XEvent *event;
String *params;		/* unused */
Cardinal *num_params;	/* unused */
{
}

/* ARGSUSED */
static void PersonNotify(w,event,params,num_params)
PersonWidget w;
XEvent *event;
String *params;		/* unused */
Cardinal *num_params;	/* unused */
{
  XtCallCallbacks(w, XtNcallback, (XtPointer) w->command.set);
}

/************************************************************
 *
 * Set specified arguments into widget
 *
 ***********************************************************/

/* ARGSUSED */
static Boolean 
SetValues (current, request, new)
Widget current, request, new;
{
    PersonWidget oldtw = (PersonWidget) current;
    PersonWidget tw = (PersonWidget) new;

    if (oldtw->person.pose != tw->person.pose) {
	return(TRUE);
    }

    return(FALSE);
}

/*
 * Repaint the widget window
 */

/* ARGSUSED */
static void 
Redisplay(w, event, region)
Widget w;
XEvent *event;
Region region;
{
	PersonWidget cw = (PersonWidget) w;
	GC gc;
	char *label = cw->label.label;
	Position y = cw->label.label_y + cw->label.font->max_bounds.ascent;
	PersonWidgetClass class = (PersonWidgetClass) w->core.widget_class;
	int hoffset, voffset;

	hoffset = (w->core.width - sitting_width) / 2;
	voffset = (w->core.height - sitting_height);

	if (!XtWindow(w))
		return;

	if (!class->person_class.sitting_pixmap) {

		class->person_class.sitting_pixmap =
 			XCreateBitmapFromData (
                        	XtDisplay(w),
                        	XtWindow(w),
                        	sitting_bits,
                        	sitting_width,
                        	sitting_height);

		class->person_class.request_pixmap =
 			XCreateBitmapFromData (
                        	XtDisplay(w),
                        	XtWindow(w),
                        	request_bits,
                        	request_width,
                        	request_height);

		class->person_class.speaker_pixmap =
 			XCreateBitmapFromData (
                        	XtDisplay(w),
                        	XtWindow(w),
                        	speaker_bits,
                        	speaker_width,
                        	speaker_height);

	}

	gc = XtIsSensitive((Widget)cw)?	cw->label.normal_GC : 
					cw->label.gray_GC;

	switch (cw->person.pose) {
	case PERSON_SITTING:
		XCopyPlane (	XtDisplay(w), 
				class->person_class.sitting_pixmap,
				XtWindow(w), gc,
				0, 0, sitting_width, sitting_height,
				(int) hoffset,
				(int) voffset,
				(unsigned long) 1L);
		break;
	case PERSON_REQUEST:
		XCopyPlane (	XtDisplay(w), 
				class->person_class.request_pixmap,
				XtWindow(w), gc,
				0, 0, request_width, request_height,
				(int) hoffset,
				(int) voffset,
				(unsigned long) 1L);
		break;
	case PERSON_SPEAKER:
		XCopyPlane (	XtDisplay(w), 
				class->person_class.speaker_pixmap,
				XtWindow(w), gc,
				0, 0, speaker_width, speaker_height,
				(int) hoffset,
				(int) voffset,
				(unsigned long) 1L);
		break;
	}
}
