/* $Id: XmuX.h,v 1.1.1.1 90/11/28 16:43:04 altenhof Exp $ */

/*
 * Copyright (C) 1990 by Digital Equipment Corporation.
 * 
 * Author: Michael P. Altenhofen, CEC Karlsruhe e-mail:
 * Altenhofen@kampus.enet.dec.com
 * 
 * This file ist part of Shared X
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation without fee is hereby granted, but only for non-profit  use
 * and distribution,  and provided  that the copyright notice and this notice
 * is preserved on all copies.
 * 
 * DIGITAL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 * DIGITAL BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */

/*
 * Public definition header file used with Xlib Multiplex extension (XmuX)
 */

#ifndef _XMUX_H
#define _XMUX_H

/*
 * want we need are some definitions to allow communication with XmuX via
 * ClientMessage Events and Properties; this implies that we need to create
 * unique atoms
 */

#define _MUX_CPORT       0
#define _MUX_MESSAGE     1
#define _MUX_HOSTS       2
#define _MUX_CHALKHOLDER 3

#define XMUX_MESSAGE_NAME   "XMUX_MESSAGE"	/* should be used in
						 * XInternAtom to create/get
						 * the unique XMUX_MESSAGE
						 * Atom */
#define XMUX_CPORT_NAME  "XMUX_CPORT"	/* should be used in XInternAtom to
					 * create/get the unique XMUX_CPORT
					 * Atom */

#define XMUX_HOSTS_NAME "XMUX_HOSTS"	/* /* should be used in XInternAtom
					 * to create/get the unique
					 * XMUX_HOSTS Atom */

#define XMUX_CHALKHOLDER_NAME "XMUX_CHALKHOLDER"

/*
 * should be used in XInternAtom to create/get the unique XMUX_CHALKHOLDER
 * Atom
 */


#define XMUX_MESSAGE_FORMAT 32	/* we use long values to communicate with
				 * messages */

#define MuxAdd     '+'
#define MuxRemove  '-'

/*
#define MuxLock    'l'
#define MuxUnlock  'u'
*/

#define MuxGrant   'g'

#define XMUXType     0
#define XMUXSubtype  1
#define XMUXDetail   2
#define XMUXDetail2  3

/*****************************************************************
 * The different possible meanings of this new message type are defined as
 * constants; clients are recommended to use these constants or (even better)
 * to use the convenience functions that hide these details) when
 * communicating with XmuX.
 * LOGICAL STRUCTURE:
 * xmessage.data.l [0] --> message type: Action/Information/Error
 * xmessage.data.l [1] --> message subtype: e.g. Error-DuplicationFailed
 *****************************************************************/

/* message types */

#define XMUXAction  (1L << 0)
#define XMUXInfo    (1L << 1)
#define XMUXError   (1L << 2)

/* message subtypes */

/* action subtypes */
#define XMUXPassChalk	0L
#define XMUXDebug	1L
#define XMUXLock	2L
#define XMUXUnLock	3L

#define DbgEvents    1L
#define DbgRequests  2L
#define DbgResources 3L
#define DbgMux       4L
#define DbgAll       5L

/* Information subtypes */
#define XMUXMuxSetup    0L	/* XmuX says: "I'm trying to multiplex an
				 * application" */
#define XMUXBroadSetup  1L	/* XmuX says: "I'm trying to broadcast an
				 * application" */
#define XMUXChalkPassed 2L	/* XmuX says: "I've passed the chalk" */

#define XMUXFinished    3L	/* XmuX says: "I've successfully finished
				 * multiplexing/broadcasting" */
/* error subtypes */
#define XMUXMuxFailed   0L	/* XmuX says: "I'm sorry, can't multiplex" */
#define XMUXBroadFailed 1L	/* XmuX says: "I'm sorry, can't braodcast */

#define XMUXProperty 0
#define XMUXMessage  1

typedef
struct _XmuXHints {
  int type;			/* message or property */
  union {
    char *strings[2];
    long mess[3];
  } u;
} XmuXHints;

#endif
